/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.query;

import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="QueryDataRequest")
@Generated(from="QueryDataRequest", generator="Immutables")
@Immutable
public final class ImmutableQueryDataRequest
implements QueryDataRequest {
    private final String entityIdentifier;
    @Nullable
    private final List<String> selectedFieldNames;
    @Nullable
    private final String filterExpression;
    private final Long maxResults;
    @Nullable
    private final String nextToken;
    private final ConnectorContext connectorContext;

    private ImmutableQueryDataRequest(Builder builder) {
        this.entityIdentifier = builder.entityIdentifier;
        this.selectedFieldNames = builder.selectedFieldNames == null ? null : ImmutableQueryDataRequest.createUnmodifiableList(true, builder.selectedFieldNames);
        this.filterExpression = builder.filterExpression;
        this.nextToken = builder.nextToken;
        this.connectorContext = builder.connectorContext;
        this.maxResults = builder.maxResults != null ? builder.maxResults : Objects.requireNonNull(QueryDataRequest.super.maxResults(), "maxResults");
    }

    private ImmutableQueryDataRequest(String entityIdentifier, @Nullable List<String> selectedFieldNames, @Nullable String filterExpression, Long maxResults, @Nullable String nextToken, ConnectorContext connectorContext) {
        this.entityIdentifier = entityIdentifier;
        this.selectedFieldNames = selectedFieldNames;
        this.filterExpression = filterExpression;
        this.maxResults = maxResults;
        this.nextToken = nextToken;
        this.connectorContext = connectorContext;
    }

    @Override
    @JsonProperty(value="entityIdentifier")
    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    @JsonProperty(value="selectedFieldNames")
    @Nullable
    public List<String> selectedFieldNames() {
        return this.selectedFieldNames;
    }

    @Override
    @JsonProperty(value="filterExpression")
    @Nullable
    public String filterExpression() {
        return this.filterExpression;
    }

    @Override
    @JsonProperty(value="maxResults")
    public Long maxResults() {
        return this.maxResults;
    }

    @Override
    @JsonProperty(value="nextToken")
    @Nullable
    public String nextToken() {
        return this.nextToken;
    }

    @Override
    @JsonProperty(value="connectorContext")
    public ConnectorContext connectorContext() {
        return this.connectorContext;
    }

    public final ImmutableQueryDataRequest withEntityIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "entityIdentifier");
        if (this.entityIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryDataRequest(newValue, this.selectedFieldNames, this.filterExpression, this.maxResults, this.nextToken, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withSelectedFieldNames(String ... elements) {
        if (elements == null) {
            return new ImmutableQueryDataRequest(this.entityIdentifier, null, this.filterExpression, this.maxResults, this.nextToken, this.connectorContext);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableQueryDataRequest.createUnmodifiableList(false, ImmutableQueryDataRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableQueryDataRequest(this.entityIdentifier, newValue, this.filterExpression, this.maxResults, this.nextToken, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withSelectedFieldNames(@Nullable Iterable<String> elements) {
        if (this.selectedFieldNames == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableQueryDataRequest.createUnmodifiableList(false, ImmutableQueryDataRequest.createSafeList(elements, true, false));
        return new ImmutableQueryDataRequest(this.entityIdentifier, newValue, this.filterExpression, this.maxResults, this.nextToken, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withFilterExpression(@Nullable String value) {
        if (Objects.equals(this.filterExpression, value)) {
            return this;
        }
        return new ImmutableQueryDataRequest(this.entityIdentifier, this.selectedFieldNames, value, this.maxResults, this.nextToken, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withMaxResults(Long value) {
        Long newValue = Objects.requireNonNull(value, "maxResults");
        if (this.maxResults.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryDataRequest(this.entityIdentifier, this.selectedFieldNames, this.filterExpression, newValue, this.nextToken, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withNextToken(@Nullable String value) {
        if (Objects.equals(this.nextToken, value)) {
            return this;
        }
        return new ImmutableQueryDataRequest(this.entityIdentifier, this.selectedFieldNames, this.filterExpression, this.maxResults, value, this.connectorContext);
    }

    public final ImmutableQueryDataRequest withConnectorContext(ConnectorContext value) {
        if (this.connectorContext == value) {
            return this;
        }
        ConnectorContext newValue = Objects.requireNonNull(value, "connectorContext");
        return new ImmutableQueryDataRequest(this.entityIdentifier, this.selectedFieldNames, this.filterExpression, this.maxResults, this.nextToken, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryDataRequest && this.equalTo(0, (ImmutableQueryDataRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryDataRequest another) {
        return this.entityIdentifier.equals(another.entityIdentifier) && Objects.equals(this.selectedFieldNames, another.selectedFieldNames) && Objects.equals(this.filterExpression, another.filterExpression) && this.maxResults.equals(another.maxResults) && Objects.equals(this.nextToken, another.nextToken) && this.connectorContext.equals(another.connectorContext);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.entityIdentifier.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.selectedFieldNames);
        h2 += (h2 << 5) + Objects.hashCode(this.filterExpression);
        h2 += (h2 << 5) + this.maxResults.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.nextToken);
        h2 += (h2 << 5) + this.connectorContext.hashCode();
        return h2;
    }

    public String toString() {
        return "QueryDataRequest{entityIdentifier=" + this.entityIdentifier + ", selectedFieldNames=" + this.selectedFieldNames + ", filterExpression=" + this.filterExpression + ", maxResults=" + this.maxResults + ", nextToken=" + this.nextToken + ", connectorContext=" + this.connectorContext + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueryDataRequest fromJson(Json json) {
        Builder builder = ImmutableQueryDataRequest.builder();
        if (json.entityIdentifier != null) {
            builder.entityIdentifier(json.entityIdentifier);
        }
        if (json.selectedFieldNames != null) {
            builder.addAllSelectedFieldNames(json.selectedFieldNames);
        }
        if (json.filterExpression != null) {
            builder.filterExpression(json.filterExpression);
        }
        if (json.maxResults != null) {
            builder.maxResults(json.maxResults);
        }
        if (json.nextToken != null) {
            builder.nextToken(json.nextToken);
        }
        if (json.connectorContext != null) {
            builder.connectorContext(json.connectorContext);
        }
        return builder.build();
    }

    public static ImmutableQueryDataRequest copyOf(QueryDataRequest instance) {
        if (instance instanceof ImmutableQueryDataRequest) {
            return (ImmutableQueryDataRequest)instance;
        }
        return ImmutableQueryDataRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="QueryDataRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_IDENTIFIER = 1L;
        private static final long INIT_BIT_CONNECTOR_CONTEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String entityIdentifier;
        private List<String> selectedFieldNames = null;
        @Nullable
        private String filterExpression;
        @Nullable
        private Long maxResults;
        @Nullable
        private String nextToken;
        @Nullable
        private ConnectorContext connectorContext;

        private Builder() {
        }

        public final Builder from(QueryDataRequest instance) {
            String filterExpressionValue;
            Objects.requireNonNull(instance, "instance");
            this.entityIdentifier(instance.entityIdentifier());
            List<String> selectedFieldNamesValue = instance.selectedFieldNames();
            if (selectedFieldNamesValue != null) {
                this.addAllSelectedFieldNames(selectedFieldNamesValue);
            }
            if ((filterExpressionValue = instance.filterExpression()) != null) {
                this.filterExpression(filterExpressionValue);
            }
            this.maxResults(instance.maxResults());
            String nextTokenValue = instance.nextToken();
            if (nextTokenValue != null) {
                this.nextToken(nextTokenValue);
            }
            this.connectorContext(instance.connectorContext());
            return this;
        }

        @JsonProperty(value="entityIdentifier")
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = Objects.requireNonNull(entityIdentifier, "entityIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSelectedFieldNames(String element) {
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = new ArrayList<String>();
            }
            this.selectedFieldNames.add(Objects.requireNonNull(element, "selectedFieldNames element"));
            return this;
        }

        public final Builder addSelectedFieldNames(String ... elements) {
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.selectedFieldNames.add(Objects.requireNonNull(element, "selectedFieldNames element"));
            }
            return this;
        }

        @JsonProperty(value="selectedFieldNames")
        public final Builder selectedFieldNames(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.selectedFieldNames = null;
                return this;
            }
            this.selectedFieldNames = new ArrayList<String>();
            return this.addAllSelectedFieldNames(elements);
        }

        public final Builder addAllSelectedFieldNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "selectedFieldNames element");
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.selectedFieldNames.add(Objects.requireNonNull(element, "selectedFieldNames element"));
            }
            return this;
        }

        @JsonProperty(value="filterExpression")
        public final Builder filterExpression(@Nullable String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        @JsonProperty(value="maxResults")
        public final Builder maxResults(Long maxResults) {
            this.maxResults = Objects.requireNonNull(maxResults, "maxResults");
            return this;
        }

        @JsonProperty(value="nextToken")
        public final Builder nextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @JsonProperty(value="connectorContext")
        public final Builder connectorContext(ConnectorContext connectorContext) {
            this.connectorContext = Objects.requireNonNull(connectorContext, "connectorContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableQueryDataRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryDataRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("connectorContext");
            }
            return "Cannot build QueryDataRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueryDataRequest", generator="Immutables")
    static final class Json
    implements QueryDataRequest {
        @Nullable
        String entityIdentifier;
        @Nullable
        List<String> selectedFieldNames = null;
        @Nullable
        String filterExpression;
        @Nullable
        Long maxResults;
        @Nullable
        String nextToken;
        @Nullable
        ConnectorContext connectorContext;

        Json() {
        }

        @JsonProperty(value="entityIdentifier")
        public void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @JsonProperty(value="selectedFieldNames")
        public void setSelectedFieldNames(@Nullable List<String> selectedFieldNames) {
            this.selectedFieldNames = selectedFieldNames;
        }

        @JsonProperty(value="filterExpression")
        public void setFilterExpression(@Nullable String filterExpression) {
            this.filterExpression = filterExpression;
        }

        @JsonProperty(value="maxResults")
        public void setMaxResults(Long maxResults) {
            this.maxResults = maxResults;
        }

        @JsonProperty(value="nextToken")
        public void setNextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
        }

        @JsonProperty(value="connectorContext")
        public void setConnectorContext(ConnectorContext connectorContext) {
            this.connectorContext = connectorContext;
        }

        @Override
        public String entityIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> selectedFieldNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String filterExpression() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long maxResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorContext connectorContext() {
            throw new UnsupportedOperationException();
        }
    }
}

