/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.CacheControl;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.metadata.Entity;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesResponse;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ListEntitiesResponse", generator="Immutables")
@Immutable
public final class ImmutableListEntitiesResponse
implements ListEntitiesResponse {
    private final boolean isSuccess;
    @Nullable
    private final ErrorDetails errorDetails;
    @Nullable
    private final ImmutableList<Entity> entities;
    @Nullable
    private final String nextToken;
    @Nullable
    private final CacheControl cacheControl;

    private ImmutableListEntitiesResponse(boolean isSuccess, @Nullable ErrorDetails errorDetails, @Nullable ImmutableList<Entity> entities, @Nullable String nextToken, @Nullable CacheControl cacheControl) {
        this.isSuccess = isSuccess;
        this.errorDetails = errorDetails;
        this.entities = entities;
        this.nextToken = nextToken;
        this.cacheControl = cacheControl;
    }

    @Override
    @JsonProperty(value="isSuccess")
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    @JsonProperty(value="errorDetails")
    @Nullable
    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    @JsonProperty(value="entities")
    @Nullable
    public ImmutableList<Entity> entities() {
        return this.entities;
    }

    @Override
    @JsonProperty(value="nextToken")
    @Nullable
    public String nextToken() {
        return this.nextToken;
    }

    @Override
    @JsonProperty(value="cacheControl")
    @Nullable
    public CacheControl cacheControl() {
        return this.cacheControl;
    }

    public final ImmutableListEntitiesResponse withIsSuccess(boolean value) {
        if (this.isSuccess == value) {
            return this;
        }
        return new ImmutableListEntitiesResponse(value, this.errorDetails, this.entities, this.nextToken, this.cacheControl);
    }

    public final ImmutableListEntitiesResponse withErrorDetails(@Nullable ErrorDetails value) {
        if (this.errorDetails == value) {
            return this;
        }
        return new ImmutableListEntitiesResponse(this.isSuccess, value, this.entities, this.nextToken, this.cacheControl);
    }

    public final ImmutableListEntitiesResponse withEntities(Entity ... elements) {
        if (elements == null) {
            return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, null, this.nextToken, this.cacheControl);
        }
        ImmutableList<Entity> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, newValue, this.nextToken, this.cacheControl);
    }

    public final ImmutableListEntitiesResponse withEntities(@Nullable Iterable<? extends Entity> elements) {
        if (this.entities == elements) {
            return this;
        }
        ImmutableList<Entity> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, newValue, this.nextToken, this.cacheControl);
    }

    public final ImmutableListEntitiesResponse withNextToken(@Nullable String value) {
        if (Objects.equals(this.nextToken, value)) {
            return this;
        }
        return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, this.entities, value, this.cacheControl);
    }

    public final ImmutableListEntitiesResponse withCacheControl(@Nullable CacheControl value) {
        if (this.cacheControl == value) {
            return this;
        }
        return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, this.entities, this.nextToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListEntitiesResponse && this.equalTo(0, (ImmutableListEntitiesResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableListEntitiesResponse another) {
        return this.isSuccess == another.isSuccess && Objects.equals(this.errorDetails, another.errorDetails) && Objects.equals(this.entities, another.entities) && Objects.equals(this.nextToken, another.nextToken) && Objects.equals(this.cacheControl, another.cacheControl);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Booleans.hashCode(this.isSuccess);
        h2 += (h2 << 5) + Objects.hashCode(this.errorDetails);
        h2 += (h2 << 5) + Objects.hashCode(this.entities);
        h2 += (h2 << 5) + Objects.hashCode(this.nextToken);
        h2 += (h2 << 5) + Objects.hashCode(this.cacheControl);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ListEntitiesResponse").omitNullValues().add("isSuccess", this.isSuccess).add("errorDetails", this.errorDetails).add("entities", this.entities).add("nextToken", this.nextToken).add("cacheControl", this.cacheControl).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListEntitiesResponse fromJson(Json json) {
        Builder builder = ImmutableListEntitiesResponse.builder();
        if (json.isSuccessIsSet) {
            builder.isSuccess(json.isSuccess);
        }
        if (json.errorDetails != null) {
            builder.errorDetails(json.errorDetails);
        }
        if (json.entities != null) {
            builder.addAllEntities(json.entities);
        }
        if (json.nextToken != null) {
            builder.nextToken(json.nextToken);
        }
        if (json.cacheControl != null) {
            builder.cacheControl(json.cacheControl);
        }
        return builder.build();
    }

    public static ImmutableListEntitiesResponse copyOf(ListEntitiesResponse instance) {
        if (instance instanceof ImmutableListEntitiesResponse) {
            return (ImmutableListEntitiesResponse)instance;
        }
        return ImmutableListEntitiesResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ListEntitiesResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_SUCCESS = 1L;
        private long initBits = 1L;
        private boolean isSuccess;
        @Nullable
        private ErrorDetails errorDetails;
        private ImmutableList.Builder<Entity> entities = null;
        @Nullable
        private String nextToken;
        @Nullable
        private CacheControl cacheControl;

        private Builder() {
        }

        public final Builder from(ListEntitiesResponse instance) {
            CacheControl cacheControlValue;
            String nextTokenValue;
            List<Entity> entitiesValue;
            Objects.requireNonNull(instance, "instance");
            this.isSuccess(instance.isSuccess());
            ErrorDetails errorDetailsValue = instance.errorDetails();
            if (errorDetailsValue != null) {
                this.errorDetails(errorDetailsValue);
            }
            if ((entitiesValue = instance.entities()) != null) {
                this.addAllEntities(entitiesValue);
            }
            if ((nextTokenValue = instance.nextToken()) != null) {
                this.nextToken(nextTokenValue);
            }
            if ((cacheControlValue = instance.cacheControl()) != null) {
                this.cacheControl(cacheControlValue);
            }
            return this;
        }

        @JsonProperty(value="isSuccess")
        public final Builder isSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="errorDetails")
        public final Builder errorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final Builder addEntities(Entity element) {
            if (this.entities == null) {
                this.entities = ImmutableList.builder();
            }
            this.entities.add((Object)element);
            return this;
        }

        public final Builder addEntities(Entity ... elements) {
            if (this.entities == null) {
                this.entities = ImmutableList.builder();
            }
            this.entities.add(elements);
            return this;
        }

        @JsonProperty(value="entities")
        public final Builder entities(@Nullable Iterable<? extends Entity> elements) {
            if (elements == null) {
                this.entities = null;
                return this;
            }
            this.entities = ImmutableList.builder();
            return this.addAllEntities(elements);
        }

        public final Builder addAllEntities(Iterable<? extends Entity> elements) {
            Objects.requireNonNull(elements, "entities element");
            if (this.entities == null) {
                this.entities = ImmutableList.builder();
            }
            this.entities.addAll(elements);
            return this;
        }

        @JsonProperty(value="nextToken")
        public final Builder nextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @JsonProperty(value="cacheControl")
        public final Builder cacheControl(@Nullable CacheControl cacheControl) {
            this.cacheControl = cacheControl;
            return this;
        }

        public ImmutableListEntitiesResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableListEntitiesResponse(this.isSuccess, this.errorDetails, (ImmutableList)(this.entities == null ? null : this.entities.build()), this.nextToken, this.cacheControl);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isSuccess");
            }
            return "Cannot build ListEntitiesResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListEntitiesResponse", generator="Immutables")
    static final class Json
    implements ListEntitiesResponse {
        boolean isSuccess;
        boolean isSuccessIsSet;
        @Nullable
        ErrorDetails errorDetails;
        @Nullable
        List<Entity> entities = null;
        @Nullable
        String nextToken;
        @Nullable
        CacheControl cacheControl;

        Json() {
        }

        @JsonProperty(value="isSuccess")
        public void setIsSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.isSuccessIsSet = true;
        }

        @JsonProperty(value="errorDetails")
        public void setErrorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        @JsonProperty(value="entities")
        public void setEntities(@Nullable List<Entity> entities) {
            this.entities = entities;
        }

        @JsonProperty(value="nextToken")
        public void setNextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
        }

        @JsonProperty(value="cacheControl")
        public void setCacheControl(@Nullable CacheControl cacheControl) {
            this.cacheControl = cacheControl;
        }

        @Override
        public boolean isSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorDetails errorDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Entity> entities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public CacheControl cacheControl() {
            throw new UnsupportedOperationException();
        }
    }
}

