/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.metadata.Entity;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="Entity", generator="Immutables")
@Immutable
public final class ImmutableEntity
implements Entity {
    private final String entityIdentifier;
    private final boolean hasNestedEntities;
    private final boolean isWritable;
    @Nullable
    private final String label;
    @Nullable
    private final String description;
    @Nullable
    private final ImmutableMap<String, String> customProperties;

    private ImmutableEntity(Builder builder) {
        this.entityIdentifier = builder.entityIdentifier;
        this.hasNestedEntities = builder.hasNestedEntities;
        this.label = builder.label;
        this.description = builder.description;
        this.customProperties = builder.customProperties == null ? null : builder.customProperties.build();
        this.isWritable = builder.isWritableIsSet() ? builder.isWritable : Entity.super.isWritable();
    }

    private ImmutableEntity(String entityIdentifier, boolean hasNestedEntities, boolean isWritable, @Nullable String label, @Nullable String description, @Nullable ImmutableMap<String, String> customProperties) {
        this.entityIdentifier = entityIdentifier;
        this.hasNestedEntities = hasNestedEntities;
        this.isWritable = isWritable;
        this.label = label;
        this.description = description;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="entityIdentifier")
    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    @JsonProperty(value="hasNestedEntities")
    public boolean hasNestedEntities() {
        return this.hasNestedEntities;
    }

    @Override
    @JsonProperty(value="isWritable")
    public boolean isWritable() {
        return this.isWritable;
    }

    @Override
    @JsonProperty(value="label")
    @Nullable
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @JsonProperty(value="customProperties")
    @Nullable
    public ImmutableMap<String, String> customProperties() {
        return this.customProperties;
    }

    public final ImmutableEntity withEntityIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "entityIdentifier");
        if (this.entityIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableEntity(newValue, this.hasNestedEntities, this.isWritable, this.label, this.description, this.customProperties);
    }

    public final ImmutableEntity withHasNestedEntities(boolean value) {
        if (this.hasNestedEntities == value) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, value, this.isWritable, this.label, this.description, this.customProperties);
    }

    public final ImmutableEntity withIsWritable(boolean value) {
        if (this.isWritable == value) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, value, this.label, this.description, this.customProperties);
    }

    public final ImmutableEntity withLabel(@Nullable String value) {
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, this.isWritable, value, this.description, this.customProperties);
    }

    public final ImmutableEntity withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, this.isWritable, this.label, value, this.customProperties);
    }

    public final ImmutableEntity withCustomProperties(@Nullable Map<String, ? extends String> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableEntity(this.entityIdentifier, this.hasNestedEntities, this.isWritable, this.label, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntity && this.equalTo(0, (ImmutableEntity)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntity another) {
        return this.entityIdentifier.equals(another.entityIdentifier) && this.hasNestedEntities == another.hasNestedEntities && this.isWritable == another.isWritable && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description) && Objects.equals(this.customProperties, another.customProperties);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.entityIdentifier.hashCode();
        h2 += (h2 << 5) + Booleans.hashCode(this.hasNestedEntities);
        h2 += (h2 << 5) + Booleans.hashCode(this.isWritable);
        h2 += (h2 << 5) + Objects.hashCode(this.label);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + Objects.hashCode(this.customProperties);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("Entity").omitNullValues().add("entityIdentifier", this.entityIdentifier).add("hasNestedEntities", this.hasNestedEntities).add("isWritable", this.isWritable).add("label", this.label).add("description", this.description).add("customProperties", this.customProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntity fromJson(Json json) {
        Builder builder = ImmutableEntity.builder();
        if (json.entityIdentifier != null) {
            builder.entityIdentifier(json.entityIdentifier);
        }
        if (json.hasNestedEntitiesIsSet) {
            builder.hasNestedEntities(json.hasNestedEntities);
        }
        if (json.isWritableIsSet) {
            builder.isWritable(json.isWritable);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.customProperties != null) {
            builder.putAllCustomProperties(json.customProperties);
        }
        return builder.build();
    }

    public static ImmutableEntity copyOf(Entity instance) {
        if (instance instanceof ImmutableEntity) {
            return (ImmutableEntity)instance;
        }
        return ImmutableEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Entity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_IDENTIFIER = 1L;
        private static final long INIT_BIT_HAS_NESTED_ENTITIES = 2L;
        private static final long OPT_BIT_IS_WRITABLE = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String entityIdentifier;
        private boolean hasNestedEntities;
        private boolean isWritable;
        @Nullable
        private String label;
        @Nullable
        private String description;
        private ImmutableMap.Builder<String, String> customProperties = null;

        private Builder() {
        }

        public final Builder from(Entity instance) {
            Map<String, String> customPropertiesValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            this.entityIdentifier(instance.entityIdentifier());
            this.hasNestedEntities(instance.hasNestedEntities());
            this.isWritable(instance.isWritable());
            String labelValue = instance.label();
            if (labelValue != null) {
                this.label(labelValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            if ((customPropertiesValue = instance.customProperties()) != null) {
                this.putAllCustomProperties(customPropertiesValue);
            }
            return this;
        }

        @JsonProperty(value="entityIdentifier")
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = Objects.requireNonNull(entityIdentifier, "entityIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hasNestedEntities")
        public final Builder hasNestedEntities(boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="isWritable")
        public final Builder isWritable(boolean isWritable) {
            this.isWritable = isWritable;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(@Nullable String label) {
            this.label = label;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        public final Builder putCustomProperties(String key, String value) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put(key, value);
            return this;
        }

        public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(value="customProperties")
        public final Builder customProperties(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.customProperties = null;
                return this;
            }
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.putAll(entries);
            return this;
        }

        public ImmutableEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntity(this);
        }

        private boolean isWritableIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hasNestedEntities");
            }
            return "Cannot build Entity, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Entity", generator="Immutables")
    static final class Json
    implements Entity {
        @Nullable
        String entityIdentifier;
        boolean hasNestedEntities;
        boolean hasNestedEntitiesIsSet;
        boolean isWritable;
        boolean isWritableIsSet;
        @Nullable
        String label;
        @Nullable
        String description;
        @Nullable
        Map<String, String> customProperties = null;

        Json() {
        }

        @JsonProperty(value="entityIdentifier")
        public void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @JsonProperty(value="hasNestedEntities")
        public void setHasNestedEntities(boolean hasNestedEntities) {
            this.hasNestedEntities = hasNestedEntities;
            this.hasNestedEntitiesIsSet = true;
        }

        @JsonProperty(value="isWritable")
        public void setIsWritable(boolean isWritable) {
            this.isWritable = isWritable;
            this.isWritableIsSet = true;
        }

        @JsonProperty(value="label")
        public void setLabel(@Nullable String label) {
            this.label = label;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="customProperties")
        public void setCustomProperties(@Nullable Map<String, String> customProperties) {
            this.customProperties = customProperties;
        }

        @Override
        public String entityIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNestedEntities() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWritable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> customProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

