/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.OAuth2Credentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OAuth2Credentials", generator="Immutables")
@Immutable
public final class ImmutableOAuth2Credentials
implements OAuth2Credentials {
    private final String accessToken;
    @Nullable
    private final String refreshToken;

    private ImmutableOAuth2Credentials(String accessToken, @Nullable String refreshToken) {
        this.accessToken = accessToken;
        this.refreshToken = refreshToken;
    }

    @Override
    @JsonProperty(value="accessToken")
    public String accessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty(value="refreshToken")
    @Nullable
    public String refreshToken() {
        return this.refreshToken;
    }

    public final ImmutableOAuth2Credentials withAccessToken(String value) {
        String newValue = Objects.requireNonNull(value, "accessToken");
        if (this.accessToken.equals(newValue)) {
            return this;
        }
        return new ImmutableOAuth2Credentials(newValue, this.refreshToken);
    }

    public final ImmutableOAuth2Credentials withRefreshToken(@Nullable String value) {
        if (Objects.equals(this.refreshToken, value)) {
            return this;
        }
        return new ImmutableOAuth2Credentials(this.accessToken, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2Credentials && this.equalTo(0, (ImmutableOAuth2Credentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableOAuth2Credentials another) {
        return this.accessToken.equals(another.accessToken) && Objects.equals(this.refreshToken, another.refreshToken);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.accessToken.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.refreshToken);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OAuth2Credentials").omitNullValues().add("accessToken", this.accessToken).add("refreshToken", this.refreshToken).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOAuth2Credentials fromJson(Json json) {
        Builder builder = ImmutableOAuth2Credentials.builder();
        if (json.accessToken != null) {
            builder.accessToken(json.accessToken);
        }
        if (json.refreshToken != null) {
            builder.refreshToken(json.refreshToken);
        }
        return builder.build();
    }

    public static ImmutableOAuth2Credentials copyOf(OAuth2Credentials instance) {
        if (instance instanceof ImmutableOAuth2Credentials) {
            return (ImmutableOAuth2Credentials)instance;
        }
        return ImmutableOAuth2Credentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuth2Credentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private long initBits = 1L;
        @Nullable
        private String accessToken;
        @Nullable
        private String refreshToken;

        private Builder() {
        }

        public final Builder from(OAuth2Credentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.accessToken(instance.accessToken());
            String refreshTokenValue = instance.refreshToken();
            if (refreshTokenValue != null) {
                this.refreshToken(refreshTokenValue);
            }
            return this;
        }

        @JsonProperty(value="accessToken")
        public final Builder accessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="refreshToken")
        public final Builder refreshToken(@Nullable String refreshToken) {
            this.refreshToken = refreshToken;
            return this;
        }

        public ImmutableOAuth2Credentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOAuth2Credentials(this.accessToken, this.refreshToken);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("accessToken");
            }
            return "Cannot build OAuth2Credentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OAuth2Credentials", generator="Immutables")
    static final class Json
    implements OAuth2Credentials {
        @Nullable
        String accessToken;
        @Nullable
        String refreshToken;

        Json() {
        }

        @JsonProperty(value="accessToken")
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty(value="refreshToken")
        public void setRefreshToken(@Nullable String refreshToken) {
            this.refreshToken = refreshToken;
        }

        @Override
        public String accessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String refreshToken() {
            throw new UnsupportedOperationException();
        }
    }
}

