/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2ContentType;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2CustomParameter;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2Defaults;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2GrantType;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2MethodType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OAuth2Defaults", generator="Immutables")
@Immutable
public final class ImmutableOAuth2Defaults
implements OAuth2Defaults {
    @Nullable
    private final ImmutableList<String> oAuthScopes;
    private final ImmutableList<String> tokenURL;
    @Nullable
    private final ImmutableList<String> authURL;
    private final ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported;
    private final OAuth2ContentType oAuth2ContentType;
    private final OAuth2MethodType oAuth2MethodType;
    @Nullable
    private final ImmutableList<OAuth2CustomParameter> oauth2CustomProperties;
    private final boolean addBasicAuthHeader;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableOAuth2Defaults(Builder builder) {
        this.oAuthScopes = builder.oAuthScopes == null ? null : builder.oAuthScopes.build();
        this.tokenURL = builder.tokenURL.build();
        this.authURL = builder.authURL == null ? null : builder.authURL.build();
        this.oAuth2GrantTypesSupported = builder.oAuth2GrantTypesSupported.build();
        ImmutableList<OAuth2CustomParameter> immutableList = this.oauth2CustomProperties = builder.oauth2CustomProperties == null ? null : builder.oauth2CustomProperties.build();
        if (builder.oAuth2ContentType != null) {
            this.initShim.oAuth2ContentType(builder.oAuth2ContentType);
        }
        if (builder.oAuth2MethodType != null) {
            this.initShim.oAuth2MethodType(builder.oAuth2MethodType);
        }
        if (builder.addBasicAuthHeaderIsSet()) {
            this.initShim.addBasicAuthHeader(builder.addBasicAuthHeader);
        }
        this.oAuth2ContentType = this.initShim.oAuth2ContentType();
        this.oAuth2MethodType = this.initShim.oAuth2MethodType();
        this.addBasicAuthHeader = this.initShim.addBasicAuthHeader();
        this.initShim = null;
    }

    private ImmutableOAuth2Defaults(@Nullable ImmutableList<String> oAuthScopes, ImmutableList<String> tokenURL, @Nullable ImmutableList<String> authURL, ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported, OAuth2ContentType oAuth2ContentType, OAuth2MethodType oAuth2MethodType, @Nullable ImmutableList<OAuth2CustomParameter> oauth2CustomProperties, boolean addBasicAuthHeader) {
        this.oAuthScopes = oAuthScopes;
        this.tokenURL = tokenURL;
        this.authURL = authURL;
        this.oAuth2GrantTypesSupported = oAuth2GrantTypesSupported;
        this.oAuth2ContentType = oAuth2ContentType;
        this.oAuth2MethodType = oAuth2MethodType;
        this.oauth2CustomProperties = oauth2CustomProperties;
        this.addBasicAuthHeader = addBasicAuthHeader;
        this.initShim = null;
    }

    private OAuth2ContentType oAuth2ContentTypeInitialize() {
        return OAuth2Defaults.super.oAuth2ContentType();
    }

    private OAuth2MethodType oAuth2MethodTypeInitialize() {
        return OAuth2Defaults.super.oAuth2MethodType();
    }

    private boolean addBasicAuthHeaderInitialize() {
        return OAuth2Defaults.super.addBasicAuthHeader();
    }

    @JsonProperty(value="oAuthScopes")
    @Nullable
    public ImmutableList<String> oAuthScopes() {
        return this.oAuthScopes;
    }

    @JsonProperty(value="tokenURL")
    public ImmutableList<String> tokenURL() {
        return this.tokenURL;
    }

    @JsonProperty(value="authURL")
    @Nullable
    public ImmutableList<String> authURL() {
        return this.authURL;
    }

    @JsonProperty(value="oAuth2GrantTypesSupported")
    public ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported() {
        return this.oAuth2GrantTypesSupported;
    }

    @Override
    @JsonProperty(value="oAuth2ContentType")
    public OAuth2ContentType oAuth2ContentType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.oAuth2ContentType() : this.oAuth2ContentType;
    }

    @Override
    @JsonProperty(value="oAuth2MethodType")
    public OAuth2MethodType oAuth2MethodType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.oAuth2MethodType() : this.oAuth2MethodType;
    }

    @JsonProperty(value="oauth2CustomProperties")
    @Nullable
    public ImmutableList<OAuth2CustomParameter> oauth2CustomProperties() {
        return this.oauth2CustomProperties;
    }

    @Override
    @JsonProperty(value="addBasicAuthHeader")
    public boolean addBasicAuthHeader() {
        InitShim shim = this.initShim;
        return shim != null ? shim.addBasicAuthHeader() : this.addBasicAuthHeader;
    }

    public final ImmutableOAuth2Defaults withOAuthScopes(String ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(null, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(newValue, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOAuthScopes(@Nullable Iterable<String> elements) {
        if (this.oAuthScopes == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(newValue, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withTokenURL(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, newValue, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withTokenURL(Iterable<String> elements) {
        if (this.tokenURL == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, newValue, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withAuthURL(String ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, null, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, newValue, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withAuthURL(@Nullable Iterable<String> elements) {
        if (this.authURL == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, newValue, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOAuth2GrantTypesSupported(OAuth2GrantType ... elements) {
        ImmutableList<OAuth2GrantType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, newValue, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
        if (this.oAuth2GrantTypesSupported == elements) {
            return this;
        }
        ImmutableList<OAuth2GrantType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, newValue, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOAuth2ContentType(OAuth2ContentType value) {
        OAuth2ContentType newValue = Objects.requireNonNull(value, "oAuth2ContentType");
        if (this.oAuth2ContentType == newValue) {
            return this;
        }
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, newValue, this.oAuth2MethodType, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOAuth2MethodType(OAuth2MethodType value) {
        OAuth2MethodType newValue = Objects.requireNonNull(value, "oAuth2MethodType");
        if (this.oAuth2MethodType == newValue) {
            return this;
        }
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, newValue, this.oauth2CustomProperties, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOauth2CustomProperties(OAuth2CustomParameter ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, null, this.addBasicAuthHeader);
        }
        ImmutableList<OAuth2CustomParameter> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, newValue, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withOauth2CustomProperties(@Nullable Iterable<? extends OAuth2CustomParameter> elements) {
        if (this.oauth2CustomProperties == elements) {
            return this;
        }
        ImmutableList<OAuth2CustomParameter> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, newValue, this.addBasicAuthHeader);
    }

    public final ImmutableOAuth2Defaults withAddBasicAuthHeader(boolean value) {
        if (this.addBasicAuthHeader == value) {
            return this;
        }
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oAuth2ContentType, this.oAuth2MethodType, this.oauth2CustomProperties, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2Defaults && this.equalTo(0, (ImmutableOAuth2Defaults)another);
    }

    private boolean equalTo(int synthetic, ImmutableOAuth2Defaults another) {
        return Objects.equals(this.oAuthScopes, another.oAuthScopes) && this.tokenURL.equals(another.tokenURL) && Objects.equals(this.authURL, another.authURL) && this.oAuth2GrantTypesSupported.equals(another.oAuth2GrantTypesSupported) && this.oAuth2ContentType.equals((Object)another.oAuth2ContentType) && this.oAuth2MethodType.equals((Object)another.oAuth2MethodType) && Objects.equals(this.oauth2CustomProperties, another.oauth2CustomProperties) && this.addBasicAuthHeader == another.addBasicAuthHeader;
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.oAuthScopes);
        h2 += (h2 << 5) + this.tokenURL.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.authURL);
        h2 += (h2 << 5) + this.oAuth2GrantTypesSupported.hashCode();
        h2 += (h2 << 5) + this.oAuth2ContentType.hashCode();
        h2 += (h2 << 5) + this.oAuth2MethodType.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.oauth2CustomProperties);
        h2 += (h2 << 5) + Booleans.hashCode(this.addBasicAuthHeader);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OAuth2Defaults").omitNullValues().add("oAuthScopes", this.oAuthScopes).add("tokenURL", this.tokenURL).add("authURL", this.authURL).add("oAuth2GrantTypesSupported", this.oAuth2GrantTypesSupported).add("oAuth2ContentType", (Object)this.oAuth2ContentType).add("oAuth2MethodType", (Object)this.oAuth2MethodType).add("oauth2CustomProperties", this.oauth2CustomProperties).add("addBasicAuthHeader", this.addBasicAuthHeader).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOAuth2Defaults fromJson(Json json) {
        Builder builder = ImmutableOAuth2Defaults.builder();
        if (json.oAuthScopes != null) {
            builder.addAllOAuthScopes(json.oAuthScopes);
        }
        if (json.tokenURL != null) {
            builder.addAllTokenURL(json.tokenURL);
        }
        if (json.authURL != null) {
            builder.addAllAuthURL(json.authURL);
        }
        if (json.oAuth2GrantTypesSupported != null) {
            builder.addAllOAuth2GrantTypesSupported(json.oAuth2GrantTypesSupported);
        }
        if (json.oAuth2ContentType != null) {
            builder.oAuth2ContentType(json.oAuth2ContentType);
        }
        if (json.oAuth2MethodType != null) {
            builder.oAuth2MethodType(json.oAuth2MethodType);
        }
        if (json.oauth2CustomProperties != null) {
            builder.addAllOauth2CustomProperties(json.oauth2CustomProperties);
        }
        if (json.addBasicAuthHeaderIsSet) {
            builder.addBasicAuthHeader(json.addBasicAuthHeader);
        }
        return builder.build();
    }

    public static ImmutableOAuth2Defaults copyOf(OAuth2Defaults instance) {
        if (instance instanceof ImmutableOAuth2Defaults) {
            return (ImmutableOAuth2Defaults)instance;
        }
        return ImmutableOAuth2Defaults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuth2Defaults", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_ADD_BASIC_AUTH_HEADER = 1L;
        private long optBits;
        private ImmutableList.Builder<String> oAuthScopes = null;
        private ImmutableList.Builder<String> tokenURL = ImmutableList.builder();
        private ImmutableList.Builder<String> authURL = null;
        private ImmutableList.Builder<OAuth2GrantType> oAuth2GrantTypesSupported = ImmutableList.builder();
        @Nullable
        private OAuth2ContentType oAuth2ContentType;
        @Nullable
        private OAuth2MethodType oAuth2MethodType;
        private ImmutableList.Builder<OAuth2CustomParameter> oauth2CustomProperties = null;
        private boolean addBasicAuthHeader;

        private Builder() {
        }

        public final Builder from(OAuth2Defaults instance) {
            Objects.requireNonNull(instance, "instance");
            List<String> oAuthScopesValue = instance.oAuthScopes();
            if (oAuthScopesValue != null) {
                this.addAllOAuthScopes(oAuthScopesValue);
            }
            this.addAllTokenURL(instance.tokenURL());
            List<String> authURLValue = instance.authURL();
            if (authURLValue != null) {
                this.addAllAuthURL(authURLValue);
            }
            this.addAllOAuth2GrantTypesSupported(instance.oAuth2GrantTypesSupported());
            this.oAuth2ContentType(instance.oAuth2ContentType());
            this.oAuth2MethodType(instance.oAuth2MethodType());
            List<OAuth2CustomParameter> oauth2CustomPropertiesValue = instance.oauth2CustomProperties();
            if (oauth2CustomPropertiesValue != null) {
                this.addAllOauth2CustomProperties(oauth2CustomPropertiesValue);
            }
            this.addBasicAuthHeader(instance.addBasicAuthHeader());
            return this;
        }

        public final Builder addOAuthScopes(String element) {
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.add((Object)element);
            return this;
        }

        public final Builder addOAuthScopes(String ... elements) {
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.add(elements);
            return this;
        }

        @JsonProperty(value="oAuthScopes")
        public final Builder oAuthScopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.oAuthScopes = null;
                return this;
            }
            this.oAuthScopes = ImmutableList.builder();
            return this.addAllOAuthScopes(elements);
        }

        public final Builder addAllOAuthScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "oAuthScopes element");
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.addAll((Iterable)elements);
            return this;
        }

        public final Builder addTokenURL(String element) {
            this.tokenURL.add((Object)element);
            return this;
        }

        public final Builder addTokenURL(String ... elements) {
            this.tokenURL.add(elements);
            return this;
        }

        @JsonProperty(value="tokenURL")
        public final Builder tokenURL(Iterable<String> elements) {
            this.tokenURL = ImmutableList.builder();
            return this.addAllTokenURL(elements);
        }

        public final Builder addAllTokenURL(Iterable<String> elements) {
            this.tokenURL.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAuthURL(String element) {
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.add((Object)element);
            return this;
        }

        public final Builder addAuthURL(String ... elements) {
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.add(elements);
            return this;
        }

        @JsonProperty(value="authURL")
        public final Builder authURL(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.authURL = null;
                return this;
            }
            this.authURL = ImmutableList.builder();
            return this.addAllAuthURL(elements);
        }

        public final Builder addAllAuthURL(Iterable<String> elements) {
            Objects.requireNonNull(elements, "authURL element");
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.addAll((Iterable)elements);
            return this;
        }

        public final Builder addOAuth2GrantTypesSupported(OAuth2GrantType element) {
            this.oAuth2GrantTypesSupported.add((Object)element);
            return this;
        }

        public final Builder addOAuth2GrantTypesSupported(OAuth2GrantType ... elements) {
            this.oAuth2GrantTypesSupported.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="oAuth2GrantTypesSupported")
        public final Builder oAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
            this.oAuth2GrantTypesSupported = ImmutableList.builder();
            return this.addAllOAuth2GrantTypesSupported(elements);
        }

        public final Builder addAllOAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
            this.oAuth2GrantTypesSupported.addAll(elements);
            return this;
        }

        @JsonProperty(value="oAuth2ContentType")
        public final Builder oAuth2ContentType(OAuth2ContentType oAuth2ContentType) {
            this.oAuth2ContentType = Objects.requireNonNull(oAuth2ContentType, "oAuth2ContentType");
            return this;
        }

        @JsonProperty(value="oAuth2MethodType")
        public final Builder oAuth2MethodType(OAuth2MethodType oAuth2MethodType) {
            this.oAuth2MethodType = Objects.requireNonNull(oAuth2MethodType, "oAuth2MethodType");
            return this;
        }

        public final Builder addOauth2CustomProperties(OAuth2CustomParameter element) {
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.add((Object)element);
            return this;
        }

        public final Builder addOauth2CustomProperties(OAuth2CustomParameter ... elements) {
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.add(elements);
            return this;
        }

        @JsonProperty(value="oauth2CustomProperties")
        public final Builder oauth2CustomProperties(@Nullable Iterable<? extends OAuth2CustomParameter> elements) {
            if (elements == null) {
                this.oauth2CustomProperties = null;
                return this;
            }
            this.oauth2CustomProperties = ImmutableList.builder();
            return this.addAllOauth2CustomProperties(elements);
        }

        public final Builder addAllOauth2CustomProperties(Iterable<? extends OAuth2CustomParameter> elements) {
            Objects.requireNonNull(elements, "oauth2CustomProperties element");
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.addAll(elements);
            return this;
        }

        @JsonProperty(value="addBasicAuthHeader")
        public final Builder addBasicAuthHeader(boolean addBasicAuthHeader) {
            this.addBasicAuthHeader = addBasicAuthHeader;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableOAuth2Defaults build() {
            return new ImmutableOAuth2Defaults(this);
        }

        private boolean addBasicAuthHeaderIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OAuth2Defaults", generator="Immutables")
    static final class Json
    implements OAuth2Defaults {
        @Nullable
        List<String> oAuthScopes = null;
        @Nullable
        List<String> tokenURL = ImmutableList.of();
        @Nullable
        List<String> authURL = null;
        @Nullable
        List<OAuth2GrantType> oAuth2GrantTypesSupported = ImmutableList.of();
        @Nullable
        OAuth2ContentType oAuth2ContentType;
        @Nullable
        OAuth2MethodType oAuth2MethodType;
        @Nullable
        List<OAuth2CustomParameter> oauth2CustomProperties = null;
        boolean addBasicAuthHeader;
        boolean addBasicAuthHeaderIsSet;

        Json() {
        }

        @JsonProperty(value="oAuthScopes")
        public void setOAuthScopes(@Nullable List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
        }

        @JsonProperty(value="tokenURL")
        public void setTokenURL(List<String> tokenURL) {
            this.tokenURL = tokenURL;
        }

        @JsonProperty(value="authURL")
        public void setAuthURL(@Nullable List<String> authURL) {
            this.authURL = authURL;
        }

        @JsonProperty(value="oAuth2GrantTypesSupported")
        public void setOAuth2GrantTypesSupported(List<OAuth2GrantType> oAuth2GrantTypesSupported) {
            this.oAuth2GrantTypesSupported = oAuth2GrantTypesSupported;
        }

        @JsonProperty(value="oAuth2ContentType")
        public void setOAuth2ContentType(OAuth2ContentType oAuth2ContentType) {
            this.oAuth2ContentType = oAuth2ContentType;
        }

        @JsonProperty(value="oAuth2MethodType")
        public void setOAuth2MethodType(OAuth2MethodType oAuth2MethodType) {
            this.oAuth2MethodType = oAuth2MethodType;
        }

        @JsonProperty(value="oauth2CustomProperties")
        public void setOauth2CustomProperties(@Nullable List<OAuth2CustomParameter> oauth2CustomProperties) {
            this.oauth2CustomProperties = oauth2CustomProperties;
        }

        @JsonProperty(value="addBasicAuthHeader")
        public void setAddBasicAuthHeader(boolean addBasicAuthHeader) {
            this.addBasicAuthHeader = addBasicAuthHeader;
            this.addBasicAuthHeaderIsSet = true;
        }

        @Override
        public List<String> oAuthScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tokenURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> authURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OAuth2GrantType> oAuth2GrantTypesSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OAuth2ContentType oAuth2ContentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OAuth2MethodType oAuth2MethodType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OAuth2CustomParameter> oauth2CustomProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addBasicAuthHeader() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="OAuth2Defaults", generator="Immutables")
    private final class InitShim {
        private byte oAuth2ContentTypeBuildStage = 0;
        private OAuth2ContentType oAuth2ContentType;
        private byte oAuth2MethodTypeBuildStage = 0;
        private OAuth2MethodType oAuth2MethodType;
        private byte addBasicAuthHeaderBuildStage = 0;
        private boolean addBasicAuthHeader;

        private InitShim() {
        }

        OAuth2ContentType oAuth2ContentType() {
            if (this.oAuth2ContentTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oAuth2ContentTypeBuildStage == 0) {
                this.oAuth2ContentTypeBuildStage = (byte)-1;
                this.oAuth2ContentType = Objects.requireNonNull(ImmutableOAuth2Defaults.this.oAuth2ContentTypeInitialize(), "oAuth2ContentType");
                this.oAuth2ContentTypeBuildStage = 1;
            }
            return this.oAuth2ContentType;
        }

        void oAuth2ContentType(OAuth2ContentType oAuth2ContentType) {
            this.oAuth2ContentType = oAuth2ContentType;
            this.oAuth2ContentTypeBuildStage = 1;
        }

        OAuth2MethodType oAuth2MethodType() {
            if (this.oAuth2MethodTypeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oAuth2MethodTypeBuildStage == 0) {
                this.oAuth2MethodTypeBuildStage = (byte)-1;
                this.oAuth2MethodType = Objects.requireNonNull(ImmutableOAuth2Defaults.this.oAuth2MethodTypeInitialize(), "oAuth2MethodType");
                this.oAuth2MethodTypeBuildStage = 1;
            }
            return this.oAuth2MethodType;
        }

        void oAuth2MethodType(OAuth2MethodType oAuth2MethodType) {
            this.oAuth2MethodType = oAuth2MethodType;
            this.oAuth2MethodTypeBuildStage = 1;
        }

        boolean addBasicAuthHeader() {
            if (this.addBasicAuthHeaderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.addBasicAuthHeaderBuildStage == 0) {
                this.addBasicAuthHeaderBuildStage = (byte)-1;
                this.addBasicAuthHeader = ImmutableOAuth2Defaults.this.addBasicAuthHeaderInitialize();
                this.addBasicAuthHeaderBuildStage = 1;
            }
            return this.addBasicAuthHeader;
        }

        void addBasicAuthHeader(boolean addBasicAuthHeader) {
            this.addBasicAuthHeader = addBasicAuthHeader;
            this.addBasicAuthHeaderBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.oAuth2ContentTypeBuildStage == -1) {
                attributes.add("oAuth2ContentType");
            }
            if (this.oAuth2MethodTypeBuildStage == -1) {
                attributes.add("oAuth2MethodType");
            }
            if (this.addBasicAuthHeaderBuildStage == -1) {
                attributes.add("addBasicAuthHeader");
            }
            return "Cannot build OAuth2Defaults, attribute initializers form cycle " + attributes;
        }
    }
}

