/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.providers;

import com.amazonaws.appflow.custom.connector.integ.providers.TestCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TestCredentials", generator="Immutables")
@Immutable
public final class ImmutableTestCredentials
implements TestCredentials {
    @Nullable
    private final Credentials credentials;
    @Nullable
    private final String clientId;
    @Nullable
    private final String clientSecret;

    private ImmutableTestCredentials(@Nullable Credentials credentials, @Nullable String clientId, @Nullable String clientSecret) {
        this.credentials = credentials;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    @Override
    @JsonProperty(value="credentials")
    public Optional<Credentials> credentials() {
        return Optional.ofNullable(this.credentials);
    }

    @Override
    @JsonProperty(value="clientId")
    public Optional<String> clientId() {
        return Optional.ofNullable(this.clientId);
    }

    @Override
    @JsonProperty(value="clientSecret")
    public Optional<String> clientSecret() {
        return Optional.ofNullable(this.clientSecret);
    }

    public final ImmutableTestCredentials withCredentials(Credentials value) {
        Credentials newValue = Objects.requireNonNull(value, "credentials");
        if (this.credentials == newValue) {
            return this;
        }
        return new ImmutableTestCredentials(newValue, this.clientId, this.clientSecret);
    }

    public final ImmutableTestCredentials withCredentials(Optional<? extends Credentials> optional) {
        Credentials value = optional.orElse(null);
        if (this.credentials == value) {
            return this;
        }
        return new ImmutableTestCredentials(value, this.clientId, this.clientSecret);
    }

    public final ImmutableTestCredentials withClientId(String value) {
        String newValue = Objects.requireNonNull(value, "clientId");
        if (Objects.equals(this.clientId, newValue)) {
            return this;
        }
        return new ImmutableTestCredentials(this.credentials, newValue, this.clientSecret);
    }

    public final ImmutableTestCredentials withClientId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableTestCredentials(this.credentials, value, this.clientSecret);
    }

    public final ImmutableTestCredentials withClientSecret(String value) {
        String newValue = Objects.requireNonNull(value, "clientSecret");
        if (Objects.equals(this.clientSecret, newValue)) {
            return this;
        }
        return new ImmutableTestCredentials(this.credentials, this.clientId, newValue);
    }

    public final ImmutableTestCredentials withClientSecret(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.clientSecret, value)) {
            return this;
        }
        return new ImmutableTestCredentials(this.credentials, this.clientId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestCredentials && this.equalTo(0, (ImmutableTestCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableTestCredentials another) {
        return Objects.equals(this.credentials, another.credentials) && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.clientSecret, another.clientSecret);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.credentials);
        h2 += (h2 << 5) + Objects.hashCode(this.clientId);
        h2 += (h2 << 5) + Objects.hashCode(this.clientSecret);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TestCredentials").omitNullValues().add("credentials", this.credentials).add("clientId", this.clientId).add("clientSecret", this.clientSecret).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTestCredentials fromJson(Json json) {
        Builder builder = ImmutableTestCredentials.builder();
        if (json.credentials != null) {
            builder.credentials(json.credentials);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.clientSecret != null) {
            builder.clientSecret(json.clientSecret);
        }
        return builder.build();
    }

    public static ImmutableTestCredentials copyOf(TestCredentials instance) {
        if (instance instanceof ImmutableTestCredentials) {
            return (ImmutableTestCredentials)instance;
        }
        return ImmutableTestCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TestCredentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Credentials credentials;
        @Nullable
        private String clientId;
        @Nullable
        private String clientSecret;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TestCredentials instance) {
            Optional<String> clientSecretOptional;
            Optional<String> clientIdOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Credentials> credentialsOptional = instance.credentials();
            if (credentialsOptional.isPresent()) {
                this.credentials(credentialsOptional);
            }
            if ((clientIdOptional = instance.clientId()).isPresent()) {
                this.clientId(clientIdOptional);
            }
            if ((clientSecretOptional = instance.clientSecret()).isPresent()) {
                this.clientSecret(clientSecretOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder credentials(Credentials credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            return this;
        }

        @JsonProperty(value="credentials")
        @CanIgnoreReturnValue
        public final Builder credentials(Optional<? extends Credentials> credentials) {
            this.credentials = credentials.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            return this;
        }

        @JsonProperty(value="clientId")
        @CanIgnoreReturnValue
        public final Builder clientId(Optional<String> clientId) {
            this.clientId = clientId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            return this;
        }

        @JsonProperty(value="clientSecret")
        @CanIgnoreReturnValue
        public final Builder clientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret.orElse(null);
            return this;
        }

        public ImmutableTestCredentials build() {
            return new ImmutableTestCredentials(this.credentials, this.clientId, this.clientSecret);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TestCredentials", generator="Immutables")
    static final class Json
    implements TestCredentials {
        @Nullable
        Optional<Credentials> credentials = Optional.empty();
        @Nullable
        Optional<String> clientId = Optional.empty();
        @Nullable
        Optional<String> clientSecret = Optional.empty();

        Json() {
        }

        @JsonProperty(value="credentials")
        public void setCredentials(Optional<Credentials> credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="clientId")
        public void setClientId(Optional<String> clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="clientSecret")
        public void setClientSecret(Optional<String> clientSecret) {
            this.clientSecret = clientSecret;
        }

        @Override
        public Optional<Credentials> credentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> clientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> clientSecret() {
            throw new UnsupportedOperationException();
        }
    }
}

