/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.query;

import com.amazonaws.appflow.custom.connector.example.query.QueryObject;
import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="QueryObject", generator="Immutables")
@Immutable
public final class ImmutableQueryObject
implements QueryObject {
    private final String sObject;
    @Nullable
    private final ImmutableList<String> selectedFieldNames;
    @Nullable
    private final String filterExpression;
    @Nullable
    private final String idFieldName;
    @Nullable
    private final ImmutableList<String> fields;
    @Nullable
    private final String dataType;
    @Nullable
    private final EntityDefinition entityDefinition;

    private ImmutableQueryObject(String sObject, @Nullable ImmutableList<String> selectedFieldNames, @Nullable String filterExpression, @Nullable String idFieldName, @Nullable ImmutableList<String> fields, @Nullable String dataType, @Nullable EntityDefinition entityDefinition) {
        this.sObject = sObject;
        this.selectedFieldNames = selectedFieldNames;
        this.filterExpression = filterExpression;
        this.idFieldName = idFieldName;
        this.fields = fields;
        this.dataType = dataType;
        this.entityDefinition = entityDefinition;
    }

    @Override
    public String sObject() {
        return this.sObject;
    }

    @Nullable
    public ImmutableList<String> selectedFieldNames() {
        return this.selectedFieldNames;
    }

    @Override
    @Nullable
    public String filterExpression() {
        return this.filterExpression;
    }

    @Override
    @Nullable
    public String idFieldName() {
        return this.idFieldName;
    }

    @Nullable
    public ImmutableList<String> fields() {
        return this.fields;
    }

    @Override
    @Nullable
    public String dataType() {
        return this.dataType;
    }

    @Override
    @Nullable
    public EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    public final ImmutableQueryObject withSObject(String value) {
        String newValue = Objects.requireNonNull(value, "sObject");
        if (this.sObject.equals(newValue)) {
            return this;
        }
        return new ImmutableQueryObject(newValue, this.selectedFieldNames, this.filterExpression, this.idFieldName, this.fields, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withSelectedFieldNames(String ... elements) {
        if (elements == null) {
            return new ImmutableQueryObject(this.sObject, null, this.filterExpression, this.idFieldName, this.fields, this.dataType, this.entityDefinition);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryObject(this.sObject, newValue, this.filterExpression, this.idFieldName, this.fields, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withSelectedFieldNames(@Nullable Iterable<String> elements) {
        if (this.selectedFieldNames == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryObject(this.sObject, newValue, this.filterExpression, this.idFieldName, this.fields, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withFilterExpression(@Nullable String value) {
        if (Objects.equals(this.filterExpression, value)) {
            return this;
        }
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, value, this.idFieldName, this.fields, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withIdFieldName(@Nullable String value) {
        if (Objects.equals(this.idFieldName, value)) {
            return this;
        }
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, value, this.fields, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withFields(String ... elements) {
        if (elements == null) {
            return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, this.idFieldName, null, this.dataType, this.entityDefinition);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, this.idFieldName, newValue, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withFields(@Nullable Iterable<String> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, this.idFieldName, newValue, this.dataType, this.entityDefinition);
    }

    public final ImmutableQueryObject withDataType(@Nullable String value) {
        if (Objects.equals(this.dataType, value)) {
            return this;
        }
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, this.idFieldName, this.fields, value, this.entityDefinition);
    }

    public final ImmutableQueryObject withEntityDefinition(@Nullable EntityDefinition value) {
        if (this.entityDefinition == value) {
            return this;
        }
        return new ImmutableQueryObject(this.sObject, this.selectedFieldNames, this.filterExpression, this.idFieldName, this.fields, this.dataType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryObject && this.equalTo(0, (ImmutableQueryObject)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryObject another) {
        return this.sObject.equals(another.sObject) && Objects.equals(this.selectedFieldNames, another.selectedFieldNames) && Objects.equals(this.filterExpression, another.filterExpression) && Objects.equals(this.idFieldName, another.idFieldName) && Objects.equals(this.fields, another.fields) && Objects.equals(this.dataType, another.dataType) && Objects.equals(this.entityDefinition, another.entityDefinition);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.sObject.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.selectedFieldNames);
        h2 += (h2 << 5) + Objects.hashCode(this.filterExpression);
        h2 += (h2 << 5) + Objects.hashCode(this.idFieldName);
        h2 += (h2 << 5) + Objects.hashCode(this.fields);
        h2 += (h2 << 5) + Objects.hashCode(this.dataType);
        h2 += (h2 << 5) + Objects.hashCode(this.entityDefinition);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryObject").omitNullValues().add("sObject", this.sObject).add("selectedFieldNames", this.selectedFieldNames).add("filterExpression", this.filterExpression).add("idFieldName", this.idFieldName).add("fields", this.fields).add("dataType", this.dataType).add("entityDefinition", this.entityDefinition).toString();
    }

    public static ImmutableQueryObject copyOf(QueryObject instance) {
        if (instance instanceof ImmutableQueryObject) {
            return (ImmutableQueryObject)instance;
        }
        return ImmutableQueryObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryObject", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_S_OBJECT = 1L;
        private long initBits = 1L;
        @Nullable
        private String sObject;
        private ImmutableList.Builder<String> selectedFieldNames = null;
        @Nullable
        private String filterExpression;
        @Nullable
        private String idFieldName;
        private ImmutableList.Builder<String> fields = null;
        @Nullable
        private String dataType;
        @Nullable
        private EntityDefinition entityDefinition;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(QueryObject instance) {
            EntityDefinition entityDefinitionValue;
            String dataTypeValue;
            List<String> fieldsValue;
            String idFieldNameValue;
            String filterExpressionValue;
            Objects.requireNonNull(instance, "instance");
            this.sObject(instance.sObject());
            List<String> selectedFieldNamesValue = instance.selectedFieldNames();
            if (selectedFieldNamesValue != null) {
                this.addAllSelectedFieldNames(selectedFieldNamesValue);
            }
            if ((filterExpressionValue = instance.filterExpression()) != null) {
                this.filterExpression(filterExpressionValue);
            }
            if ((idFieldNameValue = instance.idFieldName()) != null) {
                this.idFieldName(idFieldNameValue);
            }
            if ((fieldsValue = instance.fields()) != null) {
                this.addAllFields(fieldsValue);
            }
            if ((dataTypeValue = instance.dataType()) != null) {
                this.dataType(dataTypeValue);
            }
            if ((entityDefinitionValue = instance.entityDefinition()) != null) {
                this.entityDefinition(entityDefinitionValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sObject(String sObject) {
            this.sObject = Objects.requireNonNull(sObject, "sObject");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSelectedFieldNames(String element) {
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = ImmutableList.builder();
            }
            this.selectedFieldNames.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSelectedFieldNames(String ... elements) {
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = ImmutableList.builder();
            }
            this.selectedFieldNames.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder selectedFieldNames(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.selectedFieldNames = null;
                return this;
            }
            this.selectedFieldNames = ImmutableList.builder();
            return this.addAllSelectedFieldNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSelectedFieldNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "selectedFieldNames element");
            if (this.selectedFieldNames == null) {
                this.selectedFieldNames = ImmutableList.builder();
            }
            this.selectedFieldNames.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filterExpression(@Nullable String filterExpression) {
            this.filterExpression = filterExpression;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder idFieldName(@Nullable String idFieldName) {
            this.idFieldName = idFieldName;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(String element) {
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(String ... elements) {
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.add(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.fields = null;
                return this;
            }
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<String> elements) {
            Objects.requireNonNull(elements, "fields element");
            if (this.fields == null) {
                this.fields = ImmutableList.builder();
            }
            this.fields.addAll((Iterable)elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder dataType(@Nullable String dataType) {
            this.dataType = dataType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder entityDefinition(@Nullable EntityDefinition entityDefinition) {
            this.entityDefinition = entityDefinition;
            return this;
        }

        public ImmutableQueryObject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryObject(this.sObject, (ImmutableList)(this.selectedFieldNames == null ? null : this.selectedFieldNames.build()), this.filterExpression, this.idFieldName, (ImmutableList)(this.fields == null ? null : this.fields.build()), this.dataType, this.entityDefinition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sObject");
            }
            return "Cannot build QueryObject, some of required attributes are not set " + attributes;
        }
    }
}

