/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.parser;

import com.amazonaws.appflow.custom.connector.example.parser.AbstractParser;
import com.amazonaws.appflow.custom.connector.model.metadata.Entity;
import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDataType;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableEntity;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableEntityDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableFieldDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableReadOperationProperty;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableWriteOperationProperty;
import com.amazonaws.appflow.custom.connector.model.write.WriteOperationType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class EntityParser
extends AbstractParser {
    private static final Gson GSON = new Gson();

    private EntityParser() {
    }

    public static List<Entity> parseEntity(String jsonString) {
        JsonObject parentObject = GSON.fromJson(jsonString, JsonObject.class);
        ArrayList<Entity> entityList = new ArrayList<Entity>();
        if (Objects.nonNull(parentObject.get("sobjects"))) {
            JsonArray jsonArray = parentObject.get("sobjects").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                entityList.add(EntityParser.buildEntity(jsonElement.getAsJsonObject()));
            }
        } else if (Objects.nonNull(parentObject.getAsJsonObject("objectDescribe"))) {
            entityList.add(EntityParser.buildEntity(parentObject.getAsJsonObject("objectDescribe")));
        }
        return entityList;
    }

    public static EntityDefinition parseEntityDefinition(String jsonString) {
        ArrayList<FieldDefinition> fieldDefinitions = new ArrayList<FieldDefinition>();
        JsonObject parentObject = GSON.fromJson(jsonString, JsonObject.class);
        Entity entity = EntityParser.buildEntity(parentObject);
        if (Objects.nonNull(parentObject.get("fields"))) {
            JsonArray jsonArray = parentObject.get("fields").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                fieldDefinitions.add(EntityParser.buildFieldDefinition(jsonElement.getAsJsonObject()));
            }
        }
        return ImmutableEntityDefinition.builder().entity(entity).fields(fieldDefinitions).build();
    }

    private static Entity buildEntity(JsonObject field) {
        String name = EntityParser.getStringValue(field, "name");
        boolean hasNestedEntities = EntityParser.getBooleanValue(field, "hasSubtypes") || EntityParser.checkChildRelationship(field.get("childRelationships"));
        String description = EntityParser.getStringValue(field, "label");
        ImmutableEntity entity = ImmutableEntity.builder().entityIdentifier(name).label(description).hasNestedEntities(hasNestedEntities).description(description).build();
        return entity;
    }

    private static FieldDefinition buildFieldDefinition(JsonObject field) {
        String displayName = EntityParser.getStringValue(field, "label");
        String fieldName = EntityParser.getStringValue(field, "name");
        String type = EntityParser.getStringValue(field, "type");
        FieldDataType dataType = EntityParser.convertDataType(type);
        ArrayList<WriteOperationType> writeOperationTypes = new ArrayList<WriteOperationType>();
        if (EntityParser.getBooleanValue(field, "externalId")) {
            writeOperationTypes.add(WriteOperationType.UPSERT);
        } else if (EntityParser.getBooleanValue(field, "idLookup")) {
            writeOperationTypes.add(WriteOperationType.UPDATE);
            writeOperationTypes.add(WriteOperationType.UPSERT);
        }
        ImmutableFieldDefinition fieldDefinition = ImmutableFieldDefinition.builder().fieldName(fieldName).dataType(dataType).dataTypeLabel(type).label(displayName).description(displayName).defaultValue(EntityParser.getStringValue(field, "defaultValue")).isPrimaryKey(EntityParser.getBooleanValue(field, "unique")).readProperties(ImmutableReadOperationProperty.builder().isQueryable(EntityParser.getBooleanValue(field, "filterable")).isRetrievable(true).build()).writeProperties(ImmutableWriteOperationProperty.builder().isNullable(EntityParser.getBooleanValue(field, "nillable")).isUpdatable(EntityParser.getBooleanValue(field, "updateable")).isCreatable(EntityParser.getBooleanValue(field, "createable")).isDefaultedOnCreate(EntityParser.getBooleanValue(field, "defaultedOnCreate")).supportedWriteOperations(writeOperationTypes).build()).build();
        return fieldDefinition;
    }

    private static boolean checkChildRelationship(JsonElement jsonObject) {
        if (Objects.isNull(jsonObject)) {
            return false;
        }
        JsonArray childRelationships = jsonObject.getAsJsonArray();
        return !childRelationships.isJsonNull() && childRelationships.size() != 0;
    }

    private static FieldDataType convertDataType(String type) {
        switch (type) {
            case "int": {
                return FieldDataType.Integer;
            }
            case "double": {
                return FieldDataType.Double;
            }
            case "long": {
                return FieldDataType.Long;
            }
            case "id": 
            case "string": 
            case "textarea": {
                return FieldDataType.String;
            }
            case "date": {
                return FieldDataType.Date;
            }
            case "datetime": 
            case "time": {
                return FieldDataType.DateTime;
            }
            case "boolean": {
                return FieldDataType.Boolean;
            }
        }
        return FieldDataType.Struct;
    }
}

