/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.handler;

import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import com.amazonaws.appflow.custom.connector.example.client.HttpClient;
import com.amazonaws.appflow.custom.connector.example.handler.AbstractSalesforceHandler;
import com.amazonaws.appflow.custom.connector.example.handler.SalesforceMetadataHandler;
import com.amazonaws.appflow.custom.connector.example.parser.RecordResponseParser;
import com.amazonaws.appflow.custom.connector.example.query.ImmutableQueryObject;
import com.amazonaws.appflow.custom.connector.example.query.QueryObject;
import com.amazonaws.appflow.custom.connector.example.query.SalesforceQueryBuilder;
import com.amazonaws.appflow.custom.connector.example.validation.RequestValidator;
import com.amazonaws.appflow.custom.connector.handlers.RecordHandler;
import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDataType;
import com.amazonaws.appflow.custom.connector.model.query.ImmutableQueryDataResponse;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataRequest;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataResponse;
import com.amazonaws.appflow.custom.connector.model.retreive.ImmutableRetrieveDataResponse;
import com.amazonaws.appflow.custom.connector.model.retreive.RetrieveDataRequest;
import com.amazonaws.appflow.custom.connector.model.retreive.RetrieveDataResponse;
import com.amazonaws.appflow.custom.connector.model.write.ImmutableWriteDataResponse;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataRequest;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataResponse;
import com.amazonaws.appflow.custom.connector.model.write.WriteOperationType;
import com.amazonaws.appflow.custom.connector.model.write.WriteRecordResult;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceRecordHandler
extends AbstractSalesforceHandler
implements RecordHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SalesforceMetadataHandler.class);
    private static final String SALESFORCE_OBJECT_API_FORMAT = "%s/services/data/%s/sobjects/%s";
    private static final String SALESFORCE_QUERY_FORMAT = "%s/services/data/%s/query?q=%s";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public RetrieveDataResponse retrieveData(RetrieveDataRequest request) {
        ErrorDetails errorDetails = RequestValidator.validateRetrieveDataRequest(request);
        if (Objects.nonNull(errorDetails)) {
            LOGGER.error("RetrieveData request failed with errorDetails " + errorDetails);
            return ImmutableRetrieveDataResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        ImmutableQueryObject queryObject = ImmutableQueryObject.builder().sObject(request.entityIdentifier()).selectedFieldNames(request.selectedFieldNames()).idFieldName(request.idFieldName()).fields(request.ids()).dataType(FieldDataType.Struct.name()).build();
        SalesforceResponse salesforceResponse = this.getQueryConnectorResponse(queryObject, request.connectorContext());
        errorDetails = this.checkForErrorsInSalesforceResponse(salesforceResponse);
        if (Objects.nonNull(errorDetails)) {
            return ImmutableRetrieveDataResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        return ImmutableRetrieveDataResponse.builder().records(RecordResponseParser.parseQueryResponse(salesforceResponse.response())).isSuccess(true).build();
    }

    @Override
    public WriteDataResponse writeData(WriteDataRequest request) {
        ErrorDetails errorDetails = RequestValidator.validateWriteDataRequest(request);
        if (Objects.nonNull(errorDetails)) {
            LOGGER.error("WriteData request failed with errorDetails " + errorDetails);
            return ImmutableWriteDataResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        ArrayList<WriteRecordResult> recordResults = new ArrayList<WriteRecordResult>();
        for (String record : request.records()) {
            SalesforceResponse salesforceResponse = this.getSalesforceWriteResponse(record, request);
            errorDetails = this.checkForErrorsInSalesforceResponse(salesforceResponse);
            if (Objects.nonNull(errorDetails)) {
                return ImmutableWriteDataResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
            }
            if (!Objects.nonNull(salesforceResponse.response())) continue;
            recordResults.add(RecordResponseParser.parseWriteResponse(salesforceResponse.response()));
        }
        if (!WriteOperationType.UPDATE.equals((Object)request.operation()) && CollectionUtils.isEmpty(recordResults)) {
            return ImmutableWriteDataResponse.builder().isSuccess(false).build();
        }
        return ImmutableWriteDataResponse.builder().isSuccess(true).writeRecordResults(recordResults).build();
    }

    @Override
    public QueryDataResponse queryData(QueryDataRequest request) {
        ErrorDetails errorDetails = RequestValidator.validateQueryDataRequest(request);
        if (Objects.nonNull(errorDetails)) {
            LOGGER.error("QueryData request failed with errorDetails " + errorDetails);
            return ImmutableQueryDataResponse.builder().errorDetails(errorDetails).isSuccess(false).build();
        }
        ImmutableQueryObject queryObject = ImmutableQueryObject.builder().sObject(request.entityIdentifier()).selectedFieldNames(request.selectedFieldNames()).filterExpression(request.filterExpression()).entityDefinition(request.connectorContext().entityDefinition()).build();
        SalesforceResponse salesforceResponse = this.getQueryConnectorResponse(queryObject, request.connectorContext());
        errorDetails = this.checkForErrorsInSalesforceResponse(salesforceResponse);
        if (Objects.nonNull(errorDetails)) {
            return ImmutableQueryDataResponse.builder().errorDetails(errorDetails).isSuccess(false).build();
        }
        return ImmutableQueryDataResponse.builder().records(RecordResponseParser.parseQueryResponse(salesforceResponse.response())).isSuccess(true).build();
    }

    private SalesforceResponse getSalesforceWriteResponse(String record, WriteDataRequest request) {
        JsonNode recordJson;
        try {
            recordJson = MAPPER.readValue(record, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Invalid record provided for Write operation. Record must be valid JSON", e);
        }
        String requestUri = SalesforceRecordHandler.buildSalesforceRequestURI(request.connectorContext(), SALESFORCE_OBJECT_API_FORMAT, request.entityIdentifier());
        if (WriteOperationType.INSERT.equals((Object)request.operation())) {
            return this.getSalesforceClient(request.connectorContext()).restPost(requestUri, record);
        }
        if (WriteOperationType.UPDATE.equals((Object)request.operation())) {
            if (Objects.requireNonNull(request.idFieldNames()).size() != 1) {
                throw new IllegalArgumentException("A single Id field name is required for UPDATE operations in Salesforce");
            }
            String recordIdKey = request.idFieldNames().get(0);
            String recordId = this.getValueFromRecord(recordJson, recordIdKey);
            ((ObjectNode)recordJson).remove(recordIdKey);
            requestUri = requestUri + "/" + recordId;
            return this.getSalesforceClient(request.connectorContext()).restPatch(requestUri, recordJson.toString());
        }
        if (WriteOperationType.UPSERT.equals((Object)request.operation())) {
            if (Objects.requireNonNull(request.idFieldNames()).size() != 1) {
                throw new IllegalArgumentException("A single Id field name is required for UPSERT operations in Salesforce");
            }
            String recordIdKey = request.idFieldNames().get(0);
            String recordId = this.getValueFromRecord(recordJson, recordIdKey);
            ((ObjectNode)recordJson).remove(recordIdKey);
            requestUri = requestUri + "/" + recordIdKey + "/" + recordId;
            return this.getSalesforceClient(request.connectorContext()).restPatch(requestUri, recordJson.toString());
        }
        throw new IllegalArgumentException("Write Operation Type" + request.operation().name() + " is not supported.");
    }

    private SalesforceResponse getQueryConnectorResponse(QueryObject queryObject, ConnectorContext connectorContext) {
        String query = this.getQueryString(queryObject);
        String requestUri = SalesforceRecordHandler.buildSalesforceRequestURI(connectorContext, SALESFORCE_QUERY_FORMAT, query);
        HttpClient httpClient = this.getSalesforceClient(connectorContext);
        return httpClient.restGet(requestUri);
    }

    private String getQueryString(QueryObject queryObject) {
        try {
            return URLEncoder.encode(SalesforceQueryBuilder.buildQuery(queryObject), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unable to encode the url", ex);
        }
    }

    private String getValueFromRecord(JsonNode jsonRecord, String key) {
        if (Objects.isNull(jsonRecord) || Objects.isNull(jsonRecord.get(key))) {
            throw new IllegalArgumentException(key + " key is missing from JSON record but is required");
        }
        if (StringUtils.isEmpty(jsonRecord.get(key).textValue())) {
            throw new IllegalArgumentException("Invalid value for object identifier key " + key);
        }
        return jsonRecord.get(key).textValue();
    }
}

