/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.handler;

import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import com.amazonaws.appflow.custom.connector.example.client.HttpClient;
import com.amazonaws.appflow.custom.connector.example.configuration.SalesforceConnectorConfiguration;
import com.amazonaws.appflow.custom.connector.example.handler.AbstractSalesforceHandler;
import com.amazonaws.appflow.custom.connector.handlers.ConfigurationHandler;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationRequest;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ImmutableDescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableValidateCredentialsResponse;
import com.amazonaws.appflow.custom.connector.model.credentials.OAuth2Credentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsRequest;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsResponse;
import com.amazonaws.appflow.custom.connector.model.settings.ImmutableValidateConnectorRuntimeSettingsResponse;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsRequest;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsResponse;
import com.amazonaws.appflow.custom.connector.util.CredentialsProvider;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import java.util.Map;
import java.util.Objects;

public class SalesforceConfigurationHandler
extends AbstractSalesforceHandler
implements ConfigurationHandler {
    public static final String SALESFORCE_USERINFO_URL_FORMAT = "https://login.salesforce.com/services/oauth2/userinfo";
    public static final String SALESFORCE_USERINFO_SANDBOX_URL_FORMAT = "https://test.salesforce.com/services/oauth2/userinfo";
    public static final String TRUE = "TRUE";
    private static final String CONNECTOR_OWNER = "SampleConnector";
    private static final String CONNECTOR_NAME = "SampleSalesforceConnector";
    private static final String CONNECTOR_VERSION = "1.0";

    @Override
    public ValidateConnectorRuntimeSettingsResponse validateConnectorRuntimeSettings(ValidateConnectorRuntimeSettingsRequest request) {
        return ImmutableValidateConnectorRuntimeSettingsResponse.builder().isSuccess(true).build();
    }

    @Override
    public ValidateCredentialsResponse validateCredentials(ValidateCredentialsRequest request) {
        String requestUri = this.buildSalesforceUserInfoRequest(request);
        SalesforceResponse response = this.getSalesforceClient(request.credentials()).restGet(requestUri);
        ErrorDetails errorDetails = this.checkForErrorsInSalesforceResponse(response);
        if (Objects.nonNull(errorDetails)) {
            return ImmutableValidateCredentialsResponse.builder().isSuccess(false).errorDetails(errorDetails).build();
        }
        return ImmutableValidateCredentialsResponse.builder().isSuccess(true).build();
    }

    @Override
    public DescribeConnectorConfigurationResponse describeConnectorConfiguration(DescribeConnectorConfigurationRequest request) {
        return ImmutableDescribeConnectorConfigurationResponse.builder().isSuccess(true).connectorOwner(CONNECTOR_OWNER).connectorName(CONNECTOR_NAME).connectorVersion(CONNECTOR_VERSION).connectorModes(SalesforceConnectorConfiguration.getConnectorModes()).connectorRuntimeSetting(SalesforceConnectorConfiguration.getConnectorRuntimeSettings()).authenticationConfig(SalesforceConnectorConfiguration.getAuthenticationConfig()).supportedApiVersions(SalesforceConnectorConfiguration.getSupportedApiVersions()).supportedWriteOperations(SalesforceConnectorConfiguration.supportedWriteOperations()).build();
    }

    private String buildSalesforceUserInfoRequest(ValidateCredentialsRequest request) {
        Map<String, String> connectorRuntimeSettings = request.connectorRuntimeSettings();
        if (Objects.isNull(connectorRuntimeSettings)) {
            return SALESFORCE_USERINFO_URL_FORMAT;
        }
        if (connectorRuntimeSettings.containsKey("IsSandboxAccount") && TRUE.equalsIgnoreCase(connectorRuntimeSettings.get("IsSandboxAccount"))) {
            return SALESFORCE_USERINFO_SANDBOX_URL_FORMAT;
        }
        return SALESFORCE_USERINFO_URL_FORMAT;
    }

    private HttpClient getSalesforceClient(Credentials credentials) {
        OAuth2Credentials creds = CredentialsProvider.getOAuth2Credentials(AWSSecretsManagerClientBuilder.defaultClient(), credentials.secretArn());
        return new HttpClient(creds.accessToken());
    }
}

