/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.example.handler;

import com.amazonaws.appflow.custom.connector.example.SalesforceResponse;
import com.amazonaws.appflow.custom.connector.example.client.HttpClient;
import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.ErrorCode;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.ImmutableErrorDetails;
import com.amazonaws.appflow.custom.connector.model.credentials.OAuth2Credentials;
import com.amazonaws.appflow.custom.connector.util.CredentialsProvider;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSalesforceHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSalesforceHandler.class);
    private static final Range<Integer> HTTP_STATUS_SUCCESS_CODE_RANGE = Range.between(200, 299);

    protected HttpClient getSalesforceClient(ConnectorContext connectorContext) {
        LOGGER.info("Fetching access token from Secret Arn.");
        OAuth2Credentials credentials = CredentialsProvider.getOAuth2Credentials(AWSSecretsManagerClientBuilder.defaultClient(), connectorContext.credentials().secretArn());
        return new HttpClient(credentials.accessToken());
    }

    protected ErrorDetails checkForErrorsInSalesforceResponse(SalesforceResponse response) {
        int statusCode = response.statusCode();
        if (statusCode >= HTTP_STATUS_SUCCESS_CODE_RANGE.getMinimum() && statusCode < HTTP_STATUS_SUCCESS_CODE_RANGE.getMaximum()) {
            return null;
        }
        ErrorCode errorCode = null;
        errorCode = statusCode == 401 ? ErrorCode.InvalidCredentials : (statusCode == 400 ? ErrorCode.InvalidArgument : ErrorCode.ServerError);
        String errorMessage = "Request failed with status code " + response.statusCode() + " error reason " + response.errorReason() + " and salesforce response is " + response.response();
        LOGGER.error(errorMessage);
        return ImmutableErrorDetails.builder().errorCode(errorCode).errorMessage(errorMessage).build();
    }

    protected static String buildSalesforceRequestURI(ConnectorContext connectorContext, String urlFormat, String requestPath) {
        Map<String, String> connectorRuntimeSettings = connectorContext.connectorRuntimeSettings();
        String instanceUrl = connectorRuntimeSettings.get("instanceUrl");
        instanceUrl = AbstractSalesforceHandler.addPath(instanceUrl);
        String apiVersion = connectorContext.apiVersion();
        String requestUri = Objects.nonNull(requestPath) ? String.format(urlFormat, instanceUrl, apiVersion, requestPath) : String.format(urlFormat, instanceUrl, apiVersion);
        return requestUri;
    }

    private static String addPath(String url) {
        if (url.endsWith("/")) {
            return url;
        }
        return url + "/";
    }
}

