/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.util;

import com.amazonaws.appflow.custom.connector.model.credentials.ApiKeyCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.BasicAuthCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.CustomAuthCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableApiKeyCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableBasicAuthCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableCustomAuthCredentials;
import com.amazonaws.appflow.custom.connector.model.credentials.ImmutableOAuth2Credentials;
import com.amazonaws.appflow.custom.connector.model.credentials.OAuth2Credentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public final class CredentialsProvider {
    private CredentialsProvider() {
    }

    private static Map<String, String> getCredentials(AWSSecretsManager client, String secretArn) {
        AWSSecretsManager secretsManager = null;
        GetSecretValueRequest getSecretValueRequest = new GetSecretValueRequest().withSecretId(secretArn);
        try {
            Map credentials;
            GetSecretValueResult secretValueResult;
            if (client != null) {
                secretValueResult = client.getSecretValue(getSecretValueRequest);
            } else {
                secretsManager = AWSSecretsManagerClientBuilder.defaultClient();
                secretValueResult = secretsManager.getSecretValue(getSecretValueRequest);
            }
            ObjectMapper objectMapper = new ObjectMapper();
            Map map = credentials = (Map)objectMapper.readValue(secretValueResult.getSecretString(), HashMap.class);
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to get secrets from SecretsManager. SecretArn [%s]: %s", secretArn, e.getMessage()), e);
        }
        finally {
            if (secretsManager != null) {
                secretsManager.shutdown();
            }
        }
    }

    public static BasicAuthCredentials getBasicAuthCredentials(AWSSecretsManager client, String secretArn) {
        Map<String, String> credentials = CredentialsProvider.getCredentials(client, secretArn);
        return ImmutableBasicAuthCredentials.builder().userName(credentials.get("username")).password(credentials.get("password")).build();
    }

    public static OAuth2Credentials getOAuth2Credentials(AWSSecretsManager client, String secretArn) {
        Map<String, String> credentials = CredentialsProvider.getCredentials(client, secretArn);
        return ImmutableOAuth2Credentials.builder().accessToken(credentials.get("accessToken")).build();
    }

    public static ApiKeyCredentials getApiKeyCredentials(AWSSecretsManager client, String secretArn) {
        Map<String, String> credentials = CredentialsProvider.getCredentials(client, secretArn);
        return ImmutableApiKeyCredentials.builder().apiKey(credentials.get("apiKey")).secretKey(credentials.get("secretKey")).build();
    }

    public static CustomAuthCredentials getCustomAuthCredentials(AWSSecretsManager client, String secretArn) {
        Map<String, String> credentials = CredentialsProvider.getCredentials(client, secretArn);
        String customAuthenticationType = credentials.get("customAuthenticationType");
        credentials.remove("customAuthenticationType");
        credentials.remove("authenticationType");
        return ImmutableCustomAuthCredentials.builder().customAuthenticationType(customAuthenticationType).customCredentials(credentials).build();
    }
}

