/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.write;

import com.amazonaws.appflow.custom.connector.model.write.WriteRecordResult;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="WriteRecordResult", generator="Immutables")
@Immutable
public final class ImmutableWriteRecordResult
implements WriteRecordResult {
    private final boolean isSuccess;
    private final String recordId;
    @Nullable
    private final String errorMessage;

    private ImmutableWriteRecordResult(boolean isSuccess, String recordId, @Nullable String errorMessage) {
        this.isSuccess = isSuccess;
        this.recordId = recordId;
        this.errorMessage = errorMessage;
    }

    @Override
    @JsonProperty(value="isSuccess")
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    @JsonProperty(value="recordId")
    public String recordId() {
        return this.recordId;
    }

    @Override
    @JsonProperty(value="errorMessage")
    @Nullable
    public String errorMessage() {
        return this.errorMessage;
    }

    public final ImmutableWriteRecordResult withIsSuccess(boolean value) {
        if (this.isSuccess == value) {
            return this;
        }
        return new ImmutableWriteRecordResult(value, this.recordId, this.errorMessage);
    }

    public final ImmutableWriteRecordResult withRecordId(String value) {
        String newValue = Objects.requireNonNull(value, "recordId");
        if (this.recordId.equals(newValue)) {
            return this;
        }
        return new ImmutableWriteRecordResult(this.isSuccess, newValue, this.errorMessage);
    }

    public final ImmutableWriteRecordResult withErrorMessage(@Nullable String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableWriteRecordResult(this.isSuccess, this.recordId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWriteRecordResult && this.equalTo(0, (ImmutableWriteRecordResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableWriteRecordResult another) {
        return this.isSuccess == another.isSuccess && this.recordId.equals(another.recordId) && Objects.equals(this.errorMessage, another.errorMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isSuccess);
        h += (h << 5) + this.recordId.hashCode();
        h += (h << 5) + Objects.hashCode(this.errorMessage);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"WriteRecordResult").omitNullValues().add("isSuccess", this.isSuccess).add("recordId", (Object)this.recordId).add("errorMessage", (Object)this.errorMessage).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWriteRecordResult fromJson(Json json) {
        Builder builder = ImmutableWriteRecordResult.builder();
        if (json.isSuccessIsSet) {
            builder.isSuccess(json.isSuccess);
        }
        if (json.recordId != null) {
            builder.recordId(json.recordId);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        return builder.build();
    }

    public static ImmutableWriteRecordResult copyOf(WriteRecordResult instance) {
        if (instance instanceof ImmutableWriteRecordResult) {
            return (ImmutableWriteRecordResult)instance;
        }
        return ImmutableWriteRecordResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="WriteRecordResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_SUCCESS = 1L;
        private static final long INIT_BIT_RECORD_ID = 2L;
        private long initBits = 3L;
        private boolean isSuccess;
        @Nullable
        private String recordId;
        @Nullable
        private String errorMessage;

        private Builder() {
        }

        public final Builder from(WriteRecordResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.isSuccess(instance.isSuccess());
            this.recordId(instance.recordId());
            String errorMessageValue = instance.errorMessage();
            if (errorMessageValue != null) {
                this.errorMessage(errorMessageValue);
            }
            return this;
        }

        @JsonProperty(value="isSuccess")
        public final Builder isSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="recordId")
        public final Builder recordId(String recordId) {
            this.recordId = Objects.requireNonNull(recordId, "recordId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="errorMessage")
        public final Builder errorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ImmutableWriteRecordResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWriteRecordResult(this.isSuccess, this.recordId, this.errorMessage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isSuccess");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("recordId");
            }
            return "Cannot build WriteRecordResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WriteRecordResult", generator="Immutables")
    static final class Json
    implements WriteRecordResult {
        boolean isSuccess;
        boolean isSuccessIsSet;
        @Nullable
        String recordId;
        @Nullable
        String errorMessage;

        Json() {
        }

        @JsonProperty(value="isSuccess")
        public void setIsSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.isSuccessIsSet = true;
        }

        @JsonProperty(value="recordId")
        public void setRecordId(String recordId) {
            this.recordId = recordId;
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public boolean isSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String recordId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String errorMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

