/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.settings;

import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSetting;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingDataType;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSettingScope;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConnectorRuntimeSetting", generator="Immutables")
@Immutable
public final class ImmutableConnectorRuntimeSetting
implements ConnectorRuntimeSetting {
    private final String key;
    private final ConnectorRuntimeSettingDataType dataType;
    private final boolean required;
    private final String label;
    private final String description;
    private final ConnectorRuntimeSettingScope scope;
    @Nullable
    private final ImmutableList<String> connectorSuppliedValueOptions;

    private ImmutableConnectorRuntimeSetting(String key, ConnectorRuntimeSettingDataType dataType, boolean required, String label, String description, ConnectorRuntimeSettingScope scope, @Nullable ImmutableList<String> connectorSuppliedValueOptions) {
        this.key = key;
        this.dataType = dataType;
        this.required = required;
        this.label = label;
        this.description = description;
        this.scope = scope;
        this.connectorSuppliedValueOptions = connectorSuppliedValueOptions;
    }

    @Override
    @JsonProperty(value="key")
    public String key() {
        return this.key;
    }

    @Override
    @JsonProperty(value="dataType")
    public ConnectorRuntimeSettingDataType dataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="required")
    public boolean required() {
        return this.required;
    }

    @Override
    @JsonProperty(value="label")
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="description")
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="scope")
    public ConnectorRuntimeSettingScope scope() {
        return this.scope;
    }

    @JsonProperty(value="connectorSuppliedValueOptions")
    @Nullable
    public ImmutableList<String> connectorSuppliedValueOptions() {
        return this.connectorSuppliedValueOptions;
    }

    public final ImmutableConnectorRuntimeSetting withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(newValue, this.dataType, this.required, this.label, this.description, this.scope, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withDataType(ConnectorRuntimeSettingDataType value) {
        ConnectorRuntimeSettingDataType newValue = Objects.requireNonNull(value, "dataType");
        if (this.dataType == newValue) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(this.key, newValue, this.required, this.label, this.description, this.scope, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withRequired(boolean value) {
        if (this.required == value) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, value, this.label, this.description, this.scope, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, newValue, this.description, this.scope, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, newValue, this.scope, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withScope(ConnectorRuntimeSettingScope value) {
        ConnectorRuntimeSettingScope newValue = Objects.requireNonNull(value, "scope");
        if (this.scope == newValue) {
            return this;
        }
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, this.description, newValue, this.connectorSuppliedValueOptions);
    }

    public final ImmutableConnectorRuntimeSetting withConnectorSuppliedValueOptions(String ... elements) {
        if (elements == null) {
            return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, this.description, this.scope, null);
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf((Object[])elements);
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, this.description, this.scope, (ImmutableList<String>)newValue);
    }

    public final ImmutableConnectorRuntimeSetting withConnectorSuppliedValueOptions(@Nullable Iterable<String> elements) {
        if (this.connectorSuppliedValueOptions == elements) {
            return this;
        }
        ImmutableList newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, this.description, this.scope, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectorRuntimeSetting && this.equalTo(0, (ImmutableConnectorRuntimeSetting)another);
    }

    private boolean equalTo(int synthetic, ImmutableConnectorRuntimeSetting another) {
        return this.key.equals(another.key) && this.dataType.equals((Object)another.dataType) && this.required == another.required && this.label.equals(another.label) && this.description.equals(another.description) && this.scope.equals((Object)another.scope) && Objects.equals(this.connectorSuppliedValueOptions, another.connectorSuppliedValueOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.dataType.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.required);
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + Objects.hashCode(this.connectorSuppliedValueOptions);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectorRuntimeSetting").omitNullValues().add("key", (Object)this.key).add("dataType", (Object)this.dataType).add("required", this.required).add("label", (Object)this.label).add("description", (Object)this.description).add("scope", (Object)this.scope).add("connectorSuppliedValueOptions", this.connectorSuppliedValueOptions).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConnectorRuntimeSetting fromJson(Json json) {
        Builder builder = ImmutableConnectorRuntimeSetting.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.dataType != null) {
            builder.dataType(json.dataType);
        }
        if (json.requiredIsSet) {
            builder.required(json.required);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.scope != null) {
            builder.scope(json.scope);
        }
        if (json.connectorSuppliedValueOptions != null) {
            builder.addAllConnectorSuppliedValueOptions(json.connectorSuppliedValueOptions);
        }
        return builder.build();
    }

    public static ImmutableConnectorRuntimeSetting copyOf(ConnectorRuntimeSetting instance) {
        if (instance instanceof ImmutableConnectorRuntimeSetting) {
            return (ImmutableConnectorRuntimeSetting)instance;
        }
        return ImmutableConnectorRuntimeSetting.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectorRuntimeSetting", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_DATA_TYPE = 2L;
        private static final long INIT_BIT_REQUIRED = 4L;
        private static final long INIT_BIT_LABEL = 8L;
        private static final long INIT_BIT_DESCRIPTION = 16L;
        private static final long INIT_BIT_SCOPE = 32L;
        private long initBits = 63L;
        @Nullable
        private String key;
        @Nullable
        private ConnectorRuntimeSettingDataType dataType;
        private boolean required;
        @Nullable
        private String label;
        @Nullable
        private String description;
        @Nullable
        private ConnectorRuntimeSettingScope scope;
        private ImmutableList.Builder<String> connectorSuppliedValueOptions = null;

        private Builder() {
        }

        public final Builder from(ConnectorRuntimeSetting instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.dataType(instance.dataType());
            this.required(instance.required());
            this.label(instance.label());
            this.description(instance.description());
            this.scope(instance.scope());
            List<String> connectorSuppliedValueOptionsValue = instance.connectorSuppliedValueOptions();
            if (connectorSuppliedValueOptionsValue != null) {
                this.addAllConnectorSuppliedValueOptions(connectorSuppliedValueOptionsValue);
            }
            return this;
        }

        @JsonProperty(value="key")
        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dataType")
        public final Builder dataType(ConnectorRuntimeSettingDataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="required")
        public final Builder required(boolean required) {
            this.required = required;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="scope")
        public final Builder scope(ConnectorRuntimeSettingScope scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder addConnectorSuppliedValueOptions(String element) {
            if (this.connectorSuppliedValueOptions == null) {
                this.connectorSuppliedValueOptions = ImmutableList.builder();
            }
            this.connectorSuppliedValueOptions.add((Object)element);
            return this;
        }

        public final Builder addConnectorSuppliedValueOptions(String ... elements) {
            if (this.connectorSuppliedValueOptions == null) {
                this.connectorSuppliedValueOptions = ImmutableList.builder();
            }
            this.connectorSuppliedValueOptions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="connectorSuppliedValueOptions")
        public final Builder connectorSuppliedValueOptions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.connectorSuppliedValueOptions = null;
                return this;
            }
            this.connectorSuppliedValueOptions = ImmutableList.builder();
            return this.addAllConnectorSuppliedValueOptions(elements);
        }

        public final Builder addAllConnectorSuppliedValueOptions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "connectorSuppliedValueOptions element");
            if (this.connectorSuppliedValueOptions == null) {
                this.connectorSuppliedValueOptions = ImmutableList.builder();
            }
            this.connectorSuppliedValueOptions.addAll(elements);
            return this;
        }

        public ImmutableConnectorRuntimeSetting build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectorRuntimeSetting(this.key, this.dataType, this.required, this.label, this.description, this.scope, this.connectorSuppliedValueOptions == null ? null : this.connectorSuppliedValueOptions.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dataType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("required");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build ConnectorRuntimeSetting, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConnectorRuntimeSetting", generator="Immutables")
    static final class Json
    implements ConnectorRuntimeSetting {
        @Nullable
        String key;
        @Nullable
        ConnectorRuntimeSettingDataType dataType;
        boolean required;
        boolean requiredIsSet;
        @Nullable
        String label;
        @Nullable
        String description;
        @Nullable
        ConnectorRuntimeSettingScope scope;
        @Nullable
        List<String> connectorSuppliedValueOptions = null;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(String key) {
            this.key = key;
        }

        @JsonProperty(value="dataType")
        public void setDataType(ConnectorRuntimeSettingDataType dataType) {
            this.dataType = dataType;
        }

        @JsonProperty(value="required")
        public void setRequired(boolean required) {
            this.required = required;
            this.requiredIsSet = true;
        }

        @JsonProperty(value="label")
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty(value="description")
        public void setDescription(String description) {
            this.description = description;
        }

        @JsonProperty(value="scope")
        public void setScope(ConnectorRuntimeSettingScope scope) {
            this.scope = scope;
        }

        @JsonProperty(value="connectorSuppliedValueOptions")
        public void setConnectorSuppliedValueOptions(@Nullable List<String> connectorSuppliedValueOptions) {
            this.connectorSuppliedValueOptions = connectorSuppliedValueOptions;
        }

        @Override
        public String key() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorRuntimeSettingDataType dataType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean required() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorRuntimeSettingScope scope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> connectorSuppliedValueOptions() {
            throw new UnsupportedOperationException();
        }
    }
}

