/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.metadata.RangeConstraint;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="RangeConstraint", generator="Immutables")
@Immutable
public final class ImmutableRangeConstraint
implements RangeConstraint {
    private final BigDecimal minRange;
    private final BigDecimal maxRange;

    private ImmutableRangeConstraint(BigDecimal minRange, BigDecimal maxRange) {
        this.minRange = minRange;
        this.maxRange = maxRange;
    }

    @Override
    @JsonProperty(value="minRange")
    public BigDecimal minRange() {
        return this.minRange;
    }

    @Override
    @JsonProperty(value="maxRange")
    public BigDecimal maxRange() {
        return this.maxRange;
    }

    public final ImmutableRangeConstraint withMinRange(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "minRange");
        if (this.minRange.equals(newValue)) {
            return this;
        }
        return new ImmutableRangeConstraint(newValue, this.maxRange);
    }

    public final ImmutableRangeConstraint withMaxRange(BigDecimal value) {
        BigDecimal newValue = Objects.requireNonNull(value, "maxRange");
        if (this.maxRange.equals(newValue)) {
            return this;
        }
        return new ImmutableRangeConstraint(this.minRange, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRangeConstraint && this.equalTo(0, (ImmutableRangeConstraint)another);
    }

    private boolean equalTo(int synthetic, ImmutableRangeConstraint another) {
        return this.minRange.equals(another.minRange) && this.maxRange.equals(another.maxRange);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.minRange.hashCode();
        h += (h << 5) + this.maxRange.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RangeConstraint").omitNullValues().add("minRange", (Object)this.minRange).add("maxRange", (Object)this.maxRange).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableRangeConstraint fromJson(Json json) {
        Builder builder = ImmutableRangeConstraint.builder();
        if (json.minRange != null) {
            builder.minRange(json.minRange);
        }
        if (json.maxRange != null) {
            builder.maxRange(json.maxRange);
        }
        return builder.build();
    }

    public static ImmutableRangeConstraint copyOf(RangeConstraint instance) {
        if (instance instanceof ImmutableRangeConstraint) {
            return (ImmutableRangeConstraint)instance;
        }
        return ImmutableRangeConstraint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RangeConstraint", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MIN_RANGE = 1L;
        private static final long INIT_BIT_MAX_RANGE = 2L;
        private long initBits = 3L;
        @Nullable
        private BigDecimal minRange;
        @Nullable
        private BigDecimal maxRange;

        private Builder() {
        }

        public final Builder from(RangeConstraint instance) {
            Objects.requireNonNull(instance, "instance");
            this.minRange(instance.minRange());
            this.maxRange(instance.maxRange());
            return this;
        }

        @JsonProperty(value="minRange")
        public final Builder minRange(BigDecimal minRange) {
            this.minRange = Objects.requireNonNull(minRange, "minRange");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="maxRange")
        public final Builder maxRange(BigDecimal maxRange) {
            this.maxRange = Objects.requireNonNull(maxRange, "maxRange");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRangeConstraint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRangeConstraint(this.minRange, this.maxRange);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("minRange");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("maxRange");
            }
            return "Cannot build RangeConstraint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="RangeConstraint", generator="Immutables")
    static final class Json
    implements RangeConstraint {
        @Nullable
        BigDecimal minRange;
        @Nullable
        BigDecimal maxRange;

        Json() {
        }

        @JsonProperty(value="minRange")
        public void setMinRange(BigDecimal minRange) {
            this.minRange = minRange;
        }

        @JsonProperty(value="maxRange")
        public void setMaxRange(BigDecimal maxRange) {
            this.maxRange = maxRange;
        }

        @Override
        public BigDecimal minRange() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal maxRange() {
            throw new UnsupportedOperationException();
        }
    }
}

