/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.BasicAuthCredentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BasicAuthCredentials", generator="Immutables")
@Immutable
public final class ImmutableBasicAuthCredentials
implements BasicAuthCredentials {
    private final String userName;
    private final String password;

    private ImmutableBasicAuthCredentials(String userName, String password) {
        this.userName = userName;
        this.password = password;
    }

    @Override
    @JsonProperty(value="userName")
    public String userName() {
        return this.userName;
    }

    @Override
    @JsonProperty(value="password")
    public String password() {
        return this.password;
    }

    public final ImmutableBasicAuthCredentials withUserName(String value) {
        String newValue = Objects.requireNonNull(value, "userName");
        if (this.userName.equals(newValue)) {
            return this;
        }
        return new ImmutableBasicAuthCredentials(newValue, this.password);
    }

    public final ImmutableBasicAuthCredentials withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (this.password.equals(newValue)) {
            return this;
        }
        return new ImmutableBasicAuthCredentials(this.userName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasicAuthCredentials && this.equalTo(0, (ImmutableBasicAuthCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasicAuthCredentials another) {
        return this.userName.equals(another.userName) && this.password.equals(another.password);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.userName.hashCode();
        h += (h << 5) + this.password.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"BasicAuthCredentials").omitNullValues().add("userName", (Object)this.userName).add("password", (Object)this.password).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableBasicAuthCredentials fromJson(Json json) {
        Builder builder = ImmutableBasicAuthCredentials.builder();
        if (json.userName != null) {
            builder.userName(json.userName);
        }
        if (json.password != null) {
            builder.password(json.password);
        }
        return builder.build();
    }

    public static ImmutableBasicAuthCredentials copyOf(BasicAuthCredentials instance) {
        if (instance instanceof ImmutableBasicAuthCredentials) {
            return (ImmutableBasicAuthCredentials)instance;
        }
        return ImmutableBasicAuthCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BasicAuthCredentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_NAME = 1L;
        private static final long INIT_BIT_PASSWORD = 2L;
        private long initBits = 3L;
        @Nullable
        private String userName;
        @Nullable
        private String password;

        private Builder() {
        }

        public final Builder from(BasicAuthCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.userName(instance.userName());
            this.password(instance.password());
            return this;
        }

        @JsonProperty(value="userName")
        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="password")
        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableBasicAuthCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasicAuthCredentials(this.userName, this.password);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("userName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("password");
            }
            return "Cannot build BasicAuthCredentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BasicAuthCredentials", generator="Immutables")
    static final class Json
    implements BasicAuthCredentials {
        @Nullable
        String userName;
        @Nullable
        String password;

        Json() {
        }

        @JsonProperty(value="userName")
        public void setUserName(String userName) {
            this.userName = userName;
        }

        @JsonProperty(value="password")
        public void setPassword(String password) {
            this.password = password;
        }

        @Override
        public String userName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String password() {
            throw new UnsupportedOperationException();
        }
    }
}

