/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model;

import com.amazonaws.appflow.custom.connector.model.ErrorCode;
import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ErrorDetails", generator="Immutables")
@Immutable
public final class ImmutableErrorDetails
implements ErrorDetails {
    private final ErrorCode errorCode;
    @Nullable
    private final Integer retryAfterSeconds;
    private final String errorMessage;

    private ImmutableErrorDetails(ErrorCode errorCode, @Nullable Integer retryAfterSeconds, String errorMessage) {
        this.errorCode = errorCode;
        this.retryAfterSeconds = retryAfterSeconds;
        this.errorMessage = errorMessage;
    }

    @Override
    @JsonProperty(value="errorCode")
    public ErrorCode errorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="retryAfterSeconds")
    @Nullable
    public Integer retryAfterSeconds() {
        return this.retryAfterSeconds;
    }

    @Override
    @JsonProperty(value="errorMessage")
    public String errorMessage() {
        return this.errorMessage;
    }

    public final ImmutableErrorDetails withErrorCode(ErrorCode value) {
        ErrorCode newValue = Objects.requireNonNull(value, "errorCode");
        if (this.errorCode == newValue) {
            return this;
        }
        return new ImmutableErrorDetails(newValue, this.retryAfterSeconds, this.errorMessage);
    }

    public final ImmutableErrorDetails withRetryAfterSeconds(@Nullable Integer value) {
        if (Objects.equals(this.retryAfterSeconds, value)) {
            return this;
        }
        return new ImmutableErrorDetails(this.errorCode, value, this.errorMessage);
    }

    public final ImmutableErrorDetails withErrorMessage(String value) {
        String newValue = Objects.requireNonNull(value, "errorMessage");
        if (this.errorMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableErrorDetails(this.errorCode, this.retryAfterSeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableErrorDetails && this.equalTo(0, (ImmutableErrorDetails)another);
    }

    private boolean equalTo(int synthetic, ImmutableErrorDetails another) {
        return this.errorCode.equals((Object)another.errorCode) && Objects.equals(this.retryAfterSeconds, another.retryAfterSeconds) && this.errorMessage.equals(another.errorMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.errorCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.retryAfterSeconds);
        h += (h << 5) + this.errorMessage.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ErrorDetails").omitNullValues().add("errorCode", (Object)this.errorCode).add("retryAfterSeconds", (Object)this.retryAfterSeconds).add("errorMessage", (Object)this.errorMessage).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableErrorDetails fromJson(Json json) {
        Builder builder = ImmutableErrorDetails.builder();
        if (json.errorCode != null) {
            builder.errorCode(json.errorCode);
        }
        if (json.retryAfterSeconds != null) {
            builder.retryAfterSeconds(json.retryAfterSeconds);
        }
        if (json.errorMessage != null) {
            builder.errorMessage(json.errorMessage);
        }
        return builder.build();
    }

    public static ImmutableErrorDetails copyOf(ErrorDetails instance) {
        if (instance instanceof ImmutableErrorDetails) {
            return (ImmutableErrorDetails)instance;
        }
        return ImmutableErrorDetails.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ErrorDetails", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ERROR_CODE = 1L;
        private static final long INIT_BIT_ERROR_MESSAGE = 2L;
        private long initBits = 3L;
        @Nullable
        private ErrorCode errorCode;
        @Nullable
        private Integer retryAfterSeconds;
        @Nullable
        private String errorMessage;

        private Builder() {
        }

        public final Builder from(ErrorDetails instance) {
            Objects.requireNonNull(instance, "instance");
            this.errorCode(instance.errorCode());
            Integer retryAfterSecondsValue = instance.retryAfterSeconds();
            if (retryAfterSecondsValue != null) {
                this.retryAfterSeconds(retryAfterSecondsValue);
            }
            this.errorMessage(instance.errorMessage());
            return this;
        }

        @JsonProperty(value="errorCode")
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode = Objects.requireNonNull(errorCode, "errorCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="retryAfterSeconds")
        public final Builder retryAfterSeconds(@Nullable Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        @JsonProperty(value="errorMessage")
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableErrorDetails build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableErrorDetails(this.errorCode, this.retryAfterSeconds, this.errorMessage);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("errorCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorMessage");
            }
            return "Cannot build ErrorDetails, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ErrorDetails", generator="Immutables")
    static final class Json
    implements ErrorDetails {
        @Nullable
        ErrorCode errorCode;
        @Nullable
        Integer retryAfterSeconds;
        @Nullable
        String errorMessage;

        Json() {
        }

        @JsonProperty(value="errorCode")
        public void setErrorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
        }

        @JsonProperty(value="retryAfterSeconds")
        public void setRetryAfterSeconds(@Nullable Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @JsonProperty(value="errorMessage")
        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public ErrorCode errorCode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer retryAfterSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String errorMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

