/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model;

import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.credentials.Credentials;
import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConnectorContext", generator="Immutables")
@Immutable
public final class ImmutableConnectorContext
implements ConnectorContext {
    @Nullable
    private final ImmutableMap<String, String> connectorRuntimeSettings;
    @Nullable
    private final Credentials credentials;
    private final String apiVersion;
    @Nullable
    private final String flowName;
    @Nullable
    private final String executionId;
    @Nullable
    private final String connectorProfileLabel;
    @Nullable
    private final EntityDefinition entityDefinition;

    private ImmutableConnectorContext(@Nullable ImmutableMap<String, String> connectorRuntimeSettings, @Nullable Credentials credentials, String apiVersion, @Nullable String flowName, @Nullable String executionId, @Nullable String connectorProfileLabel, @Nullable EntityDefinition entityDefinition) {
        this.connectorRuntimeSettings = connectorRuntimeSettings;
        this.credentials = credentials;
        this.apiVersion = apiVersion;
        this.flowName = flowName;
        this.executionId = executionId;
        this.connectorProfileLabel = connectorProfileLabel;
        this.entityDefinition = entityDefinition;
    }

    @JsonProperty(value="connectorRuntimeSettings")
    @Nullable
    public ImmutableMap<String, String> connectorRuntimeSettings() {
        return this.connectorRuntimeSettings;
    }

    @Override
    @JsonProperty(value="credentials")
    @Nullable
    public Credentials credentials() {
        return this.credentials;
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String apiVersion() {
        return this.apiVersion;
    }

    @Override
    @JsonProperty(value="flowName")
    @Nullable
    public String flowName() {
        return this.flowName;
    }

    @Override
    @JsonProperty(value="executionId")
    @Nullable
    public String executionId() {
        return this.executionId;
    }

    @Override
    @JsonProperty(value="connectorProfileLabel")
    @Nullable
    public String connectorProfileLabel() {
        return this.connectorProfileLabel;
    }

    @Override
    @JsonProperty(value="entityDefinition")
    @Nullable
    public EntityDefinition entityDefinition() {
        return this.entityDefinition;
    }

    public final ImmutableConnectorContext withConnectorRuntimeSettings(@Nullable Map<String, ? extends String> entries) {
        if (this.connectorRuntimeSettings == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableConnectorContext((ImmutableMap<String, String>)newValue, this.credentials, this.apiVersion, this.flowName, this.executionId, this.connectorProfileLabel, this.entityDefinition);
    }

    public final ImmutableConnectorContext withCredentials(@Nullable Credentials value) {
        if (this.credentials == value) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, value, this.apiVersion, this.flowName, this.executionId, this.connectorProfileLabel, this.entityDefinition);
    }

    public final ImmutableConnectorContext withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (this.apiVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, this.credentials, newValue, this.flowName, this.executionId, this.connectorProfileLabel, this.entityDefinition);
    }

    public final ImmutableConnectorContext withFlowName(@Nullable String value) {
        if (Objects.equals(this.flowName, value)) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, this.credentials, this.apiVersion, value, this.executionId, this.connectorProfileLabel, this.entityDefinition);
    }

    public final ImmutableConnectorContext withExecutionId(@Nullable String value) {
        if (Objects.equals(this.executionId, value)) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, this.credentials, this.apiVersion, this.flowName, value, this.connectorProfileLabel, this.entityDefinition);
    }

    public final ImmutableConnectorContext withConnectorProfileLabel(@Nullable String value) {
        if (Objects.equals(this.connectorProfileLabel, value)) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, this.credentials, this.apiVersion, this.flowName, this.executionId, value, this.entityDefinition);
    }

    public final ImmutableConnectorContext withEntityDefinition(@Nullable EntityDefinition value) {
        if (this.entityDefinition == value) {
            return this;
        }
        return new ImmutableConnectorContext(this.connectorRuntimeSettings, this.credentials, this.apiVersion, this.flowName, this.executionId, this.connectorProfileLabel, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConnectorContext && this.equalTo(0, (ImmutableConnectorContext)another);
    }

    private boolean equalTo(int synthetic, ImmutableConnectorContext another) {
        return Objects.equals(this.connectorRuntimeSettings, another.connectorRuntimeSettings) && Objects.equals(this.credentials, another.credentials) && this.apiVersion.equals(another.apiVersion) && Objects.equals(this.flowName, another.flowName) && Objects.equals(this.executionId, another.executionId) && Objects.equals(this.connectorProfileLabel, another.connectorProfileLabel) && Objects.equals(this.entityDefinition, another.entityDefinition);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.connectorRuntimeSettings);
        h += (h << 5) + Objects.hashCode(this.credentials);
        h += (h << 5) + this.apiVersion.hashCode();
        h += (h << 5) + Objects.hashCode(this.flowName);
        h += (h << 5) + Objects.hashCode(this.executionId);
        h += (h << 5) + Objects.hashCode(this.connectorProfileLabel);
        h += (h << 5) + Objects.hashCode(this.entityDefinition);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ConnectorContext").omitNullValues().add("connectorRuntimeSettings", this.connectorRuntimeSettings).add("credentials", (Object)this.credentials).add("apiVersion", (Object)this.apiVersion).add("flowName", (Object)this.flowName).add("executionId", (Object)this.executionId).add("connectorProfileLabel", (Object)this.connectorProfileLabel).add("entityDefinition", (Object)this.entityDefinition).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableConnectorContext fromJson(Json json) {
        Builder builder = ImmutableConnectorContext.builder();
        if (json.connectorRuntimeSettings != null) {
            builder.putAllConnectorRuntimeSettings(json.connectorRuntimeSettings);
        }
        if (json.credentials != null) {
            builder.credentials(json.credentials);
        }
        if (json.apiVersion != null) {
            builder.apiVersion(json.apiVersion);
        }
        if (json.flowName != null) {
            builder.flowName(json.flowName);
        }
        if (json.executionId != null) {
            builder.executionId(json.executionId);
        }
        if (json.connectorProfileLabel != null) {
            builder.connectorProfileLabel(json.connectorProfileLabel);
        }
        if (json.entityDefinition != null) {
            builder.entityDefinition(json.entityDefinition);
        }
        return builder.build();
    }

    public static ImmutableConnectorContext copyOf(ConnectorContext instance) {
        if (instance instanceof ImmutableConnectorContext) {
            return (ImmutableConnectorContext)instance;
        }
        return ImmutableConnectorContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConnectorContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_API_VERSION = 1L;
        private long initBits = 1L;
        private ImmutableMap.Builder<String, String> connectorRuntimeSettings = null;
        @Nullable
        private Credentials credentials;
        @Nullable
        private String apiVersion;
        @Nullable
        private String flowName;
        @Nullable
        private String executionId;
        @Nullable
        private String connectorProfileLabel;
        @Nullable
        private EntityDefinition entityDefinition;

        private Builder() {
        }

        public final Builder from(ConnectorContext instance) {
            EntityDefinition entityDefinitionValue;
            String connectorProfileLabelValue;
            String executionIdValue;
            Credentials credentialsValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, String> connectorRuntimeSettingsValue = instance.connectorRuntimeSettings();
            if (connectorRuntimeSettingsValue != null) {
                this.putAllConnectorRuntimeSettings(connectorRuntimeSettingsValue);
            }
            if ((credentialsValue = instance.credentials()) != null) {
                this.credentials(credentialsValue);
            }
            this.apiVersion(instance.apiVersion());
            String flowNameValue = instance.flowName();
            if (flowNameValue != null) {
                this.flowName(flowNameValue);
            }
            if ((executionIdValue = instance.executionId()) != null) {
                this.executionId(executionIdValue);
            }
            if ((connectorProfileLabelValue = instance.connectorProfileLabel()) != null) {
                this.connectorProfileLabel(connectorProfileLabelValue);
            }
            if ((entityDefinitionValue = instance.entityDefinition()) != null) {
                this.entityDefinition(entityDefinitionValue);
            }
            return this;
        }

        public final Builder putConnectorRuntimeSettings(String key, String value) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = ImmutableMap.builder();
            }
            this.connectorRuntimeSettings.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putConnectorRuntimeSettings(Map.Entry<String, ? extends String> entry) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = ImmutableMap.builder();
            }
            this.connectorRuntimeSettings.put(entry);
            return this;
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public final Builder connectorRuntimeSettings(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.connectorRuntimeSettings = null;
                return this;
            }
            this.connectorRuntimeSettings = ImmutableMap.builder();
            return this.putAllConnectorRuntimeSettings(entries);
        }

        public final Builder putAllConnectorRuntimeSettings(Map<String, ? extends String> entries) {
            if (this.connectorRuntimeSettings == null) {
                this.connectorRuntimeSettings = ImmutableMap.builder();
            }
            this.connectorRuntimeSettings.putAll(entries);
            return this;
        }

        @JsonProperty(value="credentials")
        public final Builder credentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @JsonProperty(value="apiVersion")
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="flowName")
        public final Builder flowName(@Nullable String flowName) {
            this.flowName = flowName;
            return this;
        }

        @JsonProperty(value="executionId")
        public final Builder executionId(@Nullable String executionId) {
            this.executionId = executionId;
            return this;
        }

        @JsonProperty(value="connectorProfileLabel")
        public final Builder connectorProfileLabel(@Nullable String connectorProfileLabel) {
            this.connectorProfileLabel = connectorProfileLabel;
            return this;
        }

        @JsonProperty(value="entityDefinition")
        public final Builder entityDefinition(@Nullable EntityDefinition entityDefinition) {
            this.entityDefinition = entityDefinition;
            return this;
        }

        public ImmutableConnectorContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConnectorContext(this.connectorRuntimeSettings == null ? null : this.connectorRuntimeSettings.build(), this.credentials, this.apiVersion, this.flowName, this.executionId, this.connectorProfileLabel, this.entityDefinition);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiVersion");
            }
            return "Cannot build ConnectorContext, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConnectorContext", generator="Immutables")
    static final class Json
    implements ConnectorContext {
        @Nullable
        Map<String, String> connectorRuntimeSettings = null;
        @Nullable
        Credentials credentials;
        @Nullable
        String apiVersion;
        @Nullable
        String flowName;
        @Nullable
        String executionId;
        @Nullable
        String connectorProfileLabel;
        @Nullable
        EntityDefinition entityDefinition;

        Json() {
        }

        @JsonProperty(value="connectorRuntimeSettings")
        public void setConnectorRuntimeSettings(@Nullable Map<String, String> connectorRuntimeSettings) {
            this.connectorRuntimeSettings = connectorRuntimeSettings;
        }

        @JsonProperty(value="credentials")
        public void setCredentials(@Nullable Credentials credentials) {
            this.credentials = credentials;
        }

        @JsonProperty(value="apiVersion")
        public void setApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
        }

        @JsonProperty(value="flowName")
        public void setFlowName(@Nullable String flowName) {
            this.flowName = flowName;
        }

        @JsonProperty(value="executionId")
        public void setExecutionId(@Nullable String executionId) {
            this.executionId = executionId;
        }

        @JsonProperty(value="connectorProfileLabel")
        public void setConnectorProfileLabel(@Nullable String connectorProfileLabel) {
            this.connectorProfileLabel = connectorProfileLabel;
        }

        @JsonProperty(value="entityDefinition")
        public void setEntityDefinition(@Nullable EntityDefinition entityDefinition) {
            this.entityDefinition = entityDefinition;
        }

        @Override
        public Map<String, String> connectorRuntimeSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Credentials credentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String apiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String flowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String executionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String connectorProfileLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public EntityDefinition entityDefinition() {
            throw new UnsupportedOperationException();
        }
    }
}

