/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.lambda.handler;

import com.amazonaws.appflow.custom.connector.handlers.ConfigurationHandler;
import com.amazonaws.appflow.custom.connector.handlers.MetadataHandler;
import com.amazonaws.appflow.custom.connector.handlers.RecordHandler;
import com.amazonaws.appflow.custom.connector.model.ConnectorRequest;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationRequest;
import com.amazonaws.appflow.custom.connector.model.credentials.ValidateCredentialsRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityRequest;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesRequest;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataRequest;
import com.amazonaws.appflow.custom.connector.model.retreive.RetrieveDataRequest;
import com.amazonaws.appflow.custom.connector.model.settings.ValidateConnectorRuntimeSettingsRequest;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataRequest;
import com.amazonaws.appflow.custom.connector.util.CustomObjectMapper;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class BaseLambdaConnectorHandler
implements RequestStreamHandler {
    private final ObjectMapper objectMapper = CustomObjectMapper.getObjectMapper();
    private final RecordHandler recordHandler;
    private final MetadataHandler metadataHandler;
    private final ConfigurationHandler configurationHandler;

    public BaseLambdaConnectorHandler(@Nonnull MetadataHandler metadataHandler, @Nonnull RecordHandler recordHandler, @Nonnull ConfigurationHandler configurationHandler) {
        this.recordHandler = recordHandler;
        this.metadataHandler = metadataHandler;
        this.configurationHandler = configurationHandler;
    }

    public void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) {
        block22: {
            LambdaLogger lambdaLogger = context.getLogger();
            try (ConnectorRequest connectorRequest = (ConnectorRequest)this.objectMapper.readValue(inputStream, ConnectorRequest.class);){
                lambdaLogger.log("Handling request for requestType: " + connectorRequest.getClass().getName());
                if (connectorRequest instanceof ValidateConnectorRuntimeSettingsRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.configurationHandler.validateConnectorRuntimeSettings((ValidateConnectorRuntimeSettingsRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof ValidateCredentialsRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.configurationHandler.validateCredentials((ValidateCredentialsRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof DescribeConnectorConfigurationRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.configurationHandler.describeConnectorConfiguration((DescribeConnectorConfigurationRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof RetrieveDataRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.recordHandler.retrieveData((RetrieveDataRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof QueryDataRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.recordHandler.queryData((QueryDataRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof WriteDataRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.recordHandler.writeData((WriteDataRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof ListEntitiesRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.metadataHandler.listEntities((ListEntitiesRequest)connectorRequest));
                    break block22;
                }
                if (connectorRequest instanceof DescribeEntityRequest) {
                    this.objectMapper.writeValue(outputStream, (Object)this.metadataHandler.describeEntity((DescribeEntityRequest)connectorRequest));
                    break block22;
                }
                lambdaLogger.log(String.format("handleRequest: Request type %s is not supported", connectorRequest.getClass().getName()));
                throw new IllegalArgumentException("No operation is defined for requestType: " + connectorRequest.getClass().getName());
            }
            catch (Exception ex) {
                lambdaLogger.log("handleRequest: Completed with an exception: " + ExceptionUtils.getStackTrace((Throwable)ex));
                throw new RuntimeException("Exception while processing the request due to " + ExceptionUtils.getStackTrace((Throwable)ex));
            }
        }
    }
}

