package com.amazonaws.appflow.custom.connector.model.credentials;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CustomAuthCredentials}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCustomAuthCredentials.builder()}.
 */
@Generated(from = "CustomAuthCredentials", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableCustomAuthCredentials
    implements CustomAuthCredentials {
  private final String customAuthenticationType;
  private final ImmutableMap<String, String> customCredentials;

  private ImmutableCustomAuthCredentials(
      String customAuthenticationType,
      ImmutableMap<String, String> customCredentials) {
    this.customAuthenticationType = customAuthenticationType;
    this.customCredentials = customCredentials;
  }

  /**
   * Authentication Type defined by Connector.
   */
  @JsonProperty("customAuthenticationType")
  @Override
  public String customAuthenticationType() {
    return customAuthenticationType;
  }

  /**
   * Custom Credentials provided by connector user. Key will be <code>AuthParameter.key()</code> and value will be the
   * input provided by user.
   */
  @JsonProperty("customCredentials")
  @Override
  public ImmutableMap<String, String> customCredentials() {
    return customCredentials;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CustomAuthCredentials#customAuthenticationType() customAuthenticationType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for customAuthenticationType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCustomAuthCredentials withCustomAuthenticationType(String value) {
    String newValue = Objects.requireNonNull(value, "customAuthenticationType");
    if (this.customAuthenticationType.equals(newValue)) return this;
    return new ImmutableCustomAuthCredentials(newValue, this.customCredentials);
  }

  /**
   * Copy the current immutable object by replacing the {@link CustomAuthCredentials#customCredentials() customCredentials} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customCredentials map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCustomAuthCredentials withCustomCredentials(Map<String, ? extends String> entries) {
    if (this.customCredentials == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCustomAuthCredentials(this.customAuthenticationType, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCustomAuthCredentials} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCustomAuthCredentials
        && equalTo(0, (ImmutableCustomAuthCredentials) another);
  }

  private boolean equalTo(int synthetic, ImmutableCustomAuthCredentials another) {
    return customAuthenticationType.equals(another.customAuthenticationType)
        && customCredentials.equals(another.customCredentials);
  }

  /**
   * Computes a hash code from attributes: {@code customAuthenticationType}, {@code customCredentials}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + customAuthenticationType.hashCode();
    h += (h << 5) + customCredentials.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CustomAuthCredentials} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CustomAuthCredentials")
        .omitNullValues()
        .add("customAuthenticationType", customAuthenticationType)
        .add("customCredentials", customCredentials)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "CustomAuthCredentials", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements CustomAuthCredentials {
    @Nullable String customAuthenticationType;
    @Nullable Map<String, String> customCredentials = ImmutableMap.of();
    @JsonProperty("customAuthenticationType")
    public void setCustomAuthenticationType(String customAuthenticationType) {
      this.customAuthenticationType = customAuthenticationType;
    }
    @JsonProperty("customCredentials")
    public void setCustomCredentials(Map<String, String> customCredentials) {
      this.customCredentials = customCredentials;
    }
    @Override
    public String customAuthenticationType() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> customCredentials() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableCustomAuthCredentials fromJson(Json json) {
    ImmutableCustomAuthCredentials.Builder builder = ImmutableCustomAuthCredentials.builder();
    if (json.customAuthenticationType != null) {
      builder.customAuthenticationType(json.customAuthenticationType);
    }
    if (json.customCredentials != null) {
      builder.putAllCustomCredentials(json.customCredentials);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link CustomAuthCredentials} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CustomAuthCredentials instance
   */
  public static ImmutableCustomAuthCredentials copyOf(CustomAuthCredentials instance) {
    if (instance instanceof ImmutableCustomAuthCredentials) {
      return (ImmutableCustomAuthCredentials) instance;
    }
    return ImmutableCustomAuthCredentials.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCustomAuthCredentials ImmutableCustomAuthCredentials}.
   * <pre>
   * ImmutableCustomAuthCredentials.builder()
   *    .customAuthenticationType(String) // required {@link CustomAuthCredentials#customAuthenticationType() customAuthenticationType}
   *    .putCustomCredentials|putAllCustomCredentials(String =&gt; String) // {@link CustomAuthCredentials#customCredentials() customCredentials} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCustomAuthCredentials builder
   */
  public static ImmutableCustomAuthCredentials.Builder builder() {
    return new ImmutableCustomAuthCredentials.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCustomAuthCredentials ImmutableCustomAuthCredentials}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CustomAuthCredentials", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CUSTOM_AUTHENTICATION_TYPE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String customAuthenticationType;
    private ImmutableMap.Builder<String, String> customCredentials = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CustomAuthCredentials} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CustomAuthCredentials instance) {
      Objects.requireNonNull(instance, "instance");
      customAuthenticationType(instance.customAuthenticationType());
      putAllCustomCredentials(instance.customCredentials());
      return this;
    }

    /**
     * Initializes the value for the {@link CustomAuthCredentials#customAuthenticationType() customAuthenticationType} attribute.
     * @param customAuthenticationType The value for customAuthenticationType 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("customAuthenticationType")
    public final Builder customAuthenticationType(String customAuthenticationType) {
      this.customAuthenticationType = Objects.requireNonNull(customAuthenticationType, "customAuthenticationType");
      initBits &= ~INIT_BIT_CUSTOM_AUTHENTICATION_TYPE;
      return this;
    }

    /**
     * Put one entry to the {@link CustomAuthCredentials#customCredentials() customCredentials} map.
     * @param key The key in the customCredentials map
     * @param value The associated value in the customCredentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomCredentials(String key, String value) {
      this.customCredentials.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CustomAuthCredentials#customCredentials() customCredentials} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomCredentials(Map.Entry<String, ? extends String> entry) {
      this.customCredentials.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CustomAuthCredentials#customCredentials() customCredentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the customCredentials map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("customCredentials")
    public final Builder customCredentials(Map<String, ? extends String> entries) {
      this.customCredentials = ImmutableMap.builder();
      return putAllCustomCredentials(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CustomAuthCredentials#customCredentials() customCredentials} map. Nulls are not permitted
     * @param entries The entries that will be added to the customCredentials map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCustomCredentials(Map<String, ? extends String> entries) {
      this.customCredentials.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableCustomAuthCredentials ImmutableCustomAuthCredentials}.
     * @return An immutable instance of CustomAuthCredentials
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCustomAuthCredentials build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCustomAuthCredentials(customAuthenticationType, customCredentials.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CUSTOM_AUTHENTICATION_TYPE) != 0) attributes.add("customAuthenticationType");
      return "Cannot build CustomAuthCredentials, some of required attributes are not set " + attributes;
    }
  }
}
