/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.util;

import com.amazonaws.appflow.custom.connector.integ.util.PollingConfiguration;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PollingConfiguration", generator="Immutables")
@Immutable
public final class ImmutablePollingConfiguration
implements PollingConfiguration {
    private final int maxPollTimeS;
    private final int timeBetweenPollsS;
    private final String executionId;
    private final String flowName;

    private ImmutablePollingConfiguration(int maxPollTimeS, int timeBetweenPollsS, String executionId, String flowName) {
        this.maxPollTimeS = maxPollTimeS;
        this.timeBetweenPollsS = timeBetweenPollsS;
        this.executionId = executionId;
        this.flowName = flowName;
    }

    @Override
    public int maxPollTimeS() {
        return this.maxPollTimeS;
    }

    @Override
    public int timeBetweenPollsS() {
        return this.timeBetweenPollsS;
    }

    @Override
    public String executionId() {
        return this.executionId;
    }

    @Override
    public String flowName() {
        return this.flowName;
    }

    public final ImmutablePollingConfiguration withMaxPollTimeS(int value) {
        if (this.maxPollTimeS == value) {
            return this;
        }
        return new ImmutablePollingConfiguration(value, this.timeBetweenPollsS, this.executionId, this.flowName);
    }

    public final ImmutablePollingConfiguration withTimeBetweenPollsS(int value) {
        if (this.timeBetweenPollsS == value) {
            return this;
        }
        return new ImmutablePollingConfiguration(this.maxPollTimeS, value, this.executionId, this.flowName);
    }

    public final ImmutablePollingConfiguration withExecutionId(String value) {
        String newValue = Objects.requireNonNull(value, "executionId");
        if (this.executionId.equals(newValue)) {
            return this;
        }
        return new ImmutablePollingConfiguration(this.maxPollTimeS, this.timeBetweenPollsS, newValue, this.flowName);
    }

    public final ImmutablePollingConfiguration withFlowName(String value) {
        String newValue = Objects.requireNonNull(value, "flowName");
        if (this.flowName.equals(newValue)) {
            return this;
        }
        return new ImmutablePollingConfiguration(this.maxPollTimeS, this.timeBetweenPollsS, this.executionId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePollingConfiguration && this.equalTo(0, (ImmutablePollingConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutablePollingConfiguration another) {
        return this.maxPollTimeS == another.maxPollTimeS && this.timeBetweenPollsS == another.timeBetweenPollsS && this.executionId.equals(another.executionId) && this.flowName.equals(another.flowName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.maxPollTimeS;
        h += (h << 5) + this.timeBetweenPollsS;
        h += (h << 5) + this.executionId.hashCode();
        h += (h << 5) + this.flowName.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PollingConfiguration").omitNullValues().add("maxPollTimeS", this.maxPollTimeS).add("timeBetweenPollsS", this.timeBetweenPollsS).add("executionId", (Object)this.executionId).add("flowName", (Object)this.flowName).toString();
    }

    public static ImmutablePollingConfiguration copyOf(PollingConfiguration instance) {
        if (instance instanceof ImmutablePollingConfiguration) {
            return (ImmutablePollingConfiguration)instance;
        }
        return ImmutablePollingConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PollingConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAX_POLL_TIME_S = 1L;
        private static final long INIT_BIT_TIME_BETWEEN_POLLS_S = 2L;
        private static final long INIT_BIT_EXECUTION_ID = 4L;
        private static final long INIT_BIT_FLOW_NAME = 8L;
        private long initBits = 15L;
        private int maxPollTimeS;
        private int timeBetweenPollsS;
        @Nullable
        private String executionId;
        @Nullable
        private String flowName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PollingConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.maxPollTimeS(instance.maxPollTimeS());
            this.timeBetweenPollsS(instance.timeBetweenPollsS());
            this.executionId(instance.executionId());
            this.flowName(instance.flowName());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxPollTimeS(int maxPollTimeS) {
            this.maxPollTimeS = maxPollTimeS;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder timeBetweenPollsS(int timeBetweenPollsS) {
            this.timeBetweenPollsS = timeBetweenPollsS;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder executionId(String executionId) {
            this.executionId = Objects.requireNonNull(executionId, "executionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flowName(String flowName) {
            this.flowName = Objects.requireNonNull(flowName, "flowName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutablePollingConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePollingConfiguration(this.maxPollTimeS, this.timeBetweenPollsS, this.executionId, this.flowName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxPollTimeS");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("timeBetweenPollsS");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("executionId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("flowName");
            }
            return "Cannot build PollingConfiguration, some of required attributes are not set " + attributes;
        }
    }
}

