/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.util;

import com.amazonaws.appflow.custom.connector.integ.data.TestConfiguration;
import com.amazonaws.services.appflow.model.DescribeConnectorEntityResult;
import com.amazonaws.services.appflow.model.DescribeConnectorResult;
import com.amazonaws.services.appflow.model.ListConnectorEntitiesResult;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.File;
import java.io.IOException;
import org.testng.ITestContext;

public final class ConfigurationUtil {
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().registerModule((Module)new GuavaModule()).enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES}).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS}).registerModule((Module)new Jdk8Module());
    private static TestConfiguration testConfiguration;

    private ConfigurationUtil() {
    }

    public static TestConfiguration getTestConfiguration(ITestContext iTestContext) {
        if (testConfiguration != null) {
            return testConfiguration;
        }
        try {
            testConfiguration = (TestConfiguration)OBJECT_MAPPER.readValue(new File(iTestContext.getSuite().getParameter("testConfig")), TestConfiguration.class);
            return testConfiguration;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static DescribeConnectorResult getDescribeConnectorFile(String file) {
        try {
            return (DescribeConnectorResult)OBJECT_MAPPER.readValue(new File(file), DescribeConnectorResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static ListConnectorEntitiesResult getListEntitiesFile(String file) {
        try {
            return (ListConnectorEntitiesResult)OBJECT_MAPPER.readValue(new File(file), ListConnectorEntitiesResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static DescribeConnectorEntityResult getDescribeEntityFile(String file) {
        try {
            return (DescribeConnectorEntityResult)OBJECT_MAPPER.readValue(new File(file), DescribeConnectorEntityResult.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

