/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.data;

import com.amazonaws.appflow.custom.connector.integ.data.OnDemandToS3TestConfiguration;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="OnDemandToS3TestConfiguration", generator="Immutables")
@Immutable
public final class ImmutableOnDemandToS3TestConfiguration
implements OnDemandToS3TestConfiguration {
    @Nullable
    private final String testName;
    @Nullable
    private final String apiVersion;
    @Nullable
    private final String profileName;
    private final String flowName;
    private final String entityName;
    @Nullable
    private final String query;
    @Nullable
    private final Integer flowTimeout;
    private final ImmutableList<String> entityFields;
    @Nullable
    private final Long outputSize;
    @Nullable
    private final Map<String, String> sourceRuntimeProperties;

    private ImmutableOnDemandToS3TestConfiguration(@Nullable String testName, @Nullable String apiVersion, @Nullable String profileName, String flowName, String entityName, @Nullable String query, @Nullable Integer flowTimeout, ImmutableList<String> entityFields, @Nullable Long outputSize, @Nullable Map<String, String> sourceRuntimeProperties) {
        this.testName = testName;
        this.apiVersion = apiVersion;
        this.profileName = profileName;
        this.flowName = flowName;
        this.entityName = entityName;
        this.query = query;
        this.flowTimeout = flowTimeout;
        this.entityFields = entityFields;
        this.outputSize = outputSize;
        this.sourceRuntimeProperties = sourceRuntimeProperties;
    }

    @Override
    @JsonProperty(value="testName")
    public Optional<String> testName() {
        return Optional.ofNullable(this.testName);
    }

    @Override
    @JsonProperty(value="apiVersion")
    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    @Override
    @JsonProperty(value="profileName")
    public Optional<String> profileName() {
        return Optional.ofNullable(this.profileName);
    }

    @Override
    @JsonProperty(value="flowName")
    public String flowName() {
        return this.flowName;
    }

    @Override
    @JsonProperty(value="entityName")
    public String entityName() {
        return this.entityName;
    }

    @Override
    @JsonProperty(value="query")
    public Optional<String> query() {
        return Optional.ofNullable(this.query);
    }

    @Override
    @JsonProperty(value="flowTimeout")
    public Optional<Integer> flowTimeout() {
        return Optional.ofNullable(this.flowTimeout);
    }

    @JsonProperty(value="entityFields")
    public ImmutableList<String> entityFields() {
        return this.entityFields;
    }

    @Override
    @JsonProperty(value="outputSize")
    public Optional<Long> outputSize() {
        return Optional.ofNullable(this.outputSize);
    }

    @Override
    @JsonProperty(value="sourceRuntimeProperties")
    public Optional<Map<String, String>> sourceRuntimeProperties() {
        return Optional.ofNullable(this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withTestName(String value) {
        String newValue = Objects.requireNonNull(value, "testName");
        if (Objects.equals(this.testName, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(newValue, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withTestName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.testName, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(value, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (Objects.equals(this.apiVersion, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, newValue, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withApiVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.apiVersion, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, value, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withProfileName(String value) {
        String newValue = Objects.requireNonNull(value, "profileName");
        if (Objects.equals(this.profileName, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, newValue, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withProfileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.profileName, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, value, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withFlowName(String value) {
        String newValue = Objects.requireNonNull(value, "flowName");
        if (this.flowName.equals(newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, newValue, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withEntityName(String value) {
        String newValue = Objects.requireNonNull(value, "entityName");
        if (this.entityName.equals(newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, newValue, this.query, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withQuery(String value) {
        String newValue = Objects.requireNonNull(value, "query");
        if (Objects.equals(this.query, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, newValue, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withQuery(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.query, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, value, this.flowTimeout, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withFlowTimeout(int value) {
        Integer newValue = value;
        if (Objects.equals(this.flowTimeout, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, newValue, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withFlowTimeout(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.flowTimeout, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, value, this.entityFields, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withEntityFields(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, (ImmutableList<String>)newValue, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withEntityFields(Iterable<String> elements) {
        if (this.entityFields == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, (ImmutableList<String>)newValue, this.outputSize, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withOutputSize(long value) {
        Long newValue = value;
        if (Objects.equals(this.outputSize, newValue)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, newValue, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withOutputSize(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.outputSize, value)) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, value, this.sourceRuntimeProperties);
    }

    public final ImmutableOnDemandToS3TestConfiguration withSourceRuntimeProperties(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "sourceRuntimeProperties");
        if (this.sourceRuntimeProperties == newValue) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, newValue);
    }

    public final ImmutableOnDemandToS3TestConfiguration withSourceRuntimeProperties(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.sourceRuntimeProperties == value) {
            return this;
        }
        return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields, this.outputSize, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOnDemandToS3TestConfiguration && this.equalTo(0, (ImmutableOnDemandToS3TestConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableOnDemandToS3TestConfiguration another) {
        return Objects.equals(this.testName, another.testName) && Objects.equals(this.apiVersion, another.apiVersion) && Objects.equals(this.profileName, another.profileName) && this.flowName.equals(another.flowName) && this.entityName.equals(another.entityName) && Objects.equals(this.query, another.query) && Objects.equals(this.flowTimeout, another.flowTimeout) && this.entityFields.equals(another.entityFields) && Objects.equals(this.outputSize, another.outputSize) && Objects.equals(this.sourceRuntimeProperties, another.sourceRuntimeProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.testName);
        h += (h << 5) + Objects.hashCode(this.apiVersion);
        h += (h << 5) + Objects.hashCode(this.profileName);
        h += (h << 5) + this.flowName.hashCode();
        h += (h << 5) + this.entityName.hashCode();
        h += (h << 5) + Objects.hashCode(this.query);
        h += (h << 5) + Objects.hashCode(this.flowTimeout);
        h += (h << 5) + this.entityFields.hashCode();
        h += (h << 5) + Objects.hashCode(this.outputSize);
        h += (h << 5) + Objects.hashCode(this.sourceRuntimeProperties);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"OnDemandToS3TestConfiguration").omitNullValues().add("testName", (Object)this.testName).add("apiVersion", (Object)this.apiVersion).add("profileName", (Object)this.profileName).add("flowName", (Object)this.flowName).add("entityName", (Object)this.entityName).add("query", (Object)this.query).add("flowTimeout", (Object)this.flowTimeout).add("entityFields", this.entityFields).add("outputSize", (Object)this.outputSize).add("sourceRuntimeProperties", this.sourceRuntimeProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOnDemandToS3TestConfiguration fromJson(Json json) {
        Builder builder = ImmutableOnDemandToS3TestConfiguration.builder();
        if (json.testName != null) {
            builder.testName(json.testName);
        }
        if (json.apiVersion != null) {
            builder.apiVersion(json.apiVersion);
        }
        if (json.profileName != null) {
            builder.profileName(json.profileName);
        }
        if (json.flowName != null) {
            builder.flowName(json.flowName);
        }
        if (json.entityName != null) {
            builder.entityName(json.entityName);
        }
        if (json.query != null) {
            builder.query(json.query);
        }
        if (json.flowTimeout != null) {
            builder.flowTimeout(json.flowTimeout);
        }
        if (json.entityFields != null) {
            builder.addAllEntityFields(json.entityFields);
        }
        if (json.outputSize != null) {
            builder.outputSize(json.outputSize);
        }
        if (json.sourceRuntimeProperties != null) {
            builder.sourceRuntimeProperties(json.sourceRuntimeProperties);
        }
        return builder.build();
    }

    public static ImmutableOnDemandToS3TestConfiguration copyOf(OnDemandToS3TestConfiguration instance) {
        if (instance instanceof ImmutableOnDemandToS3TestConfiguration) {
            return (ImmutableOnDemandToS3TestConfiguration)instance;
        }
        return ImmutableOnDemandToS3TestConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OnDemandToS3TestConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FLOW_NAME = 1L;
        private static final long INIT_BIT_ENTITY_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String testName;
        @Nullable
        private String apiVersion;
        @Nullable
        private String profileName;
        @Nullable
        private String flowName;
        @Nullable
        private String entityName;
        @Nullable
        private String query;
        @Nullable
        private Integer flowTimeout;
        private ImmutableList.Builder<String> entityFields = ImmutableList.builder();
        @Nullable
        private Long outputSize;
        @Nullable
        private Map<String, String> sourceRuntimeProperties;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(OnDemandToS3TestConfiguration instance) {
            Optional<Map<String, String>> sourceRuntimePropertiesOptional;
            Optional<Integer> flowTimeoutOptional;
            Optional<String> profileNameOptional;
            Optional<String> apiVersionOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> testNameOptional = instance.testName();
            if (testNameOptional.isPresent()) {
                this.testName(testNameOptional);
            }
            if ((apiVersionOptional = instance.apiVersion()).isPresent()) {
                this.apiVersion(apiVersionOptional);
            }
            if ((profileNameOptional = instance.profileName()).isPresent()) {
                this.profileName(profileNameOptional);
            }
            this.flowName(instance.flowName());
            this.entityName(instance.entityName());
            Optional<String> queryOptional = instance.query();
            if (queryOptional.isPresent()) {
                this.query(queryOptional);
            }
            if ((flowTimeoutOptional = instance.flowTimeout()).isPresent()) {
                this.flowTimeout(flowTimeoutOptional);
            }
            this.addAllEntityFields(instance.entityFields());
            Optional<Long> outputSizeOptional = instance.outputSize();
            if (outputSizeOptional.isPresent()) {
                this.outputSize(outputSizeOptional);
            }
            if ((sourceRuntimePropertiesOptional = instance.sourceRuntimeProperties()).isPresent()) {
                this.sourceRuntimeProperties(sourceRuntimePropertiesOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder testName(String testName) {
            this.testName = Objects.requireNonNull(testName, "testName");
            return this;
        }

        @JsonProperty(value="testName")
        @CanIgnoreReturnValue
        public final Builder testName(Optional<String> testName) {
            this.testName = testName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            return this;
        }

        @JsonProperty(value="apiVersion")
        @CanIgnoreReturnValue
        public final Builder apiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder profileName(String profileName) {
            this.profileName = Objects.requireNonNull(profileName, "profileName");
            return this;
        }

        @JsonProperty(value="profileName")
        @CanIgnoreReturnValue
        public final Builder profileName(Optional<String> profileName) {
            this.profileName = profileName.orElse(null);
            return this;
        }

        @JsonProperty(value="flowName")
        @CanIgnoreReturnValue
        public final Builder flowName(String flowName) {
            this.flowName = Objects.requireNonNull(flowName, "flowName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="entityName")
        @CanIgnoreReturnValue
        public final Builder entityName(String entityName) {
            this.entityName = Objects.requireNonNull(entityName, "entityName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder query(String query) {
            this.query = Objects.requireNonNull(query, "query");
            return this;
        }

        @JsonProperty(value="query")
        @CanIgnoreReturnValue
        public final Builder query(Optional<String> query) {
            this.query = query.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder flowTimeout(int flowTimeout) {
            this.flowTimeout = flowTimeout;
            return this;
        }

        @JsonProperty(value="flowTimeout")
        @CanIgnoreReturnValue
        public final Builder flowTimeout(Optional<Integer> flowTimeout) {
            this.flowTimeout = flowTimeout.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntityFields(String element) {
            this.entityFields.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addEntityFields(String ... elements) {
            this.entityFields.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="entityFields")
        @CanIgnoreReturnValue
        public final Builder entityFields(Iterable<String> elements) {
            this.entityFields = ImmutableList.builder();
            return this.addAllEntityFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllEntityFields(Iterable<String> elements) {
            this.entityFields.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder outputSize(long outputSize) {
            this.outputSize = outputSize;
            return this;
        }

        @JsonProperty(value="outputSize")
        @CanIgnoreReturnValue
        public final Builder outputSize(Optional<Long> outputSize) {
            this.outputSize = outputSize.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sourceRuntimeProperties(Map<String, String> sourceRuntimeProperties) {
            this.sourceRuntimeProperties = Objects.requireNonNull(sourceRuntimeProperties, "sourceRuntimeProperties");
            return this;
        }

        @JsonProperty(value="sourceRuntimeProperties")
        @CanIgnoreReturnValue
        public final Builder sourceRuntimeProperties(Optional<? extends Map<String, String>> sourceRuntimeProperties) {
            this.sourceRuntimeProperties = sourceRuntimeProperties.orElse(null);
            return this;
        }

        public ImmutableOnDemandToS3TestConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOnDemandToS3TestConfiguration(this.testName, this.apiVersion, this.profileName, this.flowName, this.entityName, this.query, this.flowTimeout, this.entityFields.build(), this.outputSize, this.sourceRuntimeProperties);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("flowName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("entityName");
            }
            return "Cannot build OnDemandToS3TestConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OnDemandToS3TestConfiguration", generator="Immutables")
    static final class Json
    implements OnDemandToS3TestConfiguration {
        @Nullable
        Optional<String> testName = Optional.empty();
        @Nullable
        Optional<String> apiVersion = Optional.empty();
        @Nullable
        Optional<String> profileName = Optional.empty();
        @Nullable
        String flowName;
        @Nullable
        String entityName;
        @Nullable
        Optional<String> query = Optional.empty();
        @Nullable
        Optional<Integer> flowTimeout = Optional.empty();
        @Nullable
        List<String> entityFields = ImmutableList.of();
        @Nullable
        Optional<Long> outputSize = Optional.empty();
        @Nullable
        Optional<Map<String, String>> sourceRuntimeProperties = Optional.empty();

        Json() {
        }

        @JsonProperty(value="testName")
        public void setTestName(Optional<String> testName) {
            this.testName = testName;
        }

        @JsonProperty(value="apiVersion")
        public void setApiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion;
        }

        @JsonProperty(value="profileName")
        public void setProfileName(Optional<String> profileName) {
            this.profileName = profileName;
        }

        @JsonProperty(value="flowName")
        public void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @JsonProperty(value="entityName")
        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @JsonProperty(value="query")
        public void setQuery(Optional<String> query) {
            this.query = query;
        }

        @JsonProperty(value="flowTimeout")
        public void setFlowTimeout(Optional<Integer> flowTimeout) {
            this.flowTimeout = flowTimeout;
        }

        @JsonProperty(value="entityFields")
        public void setEntityFields(List<String> entityFields) {
            this.entityFields = entityFields;
        }

        @JsonProperty(value="outputSize")
        public void setOutputSize(Optional<Long> outputSize) {
            this.outputSize = outputSize;
        }

        @JsonProperty(value="sourceRuntimeProperties")
        public void setSourceRuntimeProperties(Optional<Map<String, String>> sourceRuntimeProperties) {
            this.sourceRuntimeProperties = sourceRuntimeProperties;
        }

        @Override
        public Optional<String> testName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> apiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> profileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String flowName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String entityName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> query() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> flowTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> entityFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Long> outputSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> sourceRuntimeProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

