/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.data;

import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorConfiguration;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomConnectorConfiguration", generator="Immutables")
@Immutable
public final class ImmutableCustomConnectorConfiguration
implements CustomConnectorConfiguration {
    private final String lambdaArn;
    private final String name;
    @Nullable
    private final String validationFileName;

    private ImmutableCustomConnectorConfiguration(String lambdaArn, String name, @Nullable String validationFileName) {
        this.lambdaArn = lambdaArn;
        this.name = name;
        this.validationFileName = validationFileName;
    }

    @Override
    @JsonProperty(value="lambdaArn")
    public String lambdaArn() {
        return this.lambdaArn;
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="validationFileName")
    public Optional<String> validationFileName() {
        return Optional.ofNullable(this.validationFileName);
    }

    public final ImmutableCustomConnectorConfiguration withLambdaArn(String value) {
        String newValue = Objects.requireNonNull(value, "lambdaArn");
        if (this.lambdaArn.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorConfiguration(newValue, this.name, this.validationFileName);
    }

    public final ImmutableCustomConnectorConfiguration withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorConfiguration(this.lambdaArn, newValue, this.validationFileName);
    }

    public final ImmutableCustomConnectorConfiguration withValidationFileName(String value) {
        String newValue = Objects.requireNonNull(value, "validationFileName");
        if (Objects.equals(this.validationFileName, newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorConfiguration(this.lambdaArn, this.name, newValue);
    }

    public final ImmutableCustomConnectorConfiguration withValidationFileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.validationFileName, value)) {
            return this;
        }
        return new ImmutableCustomConnectorConfiguration(this.lambdaArn, this.name, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomConnectorConfiguration && this.equalTo(0, (ImmutableCustomConnectorConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomConnectorConfiguration another) {
        return this.lambdaArn.equals(another.lambdaArn) && this.name.equals(another.name) && Objects.equals(this.validationFileName, another.validationFileName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.lambdaArn.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.validationFileName);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomConnectorConfiguration").omitNullValues().add("lambdaArn", (Object)this.lambdaArn).add("name", (Object)this.name).add("validationFileName", (Object)this.validationFileName).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCustomConnectorConfiguration fromJson(Json json) {
        Builder builder = ImmutableCustomConnectorConfiguration.builder();
        if (json.lambdaArn != null) {
            builder.lambdaArn(json.lambdaArn);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.validationFileName != null) {
            builder.validationFileName(json.validationFileName);
        }
        return builder.build();
    }

    public static ImmutableCustomConnectorConfiguration copyOf(CustomConnectorConfiguration instance) {
        if (instance instanceof ImmutableCustomConnectorConfiguration) {
            return (ImmutableCustomConnectorConfiguration)instance;
        }
        return ImmutableCustomConnectorConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomConnectorConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LAMBDA_ARN = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String lambdaArn;
        @Nullable
        private String name;
        @Nullable
        private String validationFileName;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CustomConnectorConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.lambdaArn(instance.lambdaArn());
            this.name(instance.name());
            Optional<String> validationFileNameOptional = instance.validationFileName();
            if (validationFileNameOptional.isPresent()) {
                this.validationFileName(validationFileNameOptional);
            }
            return this;
        }

        @JsonProperty(value="lambdaArn")
        @CanIgnoreReturnValue
        public final Builder lambdaArn(String lambdaArn) {
            this.lambdaArn = Objects.requireNonNull(lambdaArn, "lambdaArn");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationFileName(String validationFileName) {
            this.validationFileName = Objects.requireNonNull(validationFileName, "validationFileName");
            return this;
        }

        @JsonProperty(value="validationFileName")
        @CanIgnoreReturnValue
        public final Builder validationFileName(Optional<String> validationFileName) {
            this.validationFileName = validationFileName.orElse(null);
            return this;
        }

        public ImmutableCustomConnectorConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomConnectorConfiguration(this.lambdaArn, this.name, this.validationFileName);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("lambdaArn");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build CustomConnectorConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CustomConnectorConfiguration", generator="Immutables")
    static final class Json
    implements CustomConnectorConfiguration {
        @Nullable
        String lambdaArn;
        @Nullable
        String name;
        @Nullable
        Optional<String> validationFileName = Optional.empty();

        Json() {
        }

        @JsonProperty(value="lambdaArn")
        public void setLambdaArn(String lambdaArn) {
            this.lambdaArn = lambdaArn;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="validationFileName")
        public void setValidationFileName(Optional<String> validationFileName) {
            this.validationFileName = validationFileName;
        }

        @Override
        public String lambdaArn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> validationFileName() {
            throw new UnsupportedOperationException();
        }
    }
}

