/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.AllowedOperation;
import com.amazonaws.services.licensemanager.model.GrantStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateGrantVersionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientToken;
    private String grantArn;
    private String grantName;
    private List<String> allowedOperations;
    private String status;
    private String statusReason;
    private String sourceVersion;

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateGrantVersionRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setGrantArn(String grantArn) {
        this.grantArn = grantArn;
    }

    public String getGrantArn() {
        return this.grantArn;
    }

    public CreateGrantVersionRequest withGrantArn(String grantArn) {
        this.setGrantArn(grantArn);
        return this;
    }

    public void setGrantName(String grantName) {
        this.grantName = grantName;
    }

    public String getGrantName() {
        return this.grantName;
    }

    public CreateGrantVersionRequest withGrantName(String grantName) {
        this.setGrantName(grantName);
        return this;
    }

    public List<String> getAllowedOperations() {
        return this.allowedOperations;
    }

    public void setAllowedOperations(Collection<String> allowedOperations) {
        if (allowedOperations == null) {
            this.allowedOperations = null;
            return;
        }
        this.allowedOperations = new ArrayList<String>(allowedOperations);
    }

    public CreateGrantVersionRequest withAllowedOperations(String ... allowedOperations) {
        if (this.allowedOperations == null) {
            this.setAllowedOperations(new ArrayList<String>(allowedOperations.length));
        }
        for (String ele : allowedOperations) {
            this.allowedOperations.add(ele);
        }
        return this;
    }

    public CreateGrantVersionRequest withAllowedOperations(Collection<String> allowedOperations) {
        this.setAllowedOperations(allowedOperations);
        return this;
    }

    public CreateGrantVersionRequest withAllowedOperations(AllowedOperation ... allowedOperations) {
        ArrayList<String> allowedOperationsCopy = new ArrayList<String>(allowedOperations.length);
        for (AllowedOperation value : allowedOperations) {
            allowedOperationsCopy.add(value.toString());
        }
        if (this.getAllowedOperations() == null) {
            this.setAllowedOperations(allowedOperationsCopy);
        } else {
            this.getAllowedOperations().addAll(allowedOperationsCopy);
        }
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public CreateGrantVersionRequest withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public CreateGrantVersionRequest withStatus(GrantStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setStatusReason(String statusReason) {
        this.statusReason = statusReason;
    }

    public String getStatusReason() {
        return this.statusReason;
    }

    public CreateGrantVersionRequest withStatusReason(String statusReason) {
        this.setStatusReason(statusReason);
        return this;
    }

    public void setSourceVersion(String sourceVersion) {
        this.sourceVersion = sourceVersion;
    }

    public String getSourceVersion() {
        return this.sourceVersion;
    }

    public CreateGrantVersionRequest withSourceVersion(String sourceVersion) {
        this.setSourceVersion(sourceVersion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getGrantArn() != null) {
            sb.append("GrantArn: ").append(this.getGrantArn()).append(",");
        }
        if (this.getGrantName() != null) {
            sb.append("GrantName: ").append(this.getGrantName()).append(",");
        }
        if (this.getAllowedOperations() != null) {
            sb.append("AllowedOperations: ").append(this.getAllowedOperations()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getStatusReason() != null) {
            sb.append("StatusReason: ").append(this.getStatusReason()).append(",");
        }
        if (this.getSourceVersion() != null) {
            sb.append("SourceVersion: ").append(this.getSourceVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGrantVersionRequest)) {
            return false;
        }
        CreateGrantVersionRequest other = (CreateGrantVersionRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getGrantArn() == null ^ this.getGrantArn() == null) {
            return false;
        }
        if (other.getGrantArn() != null && !other.getGrantArn().equals(this.getGrantArn())) {
            return false;
        }
        if (other.getGrantName() == null ^ this.getGrantName() == null) {
            return false;
        }
        if (other.getGrantName() != null && !other.getGrantName().equals(this.getGrantName())) {
            return false;
        }
        if (other.getAllowedOperations() == null ^ this.getAllowedOperations() == null) {
            return false;
        }
        if (other.getAllowedOperations() != null && !other.getAllowedOperations().equals(this.getAllowedOperations())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getStatusReason() == null ^ this.getStatusReason() == null) {
            return false;
        }
        if (other.getStatusReason() != null && !other.getStatusReason().equals(this.getStatusReason())) {
            return false;
        }
        if (other.getSourceVersion() == null ^ this.getSourceVersion() == null) {
            return false;
        }
        return other.getSourceVersion() == null || other.getSourceVersion().equals(this.getSourceVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getGrantArn() == null ? 0 : this.getGrantArn().hashCode());
        hashCode = 31 * hashCode + (this.getGrantName() == null ? 0 : this.getGrantName().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedOperations() == null ? 0 : this.getAllowedOperations().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getStatusReason() == null ? 0 : this.getStatusReason().hashCode());
        hashCode = 31 * hashCode + (this.getSourceVersion() == null ? 0 : this.getSourceVersion().hashCode());
        return hashCode;
    }

    @Override
    public CreateGrantVersionRequest clone() {
        return (CreateGrantVersionRequest)super.clone();
    }
}

