/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.licensemanager.model.DigitalSignatureMethod;
import com.amazonaws.services.licensemanager.model.EntitlementData;
import com.amazonaws.services.licensemanager.model.Metadata;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CheckoutBorrowLicenseRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String licenseArn;
    private List<EntitlementData> entitlements;
    private String digitalSignatureMethod;
    private String nodeId;
    private List<Metadata> checkoutMetadata;
    private String clientToken;

    public void setLicenseArn(String licenseArn) {
        this.licenseArn = licenseArn;
    }

    public String getLicenseArn() {
        return this.licenseArn;
    }

    public CheckoutBorrowLicenseRequest withLicenseArn(String licenseArn) {
        this.setLicenseArn(licenseArn);
        return this;
    }

    public List<EntitlementData> getEntitlements() {
        return this.entitlements;
    }

    public void setEntitlements(Collection<EntitlementData> entitlements) {
        if (entitlements == null) {
            this.entitlements = null;
            return;
        }
        this.entitlements = new ArrayList<EntitlementData>(entitlements);
    }

    public CheckoutBorrowLicenseRequest withEntitlements(EntitlementData ... entitlements) {
        if (this.entitlements == null) {
            this.setEntitlements(new ArrayList<EntitlementData>(entitlements.length));
        }
        for (EntitlementData ele : entitlements) {
            this.entitlements.add(ele);
        }
        return this;
    }

    public CheckoutBorrowLicenseRequest withEntitlements(Collection<EntitlementData> entitlements) {
        this.setEntitlements(entitlements);
        return this;
    }

    public void setDigitalSignatureMethod(String digitalSignatureMethod) {
        this.digitalSignatureMethod = digitalSignatureMethod;
    }

    public String getDigitalSignatureMethod() {
        return this.digitalSignatureMethod;
    }

    public CheckoutBorrowLicenseRequest withDigitalSignatureMethod(String digitalSignatureMethod) {
        this.setDigitalSignatureMethod(digitalSignatureMethod);
        return this;
    }

    public CheckoutBorrowLicenseRequest withDigitalSignatureMethod(DigitalSignatureMethod digitalSignatureMethod) {
        this.digitalSignatureMethod = digitalSignatureMethod.toString();
        return this;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public CheckoutBorrowLicenseRequest withNodeId(String nodeId) {
        this.setNodeId(nodeId);
        return this;
    }

    public List<Metadata> getCheckoutMetadata() {
        return this.checkoutMetadata;
    }

    public void setCheckoutMetadata(Collection<Metadata> checkoutMetadata) {
        if (checkoutMetadata == null) {
            this.checkoutMetadata = null;
            return;
        }
        this.checkoutMetadata = new ArrayList<Metadata>(checkoutMetadata);
    }

    public CheckoutBorrowLicenseRequest withCheckoutMetadata(Metadata ... checkoutMetadata) {
        if (this.checkoutMetadata == null) {
            this.setCheckoutMetadata(new ArrayList<Metadata>(checkoutMetadata.length));
        }
        for (Metadata ele : checkoutMetadata) {
            this.checkoutMetadata.add(ele);
        }
        return this;
    }

    public CheckoutBorrowLicenseRequest withCheckoutMetadata(Collection<Metadata> checkoutMetadata) {
        this.setCheckoutMetadata(checkoutMetadata);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CheckoutBorrowLicenseRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLicenseArn() != null) {
            sb.append("LicenseArn: ").append(this.getLicenseArn()).append(",");
        }
        if (this.getEntitlements() != null) {
            sb.append("Entitlements: ").append(this.getEntitlements()).append(",");
        }
        if (this.getDigitalSignatureMethod() != null) {
            sb.append("DigitalSignatureMethod: ").append(this.getDigitalSignatureMethod()).append(",");
        }
        if (this.getNodeId() != null) {
            sb.append("NodeId: ").append(this.getNodeId()).append(",");
        }
        if (this.getCheckoutMetadata() != null) {
            sb.append("CheckoutMetadata: ").append(this.getCheckoutMetadata()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckoutBorrowLicenseRequest)) {
            return false;
        }
        CheckoutBorrowLicenseRequest other = (CheckoutBorrowLicenseRequest)obj;
        if (other.getLicenseArn() == null ^ this.getLicenseArn() == null) {
            return false;
        }
        if (other.getLicenseArn() != null && !other.getLicenseArn().equals(this.getLicenseArn())) {
            return false;
        }
        if (other.getEntitlements() == null ^ this.getEntitlements() == null) {
            return false;
        }
        if (other.getEntitlements() != null && !other.getEntitlements().equals(this.getEntitlements())) {
            return false;
        }
        if (other.getDigitalSignatureMethod() == null ^ this.getDigitalSignatureMethod() == null) {
            return false;
        }
        if (other.getDigitalSignatureMethod() != null && !other.getDigitalSignatureMethod().equals(this.getDigitalSignatureMethod())) {
            return false;
        }
        if (other.getNodeId() == null ^ this.getNodeId() == null) {
            return false;
        }
        if (other.getNodeId() != null && !other.getNodeId().equals(this.getNodeId())) {
            return false;
        }
        if (other.getCheckoutMetadata() == null ^ this.getCheckoutMetadata() == null) {
            return false;
        }
        if (other.getCheckoutMetadata() != null && !other.getCheckoutMetadata().equals(this.getCheckoutMetadata())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLicenseArn() == null ? 0 : this.getLicenseArn().hashCode());
        hashCode = 31 * hashCode + (this.getEntitlements() == null ? 0 : this.getEntitlements().hashCode());
        hashCode = 31 * hashCode + (this.getDigitalSignatureMethod() == null ? 0 : this.getDigitalSignatureMethod().hashCode());
        hashCode = 31 * hashCode + (this.getNodeId() == null ? 0 : this.getNodeId().hashCode());
        hashCode = 31 * hashCode + (this.getCheckoutMetadata() == null ? 0 : this.getCheckoutMetadata().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    @Override
    public CheckoutBorrowLicenseRequest clone() {
        return (CheckoutBorrowLicenseRequest)super.clone();
    }
}

