/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appflow.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.appflow.model.OAuth2GrantType;
import com.amazonaws.services.appflow.model.transform.OAuth2DefaultsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OAuth2Defaults
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> oauthScopes;
    private List<String> tokenUrls;
    private List<String> authCodeUrls;
    private List<String> oauth2GrantTypesSupported;

    public List<String> getOauthScopes() {
        return this.oauthScopes;
    }

    public void setOauthScopes(Collection<String> oauthScopes) {
        if (oauthScopes == null) {
            this.oauthScopes = null;
            return;
        }
        this.oauthScopes = new ArrayList<String>(oauthScopes);
    }

    public OAuth2Defaults withOauthScopes(String ... oauthScopes) {
        if (this.oauthScopes == null) {
            this.setOauthScopes(new ArrayList<String>(oauthScopes.length));
        }
        for (String ele : oauthScopes) {
            this.oauthScopes.add(ele);
        }
        return this;
    }

    public OAuth2Defaults withOauthScopes(Collection<String> oauthScopes) {
        this.setOauthScopes(oauthScopes);
        return this;
    }

    public List<String> getTokenUrls() {
        return this.tokenUrls;
    }

    public void setTokenUrls(Collection<String> tokenUrls) {
        if (tokenUrls == null) {
            this.tokenUrls = null;
            return;
        }
        this.tokenUrls = new ArrayList<String>(tokenUrls);
    }

    public OAuth2Defaults withTokenUrls(String ... tokenUrls) {
        if (this.tokenUrls == null) {
            this.setTokenUrls(new ArrayList<String>(tokenUrls.length));
        }
        for (String ele : tokenUrls) {
            this.tokenUrls.add(ele);
        }
        return this;
    }

    public OAuth2Defaults withTokenUrls(Collection<String> tokenUrls) {
        this.setTokenUrls(tokenUrls);
        return this;
    }

    public List<String> getAuthCodeUrls() {
        return this.authCodeUrls;
    }

    public void setAuthCodeUrls(Collection<String> authCodeUrls) {
        if (authCodeUrls == null) {
            this.authCodeUrls = null;
            return;
        }
        this.authCodeUrls = new ArrayList<String>(authCodeUrls);
    }

    public OAuth2Defaults withAuthCodeUrls(String ... authCodeUrls) {
        if (this.authCodeUrls == null) {
            this.setAuthCodeUrls(new ArrayList<String>(authCodeUrls.length));
        }
        for (String ele : authCodeUrls) {
            this.authCodeUrls.add(ele);
        }
        return this;
    }

    public OAuth2Defaults withAuthCodeUrls(Collection<String> authCodeUrls) {
        this.setAuthCodeUrls(authCodeUrls);
        return this;
    }

    public List<String> getOauth2GrantTypesSupported() {
        return this.oauth2GrantTypesSupported;
    }

    public void setOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
        if (oauth2GrantTypesSupported == null) {
            this.oauth2GrantTypesSupported = null;
            return;
        }
        this.oauth2GrantTypesSupported = new ArrayList<String>(oauth2GrantTypesSupported);
    }

    public OAuth2Defaults withOauth2GrantTypesSupported(String ... oauth2GrantTypesSupported) {
        if (this.oauth2GrantTypesSupported == null) {
            this.setOauth2GrantTypesSupported(new ArrayList<String>(oauth2GrantTypesSupported.length));
        }
        for (String ele : oauth2GrantTypesSupported) {
            this.oauth2GrantTypesSupported.add(ele);
        }
        return this;
    }

    public OAuth2Defaults withOauth2GrantTypesSupported(Collection<String> oauth2GrantTypesSupported) {
        this.setOauth2GrantTypesSupported(oauth2GrantTypesSupported);
        return this;
    }

    public OAuth2Defaults withOauth2GrantTypesSupported(OAuth2GrantType ... oauth2GrantTypesSupported) {
        ArrayList<String> oauth2GrantTypesSupportedCopy = new ArrayList<String>(oauth2GrantTypesSupported.length);
        for (OAuth2GrantType value : oauth2GrantTypesSupported) {
            oauth2GrantTypesSupportedCopy.add(value.toString());
        }
        if (this.getOauth2GrantTypesSupported() == null) {
            this.setOauth2GrantTypesSupported(oauth2GrantTypesSupportedCopy);
        } else {
            this.getOauth2GrantTypesSupported().addAll(oauth2GrantTypesSupportedCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOauthScopes() != null) {
            sb.append("OauthScopes: ").append(this.getOauthScopes()).append(",");
        }
        if (this.getTokenUrls() != null) {
            sb.append("TokenUrls: ").append(this.getTokenUrls()).append(",");
        }
        if (this.getAuthCodeUrls() != null) {
            sb.append("AuthCodeUrls: ").append(this.getAuthCodeUrls()).append(",");
        }
        if (this.getOauth2GrantTypesSupported() != null) {
            sb.append("Oauth2GrantTypesSupported: ").append(this.getOauth2GrantTypesSupported());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OAuth2Defaults)) {
            return false;
        }
        OAuth2Defaults other = (OAuth2Defaults)obj;
        if (other.getOauthScopes() == null ^ this.getOauthScopes() == null) {
            return false;
        }
        if (other.getOauthScopes() != null && !other.getOauthScopes().equals(this.getOauthScopes())) {
            return false;
        }
        if (other.getTokenUrls() == null ^ this.getTokenUrls() == null) {
            return false;
        }
        if (other.getTokenUrls() != null && !other.getTokenUrls().equals(this.getTokenUrls())) {
            return false;
        }
        if (other.getAuthCodeUrls() == null ^ this.getAuthCodeUrls() == null) {
            return false;
        }
        if (other.getAuthCodeUrls() != null && !other.getAuthCodeUrls().equals(this.getAuthCodeUrls())) {
            return false;
        }
        if (other.getOauth2GrantTypesSupported() == null ^ this.getOauth2GrantTypesSupported() == null) {
            return false;
        }
        return other.getOauth2GrantTypesSupported() == null || other.getOauth2GrantTypesSupported().equals(this.getOauth2GrantTypesSupported());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOauthScopes() == null ? 0 : this.getOauthScopes().hashCode());
        hashCode = 31 * hashCode + (this.getTokenUrls() == null ? 0 : this.getTokenUrls().hashCode());
        hashCode = 31 * hashCode + (this.getAuthCodeUrls() == null ? 0 : this.getAuthCodeUrls().hashCode());
        hashCode = 31 * hashCode + (this.getOauth2GrantTypesSupported() == null ? 0 : this.getOauth2GrantTypesSupported().hashCode());
        return hashCode;
    }

    public OAuth2Defaults clone() {
        try {
            return (OAuth2Defaults)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OAuth2DefaultsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

