/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.write;

import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.write.WriteDataRequest;
import com.amazonaws.appflow.custom.connector.model.write.WriteOperationType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="WriteDataRequest")
@Generated(from="WriteDataRequest", generator="Immutables")
@Immutable
public final class ImmutableWriteDataRequest
implements WriteDataRequest {
    private final String entityIdentifier;
    private final WriteOperationType operation;
    @Nullable
    private final List<String> idFieldNames;
    @Nullable
    private final List<String> records;
    @Nullable
    private final Boolean allOrNone;
    private final ConnectorContext connectorContext;

    private ImmutableWriteDataRequest(String entityIdentifier, WriteOperationType operation, @Nullable List<String> idFieldNames, @Nullable List<String> records, @Nullable Boolean allOrNone, ConnectorContext connectorContext) {
        this.entityIdentifier = entityIdentifier;
        this.operation = operation;
        this.idFieldNames = idFieldNames;
        this.records = records;
        this.allOrNone = allOrNone;
        this.connectorContext = connectorContext;
    }

    @Override
    @JsonProperty(value="entityIdentifier")
    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    @JsonProperty(value="operation")
    public WriteOperationType operation() {
        return this.operation;
    }

    @Override
    @JsonProperty(value="idFieldNames")
    @Nullable
    public List<String> idFieldNames() {
        return this.idFieldNames;
    }

    @Override
    @JsonProperty(value="records")
    @Nullable
    public List<String> records() {
        return this.records;
    }

    @Override
    @JsonProperty(value="allOrNone")
    @Nullable
    public Boolean allOrNone() {
        return this.allOrNone;
    }

    @Override
    @JsonProperty(value="connectorContext")
    public ConnectorContext connectorContext() {
        return this.connectorContext;
    }

    public final ImmutableWriteDataRequest withEntityIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "entityIdentifier");
        if (this.entityIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableWriteDataRequest(newValue, this.operation, this.idFieldNames, this.records, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withOperation(WriteOperationType value) {
        WriteOperationType newValue = Objects.requireNonNull(value, "operation");
        if (this.operation == newValue) {
            return this;
        }
        return new ImmutableWriteDataRequest(this.entityIdentifier, newValue, this.idFieldNames, this.records, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withIdFieldNames(String ... elements) {
        if (elements == null) {
            return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, null, this.records, this.allOrNone, this.connectorContext);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(false, ImmutableWriteDataRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, newValue, this.records, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withIdFieldNames(@Nullable Iterable<String> elements) {
        if (this.idFieldNames == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(false, ImmutableWriteDataRequest.createSafeList(elements, true, false));
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, newValue, this.records, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withRecords(String ... elements) {
        if (elements == null) {
            return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames, null, this.allOrNone, this.connectorContext);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(false, ImmutableWriteDataRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames, newValue, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withRecords(@Nullable Iterable<String> elements) {
        if (this.records == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(false, ImmutableWriteDataRequest.createSafeList(elements, true, false));
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames, newValue, this.allOrNone, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withAllOrNone(@Nullable Boolean value) {
        if (Objects.equals(this.allOrNone, value)) {
            return this;
        }
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames, this.records, value, this.connectorContext);
    }

    public final ImmutableWriteDataRequest withConnectorContext(ConnectorContext value) {
        if (this.connectorContext == value) {
            return this;
        }
        ConnectorContext newValue = Objects.requireNonNull(value, "connectorContext");
        return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames, this.records, this.allOrNone, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableWriteDataRequest && this.equalTo(0, (ImmutableWriteDataRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableWriteDataRequest another) {
        return this.entityIdentifier.equals(another.entityIdentifier) && this.operation.equals((Object)another.operation) && Objects.equals(this.idFieldNames, another.idFieldNames) && Objects.equals(this.records, another.records) && Objects.equals(this.allOrNone, another.allOrNone) && this.connectorContext.equals(another.connectorContext);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.entityIdentifier.hashCode();
        h2 += (h2 << 5) + this.operation.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.idFieldNames);
        h2 += (h2 << 5) + Objects.hashCode(this.records);
        h2 += (h2 << 5) + Objects.hashCode(this.allOrNone);
        h2 += (h2 << 5) + this.connectorContext.hashCode();
        return h2;
    }

    public String toString() {
        return "WriteDataRequest{entityIdentifier=" + this.entityIdentifier + ", operation=" + (Object)((Object)this.operation) + ", idFieldNames=" + this.idFieldNames + ", records=" + this.records + ", allOrNone=" + this.allOrNone + ", connectorContext=" + this.connectorContext + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableWriteDataRequest fromJson(Json json) {
        Builder builder = ImmutableWriteDataRequest.builder();
        if (json.entityIdentifier != null) {
            builder.entityIdentifier(json.entityIdentifier);
        }
        if (json.operation != null) {
            builder.operation(json.operation);
        }
        if (json.idFieldNames != null) {
            builder.addAllIdFieldNames(json.idFieldNames);
        }
        if (json.records != null) {
            builder.addAllRecords(json.records);
        }
        if (json.allOrNone != null) {
            builder.allOrNone(json.allOrNone);
        }
        if (json.connectorContext != null) {
            builder.connectorContext(json.connectorContext);
        }
        return builder.build();
    }

    public static ImmutableWriteDataRequest copyOf(WriteDataRequest instance) {
        if (instance instanceof ImmutableWriteDataRequest) {
            return (ImmutableWriteDataRequest)instance;
        }
        return ImmutableWriteDataRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="WriteDataRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_IDENTIFIER = 1L;
        private static final long INIT_BIT_OPERATION = 2L;
        private static final long INIT_BIT_CONNECTOR_CONTEXT = 4L;
        private long initBits = 7L;
        @Nullable
        private String entityIdentifier;
        @Nullable
        private WriteOperationType operation;
        private List<String> idFieldNames = null;
        private List<String> records = null;
        @Nullable
        private Boolean allOrNone;
        @Nullable
        private ConnectorContext connectorContext;

        private Builder() {
        }

        public final Builder from(WriteDataRequest instance) {
            Boolean allOrNoneValue;
            List<String> recordsValue;
            Objects.requireNonNull(instance, "instance");
            this.entityIdentifier(instance.entityIdentifier());
            this.operation(instance.operation());
            List<String> idFieldNamesValue = instance.idFieldNames();
            if (idFieldNamesValue != null) {
                this.addAllIdFieldNames(idFieldNamesValue);
            }
            if ((recordsValue = instance.records()) != null) {
                this.addAllRecords(recordsValue);
            }
            if ((allOrNoneValue = instance.allOrNone()) != null) {
                this.allOrNone(allOrNoneValue);
            }
            this.connectorContext(instance.connectorContext());
            return this;
        }

        @JsonProperty(value="entityIdentifier")
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = Objects.requireNonNull(entityIdentifier, "entityIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="operation")
        public final Builder operation(WriteOperationType operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addIdFieldNames(String element) {
            if (this.idFieldNames == null) {
                this.idFieldNames = new ArrayList<String>();
            }
            this.idFieldNames.add(Objects.requireNonNull(element, "idFieldNames element"));
            return this;
        }

        public final Builder addIdFieldNames(String ... elements) {
            if (this.idFieldNames == null) {
                this.idFieldNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.idFieldNames.add(Objects.requireNonNull(element, "idFieldNames element"));
            }
            return this;
        }

        @JsonProperty(value="idFieldNames")
        public final Builder idFieldNames(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.idFieldNames = null;
                return this;
            }
            this.idFieldNames = new ArrayList<String>();
            return this.addAllIdFieldNames(elements);
        }

        public final Builder addAllIdFieldNames(Iterable<String> elements) {
            Objects.requireNonNull(elements, "idFieldNames element");
            if (this.idFieldNames == null) {
                this.idFieldNames = new ArrayList<String>();
            }
            for (String element : elements) {
                this.idFieldNames.add(Objects.requireNonNull(element, "idFieldNames element"));
            }
            return this;
        }

        public final Builder addRecords(String element) {
            if (this.records == null) {
                this.records = new ArrayList<String>();
            }
            this.records.add(Objects.requireNonNull(element, "records element"));
            return this;
        }

        public final Builder addRecords(String ... elements) {
            if (this.records == null) {
                this.records = new ArrayList<String>();
            }
            for (String element : elements) {
                this.records.add(Objects.requireNonNull(element, "records element"));
            }
            return this;
        }

        @JsonProperty(value="records")
        public final Builder records(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.records = null;
                return this;
            }
            this.records = new ArrayList<String>();
            return this.addAllRecords(elements);
        }

        public final Builder addAllRecords(Iterable<String> elements) {
            Objects.requireNonNull(elements, "records element");
            if (this.records == null) {
                this.records = new ArrayList<String>();
            }
            for (String element : elements) {
                this.records.add(Objects.requireNonNull(element, "records element"));
            }
            return this;
        }

        @JsonProperty(value="allOrNone")
        public final Builder allOrNone(@Nullable Boolean allOrNone) {
            this.allOrNone = allOrNone;
            return this;
        }

        @JsonProperty(value="connectorContext")
        public final Builder connectorContext(ConnectorContext connectorContext) {
            this.connectorContext = Objects.requireNonNull(connectorContext, "connectorContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableWriteDataRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableWriteDataRequest(this.entityIdentifier, this.operation, this.idFieldNames == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(true, this.idFieldNames), this.records == null ? null : ImmutableWriteDataRequest.createUnmodifiableList(true, this.records), this.allOrNone, this.connectorContext);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("connectorContext");
            }
            return "Cannot build WriteDataRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="WriteDataRequest", generator="Immutables")
    static final class Json
    implements WriteDataRequest {
        @Nullable
        String entityIdentifier;
        @Nullable
        WriteOperationType operation;
        @Nullable
        List<String> idFieldNames = null;
        @Nullable
        List<String> records = null;
        @Nullable
        Boolean allOrNone;
        @Nullable
        ConnectorContext connectorContext;

        Json() {
        }

        @JsonProperty(value="entityIdentifier")
        public void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @JsonProperty(value="operation")
        public void setOperation(WriteOperationType operation) {
            this.operation = operation;
        }

        @JsonProperty(value="idFieldNames")
        public void setIdFieldNames(@Nullable List<String> idFieldNames) {
            this.idFieldNames = idFieldNames;
        }

        @JsonProperty(value="records")
        public void setRecords(@Nullable List<String> records) {
            this.records = records;
        }

        @JsonProperty(value="allOrNone")
        public void setAllOrNone(@Nullable Boolean allOrNone) {
            this.allOrNone = allOrNone;
        }

        @JsonProperty(value="connectorContext")
        public void setConnectorContext(ConnectorContext connectorContext) {
            this.connectorContext = connectorContext;
        }

        @Override
        public String entityIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WriteOperationType operation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> idFieldNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> records() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean allOrNone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorContext connectorContext() {
            throw new UnsupportedOperationException();
        }
    }
}

