/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.query;

import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.query.QueryDataResponse;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="QueryDataResponse", generator="Immutables")
@Immutable
public final class ImmutableQueryDataResponse
implements QueryDataResponse {
    private final boolean isSuccess;
    @Nullable
    private final ErrorDetails errorDetails;
    @Nullable
    private final String nextToken;
    @Nullable
    private final ImmutableList<String> records;

    private ImmutableQueryDataResponse(boolean isSuccess, @Nullable ErrorDetails errorDetails, @Nullable String nextToken, @Nullable ImmutableList<String> records) {
        this.isSuccess = isSuccess;
        this.errorDetails = errorDetails;
        this.nextToken = nextToken;
        this.records = records;
    }

    @Override
    @JsonProperty(value="isSuccess")
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    @JsonProperty(value="errorDetails")
    @Nullable
    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    @Override
    @JsonProperty(value="nextToken")
    @Nullable
    public String nextToken() {
        return this.nextToken;
    }

    @JsonProperty(value="records")
    @Nullable
    public ImmutableList<String> records() {
        return this.records;
    }

    public final ImmutableQueryDataResponse withIsSuccess(boolean value) {
        if (this.isSuccess == value) {
            return this;
        }
        return new ImmutableQueryDataResponse(value, this.errorDetails, this.nextToken, this.records);
    }

    public final ImmutableQueryDataResponse withErrorDetails(@Nullable ErrorDetails value) {
        if (this.errorDetails == value) {
            return this;
        }
        return new ImmutableQueryDataResponse(this.isSuccess, value, this.nextToken, this.records);
    }

    public final ImmutableQueryDataResponse withNextToken(@Nullable String value) {
        if (Objects.equals(this.nextToken, value)) {
            return this;
        }
        return new ImmutableQueryDataResponse(this.isSuccess, this.errorDetails, value, this.records);
    }

    public final ImmutableQueryDataResponse withRecords(String ... elements) {
        if (elements == null) {
            return new ImmutableQueryDataResponse(this.isSuccess, this.errorDetails, this.nextToken, null);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryDataResponse(this.isSuccess, this.errorDetails, this.nextToken, newValue);
    }

    public final ImmutableQueryDataResponse withRecords(@Nullable Iterable<String> elements) {
        if (this.records == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableQueryDataResponse(this.isSuccess, this.errorDetails, this.nextToken, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableQueryDataResponse && this.equalTo(0, (ImmutableQueryDataResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableQueryDataResponse another) {
        return this.isSuccess == another.isSuccess && Objects.equals(this.errorDetails, another.errorDetails) && Objects.equals(this.nextToken, another.nextToken) && Objects.equals(this.records, another.records);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Booleans.hashCode(this.isSuccess);
        h2 += (h2 << 5) + Objects.hashCode(this.errorDetails);
        h2 += (h2 << 5) + Objects.hashCode(this.nextToken);
        h2 += (h2 << 5) + Objects.hashCode(this.records);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("QueryDataResponse").omitNullValues().add("isSuccess", this.isSuccess).add("errorDetails", this.errorDetails).add("nextToken", this.nextToken).add("records", this.records).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableQueryDataResponse fromJson(Json json) {
        Builder builder = ImmutableQueryDataResponse.builder();
        if (json.isSuccessIsSet) {
            builder.isSuccess(json.isSuccess);
        }
        if (json.errorDetails != null) {
            builder.errorDetails(json.errorDetails);
        }
        if (json.nextToken != null) {
            builder.nextToken(json.nextToken);
        }
        if (json.records != null) {
            builder.addAllRecords(json.records);
        }
        return builder.build();
    }

    public static ImmutableQueryDataResponse copyOf(QueryDataResponse instance) {
        if (instance instanceof ImmutableQueryDataResponse) {
            return (ImmutableQueryDataResponse)instance;
        }
        return ImmutableQueryDataResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="QueryDataResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IS_SUCCESS = 1L;
        private long initBits = 1L;
        private boolean isSuccess;
        @Nullable
        private ErrorDetails errorDetails;
        @Nullable
        private String nextToken;
        private ImmutableList.Builder<String> records = null;

        private Builder() {
        }

        public final Builder from(QueryDataResponse instance) {
            List<String> recordsValue;
            String nextTokenValue;
            Objects.requireNonNull(instance, "instance");
            this.isSuccess(instance.isSuccess());
            ErrorDetails errorDetailsValue = instance.errorDetails();
            if (errorDetailsValue != null) {
                this.errorDetails(errorDetailsValue);
            }
            if ((nextTokenValue = instance.nextToken()) != null) {
                this.nextToken(nextTokenValue);
            }
            if ((recordsValue = instance.records()) != null) {
                this.addAllRecords(recordsValue);
            }
            return this;
        }

        @JsonProperty(value="isSuccess")
        public final Builder isSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="errorDetails")
        public final Builder errorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @JsonProperty(value="nextToken")
        public final Builder nextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Builder addRecords(String element) {
            if (this.records == null) {
                this.records = ImmutableList.builder();
            }
            this.records.add((Object)element);
            return this;
        }

        public final Builder addRecords(String ... elements) {
            if (this.records == null) {
                this.records = ImmutableList.builder();
            }
            this.records.add(elements);
            return this;
        }

        @JsonProperty(value="records")
        public final Builder records(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.records = null;
                return this;
            }
            this.records = ImmutableList.builder();
            return this.addAllRecords(elements);
        }

        public final Builder addAllRecords(Iterable<String> elements) {
            Objects.requireNonNull(elements, "records element");
            if (this.records == null) {
                this.records = ImmutableList.builder();
            }
            this.records.addAll((Iterable)elements);
            return this;
        }

        public ImmutableQueryDataResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableQueryDataResponse(this.isSuccess, this.errorDetails, this.nextToken, (ImmutableList)(this.records == null ? null : this.records.build()));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("isSuccess");
            }
            return "Cannot build QueryDataResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="QueryDataResponse", generator="Immutables")
    static final class Json
    implements QueryDataResponse {
        boolean isSuccess;
        boolean isSuccessIsSet;
        @Nullable
        ErrorDetails errorDetails;
        @Nullable
        String nextToken;
        @Nullable
        List<String> records = null;

        Json() {
        }

        @JsonProperty(value="isSuccess")
        public void setIsSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.isSuccessIsSet = true;
        }

        @JsonProperty(value="errorDetails")
        public void setErrorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        @JsonProperty(value="nextToken")
        public void setNextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
        }

        @JsonProperty(value="records")
        public void setRecords(@Nullable List<String> records) {
            this.records = records;
        }

        @Override
        public boolean isSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorDetails errorDetails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> records() {
            throw new UnsupportedOperationException();
        }
    }
}

