/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorOperator;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldConstraints;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDataType;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.ReadOperationProperty;
import com.amazonaws.appflow.custom.connector.model.metadata.WriteOperationProperty;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FieldDefinition", generator="Immutables")
@Immutable
public final class ImmutableFieldDefinition
implements FieldDefinition {
    private final String fieldName;
    private final FieldDataType dataType;
    private final String dataTypeLabel;
    @Nullable
    private final String label;
    @Nullable
    private final String description;
    @Nullable
    private final Boolean isPrimaryKey;
    @Nullable
    private final String defaultValue;
    @Nullable
    private final Boolean isDeprecated;
    @Nullable
    private final FieldConstraints constraints;
    @Nullable
    private final ReadOperationProperty readProperties;
    @Nullable
    private final WriteOperationProperty writeProperties;
    private final ImmutableList<ConnectorOperator> filterOperators;
    @Nullable
    private final ImmutableMap<String, String> customProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableFieldDefinition(Builder builder) {
        this.fieldName = builder.fieldName;
        this.dataType = builder.dataType;
        this.label = builder.label;
        this.description = builder.description;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.defaultValue = builder.defaultValue;
        this.isDeprecated = builder.isDeprecated;
        this.constraints = builder.constraints;
        this.readProperties = builder.readProperties;
        this.writeProperties = builder.writeProperties;
        ImmutableMap<Object, Object> immutableMap = this.customProperties = builder.customProperties == null ? null : builder.customProperties.build();
        if (builder.dataTypeLabel != null) {
            this.initShim.dataTypeLabel(builder.dataTypeLabel);
        }
        if (builder.filterOperatorsIsSet()) {
            this.initShim.filterOperators((ImmutableList<ConnectorOperator>)builder.filterOperators.build());
        }
        this.dataTypeLabel = this.initShim.dataTypeLabel();
        this.filterOperators = this.initShim.filterOperators();
        this.initShim = null;
    }

    private ImmutableFieldDefinition(String fieldName, FieldDataType dataType, String dataTypeLabel, @Nullable String label, @Nullable String description, @Nullable Boolean isPrimaryKey, @Nullable String defaultValue, @Nullable Boolean isDeprecated, @Nullable FieldConstraints constraints, @Nullable ReadOperationProperty readProperties, @Nullable WriteOperationProperty writeProperties, ImmutableList<ConnectorOperator> filterOperators, @Nullable ImmutableMap<String, String> customProperties) {
        this.fieldName = fieldName;
        this.dataType = dataType;
        this.dataTypeLabel = dataTypeLabel;
        this.label = label;
        this.description = description;
        this.isPrimaryKey = isPrimaryKey;
        this.defaultValue = defaultValue;
        this.isDeprecated = isDeprecated;
        this.constraints = constraints;
        this.readProperties = readProperties;
        this.writeProperties = writeProperties;
        this.filterOperators = filterOperators;
        this.customProperties = customProperties;
        this.initShim = null;
    }

    private String dataTypeLabelInitialize() {
        return FieldDefinition.super.dataTypeLabel();
    }

    private List<ConnectorOperator> filterOperatorsInitialize() {
        return FieldDefinition.super.filterOperators();
    }

    @Override
    @JsonProperty(value="fieldName")
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    @JsonProperty(value="dataType")
    public FieldDataType dataType() {
        return this.dataType;
    }

    @Override
    @JsonProperty(value="dataTypeLabel")
    public String dataTypeLabel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dataTypeLabel() : this.dataTypeLabel;
    }

    @Override
    @JsonProperty(value="label")
    @Nullable
    public String label() {
        return this.label;
    }

    @Override
    @JsonProperty(value="description")
    @Nullable
    public String description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="isPrimaryKey")
    @Nullable
    public Boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    @JsonProperty(value="defaultValue")
    @Nullable
    public String defaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonProperty(value="isDeprecated")
    @Nullable
    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    @JsonProperty(value="constraints")
    @Nullable
    public FieldConstraints constraints() {
        return this.constraints;
    }

    @Override
    @JsonProperty(value="readProperties")
    @Nullable
    public ReadOperationProperty readProperties() {
        return this.readProperties;
    }

    @Override
    @JsonProperty(value="writeProperties")
    @Nullable
    public WriteOperationProperty writeProperties() {
        return this.writeProperties;
    }

    @JsonProperty(value="filterOperators")
    public ImmutableList<ConnectorOperator> filterOperators() {
        InitShim shim = this.initShim;
        return shim != null ? shim.filterOperators() : this.filterOperators;
    }

    @JsonProperty(value="customProperties")
    @Nullable
    public ImmutableMap<String, String> customProperties() {
        return this.customProperties;
    }

    public final ImmutableFieldDefinition withFieldName(String value) {
        String newValue = Objects.requireNonNull(value, "fieldName");
        if (this.fieldName.equals(newValue)) {
            return this;
        }
        return new ImmutableFieldDefinition(newValue, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withDataType(FieldDataType value) {
        FieldDataType newValue = Objects.requireNonNull(value, "dataType");
        if (this.dataType == newValue) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, newValue, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withDataTypeLabel(String value) {
        String newValue = Objects.requireNonNull(value, "dataTypeLabel");
        if (this.dataTypeLabel.equals(newValue)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, newValue, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withLabel(@Nullable String value) {
        if (Objects.equals(this.label, value)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, value, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withDescription(@Nullable String value) {
        if (Objects.equals(this.description, value)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, value, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withIsPrimaryKey(@Nullable Boolean value) {
        if (Objects.equals(this.isPrimaryKey, value)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, value, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withDefaultValue(@Nullable String value) {
        if (Objects.equals(this.defaultValue, value)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, value, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withIsDeprecated(@Nullable Boolean value) {
        if (Objects.equals(this.isDeprecated, value)) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, value, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withConstraints(@Nullable FieldConstraints value) {
        if (this.constraints == value) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, value, this.readProperties, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withReadProperties(@Nullable ReadOperationProperty value) {
        if (this.readProperties == value) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, value, this.writeProperties, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withWriteProperties(@Nullable WriteOperationProperty value) {
        if (this.writeProperties == value) {
            return this;
        }
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, value, this.filterOperators, this.customProperties);
    }

    public final ImmutableFieldDefinition withFilterOperators(ConnectorOperator ... elements) {
        ImmutableList<ConnectorOperator> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, newValue, this.customProperties);
    }

    public final ImmutableFieldDefinition withFilterOperators(Iterable<? extends ConnectorOperator> elements) {
        if (this.filterOperators == elements) {
            return this;
        }
        ImmutableList<ConnectorOperator> newValue = ImmutableList.copyOf(elements);
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, newValue, this.customProperties);
    }

    public final ImmutableFieldDefinition withCustomProperties(@Nullable Map<String, ? extends String> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap<String, String> newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableFieldDefinition(this.fieldName, this.dataType, this.dataTypeLabel, this.label, this.description, this.isPrimaryKey, this.defaultValue, this.isDeprecated, this.constraints, this.readProperties, this.writeProperties, this.filterOperators, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldDefinition && this.equalTo(0, (ImmutableFieldDefinition)another);
    }

    private boolean equalTo(int synthetic, ImmutableFieldDefinition another) {
        return this.fieldName.equals(another.fieldName) && this.dataType.equals((Object)another.dataType) && this.dataTypeLabel.equals(another.dataTypeLabel) && Objects.equals(this.label, another.label) && Objects.equals(this.description, another.description) && Objects.equals(this.isPrimaryKey, another.isPrimaryKey) && Objects.equals(this.defaultValue, another.defaultValue) && Objects.equals(this.isDeprecated, another.isDeprecated) && Objects.equals(this.constraints, another.constraints) && Objects.equals(this.readProperties, another.readProperties) && Objects.equals(this.writeProperties, another.writeProperties) && this.filterOperators.equals(another.filterOperators) && Objects.equals(this.customProperties, another.customProperties);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.fieldName.hashCode();
        h2 += (h2 << 5) + this.dataType.hashCode();
        h2 += (h2 << 5) + this.dataTypeLabel.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.label);
        h2 += (h2 << 5) + Objects.hashCode(this.description);
        h2 += (h2 << 5) + Objects.hashCode(this.isPrimaryKey);
        h2 += (h2 << 5) + Objects.hashCode(this.defaultValue);
        h2 += (h2 << 5) + Objects.hashCode(this.isDeprecated);
        h2 += (h2 << 5) + Objects.hashCode(this.constraints);
        h2 += (h2 << 5) + Objects.hashCode(this.readProperties);
        h2 += (h2 << 5) + Objects.hashCode(this.writeProperties);
        h2 += (h2 << 5) + this.filterOperators.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.customProperties);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FieldDefinition").omitNullValues().add("fieldName", this.fieldName).add("dataType", (Object)this.dataType).add("dataTypeLabel", this.dataTypeLabel).add("label", this.label).add("description", this.description).add("isPrimaryKey", this.isPrimaryKey).add("defaultValue", this.defaultValue).add("isDeprecated", this.isDeprecated).add("constraints", this.constraints).add("readProperties", this.readProperties).add("writeProperties", this.writeProperties).add("filterOperators", this.filterOperators).add("customProperties", this.customProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFieldDefinition fromJson(Json json) {
        Builder builder = ImmutableFieldDefinition.builder();
        if (json.fieldName != null) {
            builder.fieldName(json.fieldName);
        }
        if (json.dataType != null) {
            builder.dataType(json.dataType);
        }
        if (json.dataTypeLabel != null) {
            builder.dataTypeLabel(json.dataTypeLabel);
        }
        if (json.label != null) {
            builder.label(json.label);
        }
        if (json.description != null) {
            builder.description(json.description);
        }
        if (json.isPrimaryKey != null) {
            builder.isPrimaryKey(json.isPrimaryKey);
        }
        if (json.defaultValue != null) {
            builder.defaultValue(json.defaultValue);
        }
        if (json.isDeprecated != null) {
            builder.isDeprecated(json.isDeprecated);
        }
        if (json.constraints != null) {
            builder.constraints(json.constraints);
        }
        if (json.readProperties != null) {
            builder.readProperties(json.readProperties);
        }
        if (json.writeProperties != null) {
            builder.writeProperties(json.writeProperties);
        }
        if (json.filterOperatorsIsSet) {
            builder.addAllFilterOperators(json.filterOperators);
        }
        if (json.customProperties != null) {
            builder.putAllCustomProperties(json.customProperties);
        }
        return builder.build();
    }

    public static ImmutableFieldDefinition copyOf(FieldDefinition instance) {
        if (instance instanceof ImmutableFieldDefinition) {
            return (ImmutableFieldDefinition)instance;
        }
        return ImmutableFieldDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FieldDefinition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FIELD_NAME = 1L;
        private static final long INIT_BIT_DATA_TYPE = 2L;
        private static final long OPT_BIT_FILTER_OPERATORS = 1L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String fieldName;
        @Nullable
        private FieldDataType dataType;
        @Nullable
        private String dataTypeLabel;
        @Nullable
        private String label;
        @Nullable
        private String description;
        @Nullable
        private Boolean isPrimaryKey;
        @Nullable
        private String defaultValue;
        @Nullable
        private Boolean isDeprecated;
        @Nullable
        private FieldConstraints constraints;
        @Nullable
        private ReadOperationProperty readProperties;
        @Nullable
        private WriteOperationProperty writeProperties;
        private ImmutableList.Builder<ConnectorOperator> filterOperators = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> customProperties = null;

        private Builder() {
        }

        public final Builder from(FieldDefinition instance) {
            WriteOperationProperty writePropertiesValue;
            ReadOperationProperty readPropertiesValue;
            FieldConstraints constraintsValue;
            Boolean isDeprecatedValue;
            String defaultValueValue;
            Boolean isPrimaryKeyValue;
            String descriptionValue;
            Objects.requireNonNull(instance, "instance");
            this.fieldName(instance.fieldName());
            this.dataType(instance.dataType());
            this.dataTypeLabel(instance.dataTypeLabel());
            String labelValue = instance.label();
            if (labelValue != null) {
                this.label(labelValue);
            }
            if ((descriptionValue = instance.description()) != null) {
                this.description(descriptionValue);
            }
            if ((isPrimaryKeyValue = instance.isPrimaryKey()) != null) {
                this.isPrimaryKey(isPrimaryKeyValue);
            }
            if ((defaultValueValue = instance.defaultValue()) != null) {
                this.defaultValue(defaultValueValue);
            }
            if ((isDeprecatedValue = instance.isDeprecated()) != null) {
                this.isDeprecated(isDeprecatedValue);
            }
            if ((constraintsValue = instance.constraints()) != null) {
                this.constraints(constraintsValue);
            }
            if ((readPropertiesValue = instance.readProperties()) != null) {
                this.readProperties(readPropertiesValue);
            }
            if ((writePropertiesValue = instance.writeProperties()) != null) {
                this.writeProperties(writePropertiesValue);
            }
            this.addAllFilterOperators(instance.filterOperators());
            Map<String, String> customPropertiesValue = instance.customProperties();
            if (customPropertiesValue != null) {
                this.putAllCustomProperties(customPropertiesValue);
            }
            return this;
        }

        @JsonProperty(value="fieldName")
        public final Builder fieldName(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="dataType")
        public final Builder dataType(FieldDataType dataType) {
            this.dataType = Objects.requireNonNull(dataType, "dataType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="dataTypeLabel")
        public final Builder dataTypeLabel(String dataTypeLabel) {
            this.dataTypeLabel = Objects.requireNonNull(dataTypeLabel, "dataTypeLabel");
            return this;
        }

        @JsonProperty(value="label")
        public final Builder label(@Nullable String label) {
            this.label = label;
            return this;
        }

        @JsonProperty(value="description")
        public final Builder description(@Nullable String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="isPrimaryKey")
        public final Builder isPrimaryKey(@Nullable Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        @JsonProperty(value="defaultValue")
        public final Builder defaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        @JsonProperty(value="isDeprecated")
        public final Builder isDeprecated(@Nullable Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        @JsonProperty(value="constraints")
        public final Builder constraints(@Nullable FieldConstraints constraints) {
            this.constraints = constraints;
            return this;
        }

        @JsonProperty(value="readProperties")
        public final Builder readProperties(@Nullable ReadOperationProperty readProperties) {
            this.readProperties = readProperties;
            return this;
        }

        @JsonProperty(value="writeProperties")
        public final Builder writeProperties(@Nullable WriteOperationProperty writeProperties) {
            this.writeProperties = writeProperties;
            return this;
        }

        public final Builder addFilterOperators(ConnectorOperator element) {
            this.filterOperators.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addFilterOperators(ConnectorOperator ... elements) {
            this.filterOperators.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="filterOperators")
        public final Builder filterOperators(Iterable<? extends ConnectorOperator> elements) {
            this.filterOperators = ImmutableList.builder();
            return this.addAllFilterOperators(elements);
        }

        public final Builder addAllFilterOperators(Iterable<? extends ConnectorOperator> elements) {
            this.filterOperators.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder putCustomProperties(String key, String value) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put(key, value);
            return this;
        }

        public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(value="customProperties")
        public final Builder customProperties(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.customProperties = null;
                return this;
            }
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.putAll(entries);
            return this;
        }

        public ImmutableFieldDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldDefinition(this);
        }

        private boolean filterOperatorsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fieldName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("dataType");
            }
            return "Cannot build FieldDefinition, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FieldDefinition", generator="Immutables")
    static final class Json
    implements FieldDefinition {
        @Nullable
        String fieldName;
        @Nullable
        FieldDataType dataType;
        @Nullable
        String dataTypeLabel;
        @Nullable
        String label;
        @Nullable
        String description;
        @Nullable
        Boolean isPrimaryKey;
        @Nullable
        String defaultValue;
        @Nullable
        Boolean isDeprecated;
        @Nullable
        FieldConstraints constraints;
        @Nullable
        ReadOperationProperty readProperties;
        @Nullable
        WriteOperationProperty writeProperties;
        @Nullable
        List<ConnectorOperator> filterOperators = ImmutableList.of();
        boolean filterOperatorsIsSet;
        @Nullable
        Map<String, String> customProperties = null;

        Json() {
        }

        @JsonProperty(value="fieldName")
        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @JsonProperty(value="dataType")
        public void setDataType(FieldDataType dataType) {
            this.dataType = dataType;
        }

        @JsonProperty(value="dataTypeLabel")
        public void setDataTypeLabel(String dataTypeLabel) {
            this.dataTypeLabel = dataTypeLabel;
        }

        @JsonProperty(value="label")
        public void setLabel(@Nullable String label) {
            this.label = label;
        }

        @JsonProperty(value="description")
        public void setDescription(@Nullable String description) {
            this.description = description;
        }

        @JsonProperty(value="isPrimaryKey")
        public void setIsPrimaryKey(@Nullable Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @JsonProperty(value="defaultValue")
        public void setDefaultValue(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @JsonProperty(value="isDeprecated")
        public void setIsDeprecated(@Nullable Boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
        }

        @JsonProperty(value="constraints")
        public void setConstraints(@Nullable FieldConstraints constraints) {
            this.constraints = constraints;
        }

        @JsonProperty(value="readProperties")
        public void setReadProperties(@Nullable ReadOperationProperty readProperties) {
            this.readProperties = readProperties;
        }

        @JsonProperty(value="writeProperties")
        public void setWriteProperties(@Nullable WriteOperationProperty writeProperties) {
            this.writeProperties = writeProperties;
        }

        @JsonProperty(value="filterOperators")
        public void setFilterOperators(List<ConnectorOperator> filterOperators) {
            this.filterOperators = filterOperators;
            this.filterOperatorsIsSet = true;
        }

        @JsonProperty(value="customProperties")
        public void setCustomProperties(@Nullable Map<String, String> customProperties) {
            this.customProperties = customProperties;
        }

        @Override
        public String fieldName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldDataType dataType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String dataTypeLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String label() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String description() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isPrimaryKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String defaultValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isDeprecated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FieldConstraints constraints() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReadOperationProperty readProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public WriteOperationProperty writeProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConnectorOperator> filterOperators() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> customProperties() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="FieldDefinition", generator="Immutables")
    private final class InitShim {
        private byte dataTypeLabelBuildStage = 0;
        private String dataTypeLabel;
        private byte filterOperatorsBuildStage = 0;
        private ImmutableList<ConnectorOperator> filterOperators;

        private InitShim() {
        }

        String dataTypeLabel() {
            if (this.dataTypeLabelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dataTypeLabelBuildStage == 0) {
                this.dataTypeLabelBuildStage = (byte)-1;
                this.dataTypeLabel = Objects.requireNonNull(ImmutableFieldDefinition.this.dataTypeLabelInitialize(), "dataTypeLabel");
                this.dataTypeLabelBuildStage = 1;
            }
            return this.dataTypeLabel;
        }

        void dataTypeLabel(String dataTypeLabel) {
            this.dataTypeLabel = dataTypeLabel;
            this.dataTypeLabelBuildStage = 1;
        }

        ImmutableList<ConnectorOperator> filterOperators() {
            if (this.filterOperatorsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filterOperatorsBuildStage == 0) {
                this.filterOperatorsBuildStage = (byte)-1;
                this.filterOperators = ImmutableList.copyOf(ImmutableFieldDefinition.this.filterOperatorsInitialize());
                this.filterOperatorsBuildStage = 1;
            }
            return this.filterOperators;
        }

        void filterOperators(ImmutableList<ConnectorOperator> filterOperators) {
            this.filterOperators = filterOperators;
            this.filterOperatorsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.dataTypeLabelBuildStage == -1) {
                attributes.add("dataTypeLabel");
            }
            if (this.filterOperatorsBuildStage == -1) {
                attributes.add("filterOperators");
            }
            return "Cannot build FieldDefinition, attribute initializers form cycle " + attributes;
        }
    }
}

