/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration;

import com.amazonaws.appflow.custom.connector.model.ErrorDetails;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorModes;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorOperator;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.DescribeConnectorConfigurationResponse;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.TriggerFrequency;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.TriggerType;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthenticationConfig;
import com.amazonaws.appflow.custom.connector.model.settings.ConnectorRuntimeSetting;
import com.amazonaws.appflow.custom.connector.model.write.WriteOperationType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DescribeConnectorConfigurationResponse", generator="Immutables")
@Immutable
public final class ImmutableDescribeConnectorConfigurationResponse
implements DescribeConnectorConfigurationResponse {
    private final String connectorOwner;
    private final String connectorName;
    private final String connectorVersion;
    private final ImmutableList<ConnectorModes> connectorModes;
    @Nullable
    private final AuthenticationConfig authenticationConfig;
    @Nullable
    private final ImmutableList<ConnectorRuntimeSetting> connectorRuntimeSetting;
    private final ImmutableList<String> supportedApiVersions;
    private final ImmutableList<ConnectorOperator> operatorsSupported;
    private final ImmutableList<TriggerType> supportedTriggerTypes;
    private final ImmutableList<TriggerFrequency> triggerFrequenciesSupported;
    private final ImmutableList<WriteOperationType> supportedWriteOperations;
    @Nullable
    private final String logoURL;
    private final boolean isSuccess;
    @Nullable
    private final ErrorDetails errorDetails;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDescribeConnectorConfigurationResponse(Builder builder) {
        this.connectorOwner = builder.connectorOwner;
        this.connectorName = builder.connectorName;
        this.connectorVersion = builder.connectorVersion;
        this.connectorModes = builder.connectorModes.build();
        this.authenticationConfig = builder.authenticationConfig;
        this.connectorRuntimeSetting = builder.connectorRuntimeSetting == null ? null : builder.connectorRuntimeSetting.build();
        this.supportedApiVersions = builder.supportedApiVersions.build();
        this.logoURL = builder.logoURL;
        this.isSuccess = builder.isSuccess;
        this.errorDetails = builder.errorDetails;
        if (builder.operatorsSupportedIsSet()) {
            this.initShim.operatorsSupported((ImmutableList<ConnectorOperator>)builder.operatorsSupported.build());
        }
        if (builder.supportedTriggerTypesIsSet()) {
            this.initShim.supportedTriggerTypes((ImmutableList<TriggerType>)builder.supportedTriggerTypes.build());
        }
        if (builder.triggerFrequenciesSupportedIsSet()) {
            this.initShim.triggerFrequenciesSupported((ImmutableList<TriggerFrequency>)builder.triggerFrequenciesSupported.build());
        }
        if (builder.supportedWriteOperationsIsSet()) {
            this.initShim.supportedWriteOperations((ImmutableList<WriteOperationType>)builder.supportedWriteOperations.build());
        }
        this.operatorsSupported = this.initShim.operatorsSupported();
        this.supportedTriggerTypes = this.initShim.supportedTriggerTypes();
        this.triggerFrequenciesSupported = this.initShim.triggerFrequenciesSupported();
        this.supportedWriteOperations = this.initShim.supportedWriteOperations();
        this.initShim = null;
    }

    private ImmutableDescribeConnectorConfigurationResponse(String connectorOwner, String connectorName, String connectorVersion, ImmutableList<ConnectorModes> connectorModes, @Nullable AuthenticationConfig authenticationConfig, @Nullable ImmutableList<ConnectorRuntimeSetting> connectorRuntimeSetting, ImmutableList<String> supportedApiVersions, ImmutableList<ConnectorOperator> operatorsSupported, ImmutableList<TriggerType> supportedTriggerTypes, ImmutableList<TriggerFrequency> triggerFrequenciesSupported, ImmutableList<WriteOperationType> supportedWriteOperations, @Nullable String logoURL, boolean isSuccess, @Nullable ErrorDetails errorDetails) {
        this.connectorOwner = connectorOwner;
        this.connectorName = connectorName;
        this.connectorVersion = connectorVersion;
        this.connectorModes = connectorModes;
        this.authenticationConfig = authenticationConfig;
        this.connectorRuntimeSetting = connectorRuntimeSetting;
        this.supportedApiVersions = supportedApiVersions;
        this.operatorsSupported = operatorsSupported;
        this.supportedTriggerTypes = supportedTriggerTypes;
        this.triggerFrequenciesSupported = triggerFrequenciesSupported;
        this.supportedWriteOperations = supportedWriteOperations;
        this.logoURL = logoURL;
        this.isSuccess = isSuccess;
        this.errorDetails = errorDetails;
        this.initShim = null;
    }

    private List<ConnectorOperator> operatorsSupportedInitialize() {
        return DescribeConnectorConfigurationResponse.super.operatorsSupported();
    }

    private List<TriggerType> supportedTriggerTypesInitialize() {
        return DescribeConnectorConfigurationResponse.super.supportedTriggerTypes();
    }

    private List<TriggerFrequency> triggerFrequenciesSupportedInitialize() {
        return DescribeConnectorConfigurationResponse.super.triggerFrequenciesSupported();
    }

    private List<WriteOperationType> supportedWriteOperationsInitialize() {
        return DescribeConnectorConfigurationResponse.super.supportedWriteOperations();
    }

    @Override
    @JsonProperty(value="connectorOwner")
    public String connectorOwner() {
        return this.connectorOwner;
    }

    @Override
    @JsonProperty(value="connectorName")
    public String connectorName() {
        return this.connectorName;
    }

    @Override
    @JsonProperty(value="connectorVersion")
    public String connectorVersion() {
        return this.connectorVersion;
    }

    @JsonProperty(value="connectorModes")
    public ImmutableList<ConnectorModes> connectorModes() {
        return this.connectorModes;
    }

    @Override
    @JsonProperty(value="authenticationConfig")
    @Nullable
    public AuthenticationConfig authenticationConfig() {
        return this.authenticationConfig;
    }

    @JsonProperty(value="connectorRuntimeSetting")
    @Nullable
    public ImmutableList<ConnectorRuntimeSetting> connectorRuntimeSetting() {
        return this.connectorRuntimeSetting;
    }

    @JsonProperty(value="supportedApiVersions")
    public ImmutableList<String> supportedApiVersions() {
        return this.supportedApiVersions;
    }

    @JsonProperty(value="operatorsSupported")
    public ImmutableList<ConnectorOperator> operatorsSupported() {
        InitShim shim = this.initShim;
        return shim != null ? shim.operatorsSupported() : this.operatorsSupported;
    }

    @JsonProperty(value="supportedTriggerTypes")
    public ImmutableList<TriggerType> supportedTriggerTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportedTriggerTypes() : this.supportedTriggerTypes;
    }

    @JsonProperty(value="triggerFrequenciesSupported")
    public ImmutableList<TriggerFrequency> triggerFrequenciesSupported() {
        InitShim shim = this.initShim;
        return shim != null ? shim.triggerFrequenciesSupported() : this.triggerFrequenciesSupported;
    }

    @JsonProperty(value="supportedWriteOperations")
    public ImmutableList<WriteOperationType> supportedWriteOperations() {
        InitShim shim = this.initShim;
        return shim != null ? shim.supportedWriteOperations() : this.supportedWriteOperations;
    }

    @Override
    @JsonProperty(value="logoURL")
    @Nullable
    public String logoURL() {
        return this.logoURL;
    }

    @Override
    @JsonProperty(value="isSuccess")
    public boolean isSuccess() {
        return this.isSuccess;
    }

    @Override
    @JsonProperty(value="errorDetails")
    @Nullable
    public ErrorDetails errorDetails() {
        return this.errorDetails;
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorOwner(String value) {
        String newValue = Objects.requireNonNull(value, "connectorOwner");
        if (this.connectorOwner.equals(newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(newValue, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorName(String value) {
        String newValue = Objects.requireNonNull(value, "connectorName");
        if (this.connectorName.equals(newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, newValue, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorVersion(String value) {
        String newValue = Objects.requireNonNull(value, "connectorVersion");
        if (this.connectorVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, newValue, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorModes(ConnectorModes ... elements) {
        ImmutableList<ConnectorModes> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, newValue, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorModes(Iterable<? extends ConnectorModes> elements) {
        if (this.connectorModes == elements) {
            return this;
        }
        ImmutableList<ConnectorModes> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, newValue, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withAuthenticationConfig(@Nullable AuthenticationConfig value) {
        if (this.authenticationConfig == value) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, value, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorRuntimeSetting(ConnectorRuntimeSetting ... elements) {
        if (elements == null) {
            return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, null, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
        }
        ImmutableList<ConnectorRuntimeSetting> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, newValue, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withConnectorRuntimeSetting(@Nullable Iterable<? extends ConnectorRuntimeSetting> elements) {
        if (this.connectorRuntimeSetting == elements) {
            return this;
        }
        ImmutableList<ConnectorRuntimeSetting> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, newValue, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedApiVersions(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, newValue, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedApiVersions(Iterable<String> elements) {
        if (this.supportedApiVersions == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, newValue, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withOperatorsSupported(ConnectorOperator ... elements) {
        ImmutableList<ConnectorOperator> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, newValue, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withOperatorsSupported(Iterable<? extends ConnectorOperator> elements) {
        if (this.operatorsSupported == elements) {
            return this;
        }
        ImmutableList<ConnectorOperator> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, newValue, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedTriggerTypes(TriggerType ... elements) {
        ImmutableList<TriggerType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, newValue, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedTriggerTypes(Iterable<? extends TriggerType> elements) {
        if (this.supportedTriggerTypes == elements) {
            return this;
        }
        ImmutableList<TriggerType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, newValue, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withTriggerFrequenciesSupported(TriggerFrequency ... elements) {
        ImmutableList<TriggerFrequency> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, newValue, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withTriggerFrequenciesSupported(Iterable<? extends TriggerFrequency> elements) {
        if (this.triggerFrequenciesSupported == elements) {
            return this;
        }
        ImmutableList<TriggerFrequency> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, newValue, this.supportedWriteOperations, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedWriteOperations(WriteOperationType ... elements) {
        ImmutableList<WriteOperationType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, newValue, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withSupportedWriteOperations(Iterable<? extends WriteOperationType> elements) {
        if (this.supportedWriteOperations == elements) {
            return this;
        }
        ImmutableList<WriteOperationType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, newValue, this.logoURL, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withLogoURL(@Nullable String value) {
        if (Objects.equals(this.logoURL, value)) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, value, this.isSuccess, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withIsSuccess(boolean value) {
        if (this.isSuccess == value) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, value, this.errorDetails);
    }

    public final ImmutableDescribeConnectorConfigurationResponse withErrorDetails(@Nullable ErrorDetails value) {
        if (this.errorDetails == value) {
            return this;
        }
        return new ImmutableDescribeConnectorConfigurationResponse(this.connectorOwner, this.connectorName, this.connectorVersion, this.connectorModes, this.authenticationConfig, this.connectorRuntimeSetting, this.supportedApiVersions, this.operatorsSupported, this.supportedTriggerTypes, this.triggerFrequenciesSupported, this.supportedWriteOperations, this.logoURL, this.isSuccess, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescribeConnectorConfigurationResponse && this.equalTo(0, (ImmutableDescribeConnectorConfigurationResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableDescribeConnectorConfigurationResponse another) {
        return this.connectorOwner.equals(another.connectorOwner) && this.connectorName.equals(another.connectorName) && this.connectorVersion.equals(another.connectorVersion) && this.connectorModes.equals(another.connectorModes) && Objects.equals(this.authenticationConfig, another.authenticationConfig) && Objects.equals(this.connectorRuntimeSetting, another.connectorRuntimeSetting) && this.supportedApiVersions.equals(another.supportedApiVersions) && this.operatorsSupported.equals(another.operatorsSupported) && this.supportedTriggerTypes.equals(another.supportedTriggerTypes) && this.triggerFrequenciesSupported.equals(another.triggerFrequenciesSupported) && this.supportedWriteOperations.equals(another.supportedWriteOperations) && Objects.equals(this.logoURL, another.logoURL) && this.isSuccess == another.isSuccess && Objects.equals(this.errorDetails, another.errorDetails);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.connectorOwner.hashCode();
        h2 += (h2 << 5) + this.connectorName.hashCode();
        h2 += (h2 << 5) + this.connectorVersion.hashCode();
        h2 += (h2 << 5) + this.connectorModes.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.authenticationConfig);
        h2 += (h2 << 5) + Objects.hashCode(this.connectorRuntimeSetting);
        h2 += (h2 << 5) + this.supportedApiVersions.hashCode();
        h2 += (h2 << 5) + this.operatorsSupported.hashCode();
        h2 += (h2 << 5) + this.supportedTriggerTypes.hashCode();
        h2 += (h2 << 5) + this.triggerFrequenciesSupported.hashCode();
        h2 += (h2 << 5) + this.supportedWriteOperations.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.logoURL);
        h2 += (h2 << 5) + Booleans.hashCode(this.isSuccess);
        h2 += (h2 << 5) + Objects.hashCode(this.errorDetails);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("DescribeConnectorConfigurationResponse").omitNullValues().add("connectorOwner", this.connectorOwner).add("connectorName", this.connectorName).add("connectorVersion", this.connectorVersion).add("connectorModes", this.connectorModes).add("authenticationConfig", this.authenticationConfig).add("connectorRuntimeSetting", this.connectorRuntimeSetting).add("supportedApiVersions", this.supportedApiVersions).add("operatorsSupported", this.operatorsSupported).add("supportedTriggerTypes", this.supportedTriggerTypes).add("triggerFrequenciesSupported", this.triggerFrequenciesSupported).add("supportedWriteOperations", this.supportedWriteOperations).add("logoURL", this.logoURL).add("isSuccess", this.isSuccess).add("errorDetails", this.errorDetails).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDescribeConnectorConfigurationResponse fromJson(Json json) {
        Builder builder = ImmutableDescribeConnectorConfigurationResponse.builder();
        if (json.connectorOwner != null) {
            builder.connectorOwner(json.connectorOwner);
        }
        if (json.connectorName != null) {
            builder.connectorName(json.connectorName);
        }
        if (json.connectorVersion != null) {
            builder.connectorVersion(json.connectorVersion);
        }
        if (json.connectorModes != null) {
            builder.addAllConnectorModes(json.connectorModes);
        }
        if (json.authenticationConfig != null) {
            builder.authenticationConfig(json.authenticationConfig);
        }
        if (json.connectorRuntimeSetting != null) {
            builder.addAllConnectorRuntimeSetting(json.connectorRuntimeSetting);
        }
        if (json.supportedApiVersions != null) {
            builder.addAllSupportedApiVersions(json.supportedApiVersions);
        }
        if (json.operatorsSupportedIsSet) {
            builder.addAllOperatorsSupported(json.operatorsSupported);
        }
        if (json.supportedTriggerTypesIsSet) {
            builder.addAllSupportedTriggerTypes(json.supportedTriggerTypes);
        }
        if (json.triggerFrequenciesSupportedIsSet) {
            builder.addAllTriggerFrequenciesSupported(json.triggerFrequenciesSupported);
        }
        if (json.supportedWriteOperationsIsSet) {
            builder.addAllSupportedWriteOperations(json.supportedWriteOperations);
        }
        if (json.logoURL != null) {
            builder.logoURL(json.logoURL);
        }
        if (json.isSuccessIsSet) {
            builder.isSuccess(json.isSuccess);
        }
        if (json.errorDetails != null) {
            builder.errorDetails(json.errorDetails);
        }
        return builder.build();
    }

    public static ImmutableDescribeConnectorConfigurationResponse copyOf(DescribeConnectorConfigurationResponse instance) {
        if (instance instanceof ImmutableDescribeConnectorConfigurationResponse) {
            return (ImmutableDescribeConnectorConfigurationResponse)instance;
        }
        return ImmutableDescribeConnectorConfigurationResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DescribeConnectorConfigurationResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONNECTOR_OWNER = 1L;
        private static final long INIT_BIT_CONNECTOR_NAME = 2L;
        private static final long INIT_BIT_CONNECTOR_VERSION = 4L;
        private static final long INIT_BIT_IS_SUCCESS = 8L;
        private static final long OPT_BIT_OPERATORS_SUPPORTED = 1L;
        private static final long OPT_BIT_SUPPORTED_TRIGGER_TYPES = 2L;
        private static final long OPT_BIT_TRIGGER_FREQUENCIES_SUPPORTED = 4L;
        private static final long OPT_BIT_SUPPORTED_WRITE_OPERATIONS = 8L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private String connectorOwner;
        @Nullable
        private String connectorName;
        @Nullable
        private String connectorVersion;
        private ImmutableList.Builder<ConnectorModes> connectorModes = ImmutableList.builder();
        @Nullable
        private AuthenticationConfig authenticationConfig;
        private ImmutableList.Builder<ConnectorRuntimeSetting> connectorRuntimeSetting = null;
        private ImmutableList.Builder<String> supportedApiVersions = ImmutableList.builder();
        private ImmutableList.Builder<ConnectorOperator> operatorsSupported = ImmutableList.builder();
        private ImmutableList.Builder<TriggerType> supportedTriggerTypes = ImmutableList.builder();
        private ImmutableList.Builder<TriggerFrequency> triggerFrequenciesSupported = ImmutableList.builder();
        private ImmutableList.Builder<WriteOperationType> supportedWriteOperations = ImmutableList.builder();
        @Nullable
        private String logoURL;
        private boolean isSuccess;
        @Nullable
        private ErrorDetails errorDetails;

        private Builder() {
        }

        public final Builder from(DescribeConnectorConfigurationResponse instance) {
            List<ConnectorRuntimeSetting> connectorRuntimeSettingValue;
            Objects.requireNonNull(instance, "instance");
            this.connectorOwner(instance.connectorOwner());
            this.connectorName(instance.connectorName());
            this.connectorVersion(instance.connectorVersion());
            this.addAllConnectorModes(instance.connectorModes());
            AuthenticationConfig authenticationConfigValue = instance.authenticationConfig();
            if (authenticationConfigValue != null) {
                this.authenticationConfig(authenticationConfigValue);
            }
            if ((connectorRuntimeSettingValue = instance.connectorRuntimeSetting()) != null) {
                this.addAllConnectorRuntimeSetting(connectorRuntimeSettingValue);
            }
            this.addAllSupportedApiVersions(instance.supportedApiVersions());
            this.addAllOperatorsSupported(instance.operatorsSupported());
            this.addAllSupportedTriggerTypes(instance.supportedTriggerTypes());
            this.addAllTriggerFrequenciesSupported(instance.triggerFrequenciesSupported());
            this.addAllSupportedWriteOperations(instance.supportedWriteOperations());
            String logoURLValue = instance.logoURL();
            if (logoURLValue != null) {
                this.logoURL(logoURLValue);
            }
            this.isSuccess(instance.isSuccess());
            ErrorDetails errorDetailsValue = instance.errorDetails();
            if (errorDetailsValue != null) {
                this.errorDetails(errorDetailsValue);
            }
            return this;
        }

        @JsonProperty(value="connectorOwner")
        public final Builder connectorOwner(String connectorOwner) {
            this.connectorOwner = Objects.requireNonNull(connectorOwner, "connectorOwner");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="connectorName")
        public final Builder connectorName(String connectorName) {
            this.connectorName = Objects.requireNonNull(connectorName, "connectorName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="connectorVersion")
        public final Builder connectorVersion(String connectorVersion) {
            this.connectorVersion = Objects.requireNonNull(connectorVersion, "connectorVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addConnectorModes(ConnectorModes element) {
            this.connectorModes.add((Object)element);
            return this;
        }

        public final Builder addConnectorModes(ConnectorModes ... elements) {
            this.connectorModes.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="connectorModes")
        public final Builder connectorModes(Iterable<? extends ConnectorModes> elements) {
            this.connectorModes = ImmutableList.builder();
            return this.addAllConnectorModes(elements);
        }

        public final Builder addAllConnectorModes(Iterable<? extends ConnectorModes> elements) {
            this.connectorModes.addAll(elements);
            return this;
        }

        @JsonProperty(value="authenticationConfig")
        public final Builder authenticationConfig(@Nullable AuthenticationConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
            return this;
        }

        public final Builder addConnectorRuntimeSetting(ConnectorRuntimeSetting element) {
            if (this.connectorRuntimeSetting == null) {
                this.connectorRuntimeSetting = ImmutableList.builder();
            }
            this.connectorRuntimeSetting.add((Object)element);
            return this;
        }

        public final Builder addConnectorRuntimeSetting(ConnectorRuntimeSetting ... elements) {
            if (this.connectorRuntimeSetting == null) {
                this.connectorRuntimeSetting = ImmutableList.builder();
            }
            this.connectorRuntimeSetting.add(elements);
            return this;
        }

        @JsonProperty(value="connectorRuntimeSetting")
        public final Builder connectorRuntimeSetting(@Nullable Iterable<? extends ConnectorRuntimeSetting> elements) {
            if (elements == null) {
                this.connectorRuntimeSetting = null;
                return this;
            }
            this.connectorRuntimeSetting = ImmutableList.builder();
            return this.addAllConnectorRuntimeSetting(elements);
        }

        public final Builder addAllConnectorRuntimeSetting(Iterable<? extends ConnectorRuntimeSetting> elements) {
            Objects.requireNonNull(elements, "connectorRuntimeSetting element");
            if (this.connectorRuntimeSetting == null) {
                this.connectorRuntimeSetting = ImmutableList.builder();
            }
            this.connectorRuntimeSetting.addAll(elements);
            return this;
        }

        public final Builder addSupportedApiVersions(String element) {
            this.supportedApiVersions.add((Object)element);
            return this;
        }

        public final Builder addSupportedApiVersions(String ... elements) {
            this.supportedApiVersions.add(elements);
            return this;
        }

        @JsonProperty(value="supportedApiVersions")
        public final Builder supportedApiVersions(Iterable<String> elements) {
            this.supportedApiVersions = ImmutableList.builder();
            return this.addAllSupportedApiVersions(elements);
        }

        public final Builder addAllSupportedApiVersions(Iterable<String> elements) {
            this.supportedApiVersions.addAll((Iterable)elements);
            return this;
        }

        public final Builder addOperatorsSupported(ConnectorOperator element) {
            this.operatorsSupported.add((Object)element);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addOperatorsSupported(ConnectorOperator ... elements) {
            this.operatorsSupported.add((Object[])elements);
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="operatorsSupported")
        public final Builder operatorsSupported(Iterable<? extends ConnectorOperator> elements) {
            this.operatorsSupported = ImmutableList.builder();
            return this.addAllOperatorsSupported(elements);
        }

        public final Builder addAllOperatorsSupported(Iterable<? extends ConnectorOperator> elements) {
            this.operatorsSupported.addAll(elements);
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSupportedTriggerTypes(TriggerType element) {
            this.supportedTriggerTypes.add((Object)element);
            this.optBits |= 2L;
            return this;
        }

        public final Builder addSupportedTriggerTypes(TriggerType ... elements) {
            this.supportedTriggerTypes.add((Object[])elements);
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="supportedTriggerTypes")
        public final Builder supportedTriggerTypes(Iterable<? extends TriggerType> elements) {
            this.supportedTriggerTypes = ImmutableList.builder();
            return this.addAllSupportedTriggerTypes(elements);
        }

        public final Builder addAllSupportedTriggerTypes(Iterable<? extends TriggerType> elements) {
            this.supportedTriggerTypes.addAll(elements);
            this.optBits |= 2L;
            return this;
        }

        public final Builder addTriggerFrequenciesSupported(TriggerFrequency element) {
            this.triggerFrequenciesSupported.add((Object)element);
            this.optBits |= 4L;
            return this;
        }

        public final Builder addTriggerFrequenciesSupported(TriggerFrequency ... elements) {
            this.triggerFrequenciesSupported.add((Object[])elements);
            this.optBits |= 4L;
            return this;
        }

        @JsonProperty(value="triggerFrequenciesSupported")
        public final Builder triggerFrequenciesSupported(Iterable<? extends TriggerFrequency> elements) {
            this.triggerFrequenciesSupported = ImmutableList.builder();
            return this.addAllTriggerFrequenciesSupported(elements);
        }

        public final Builder addAllTriggerFrequenciesSupported(Iterable<? extends TriggerFrequency> elements) {
            this.triggerFrequenciesSupported.addAll(elements);
            this.optBits |= 4L;
            return this;
        }

        public final Builder addSupportedWriteOperations(WriteOperationType element) {
            this.supportedWriteOperations.add((Object)element);
            this.optBits |= 8L;
            return this;
        }

        public final Builder addSupportedWriteOperations(WriteOperationType ... elements) {
            this.supportedWriteOperations.add((Object[])elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="supportedWriteOperations")
        public final Builder supportedWriteOperations(Iterable<? extends WriteOperationType> elements) {
            this.supportedWriteOperations = ImmutableList.builder();
            return this.addAllSupportedWriteOperations(elements);
        }

        public final Builder addAllSupportedWriteOperations(Iterable<? extends WriteOperationType> elements) {
            this.supportedWriteOperations.addAll(elements);
            this.optBits |= 8L;
            return this;
        }

        @JsonProperty(value="logoURL")
        public final Builder logoURL(@Nullable String logoURL) {
            this.logoURL = logoURL;
            return this;
        }

        @JsonProperty(value="isSuccess")
        public final Builder isSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="errorDetails")
        public final Builder errorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public ImmutableDescribeConnectorConfigurationResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDescribeConnectorConfigurationResponse(this);
        }

        private boolean operatorsSupportedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean supportedTriggerTypesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean triggerFrequenciesSupportedIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean supportedWriteOperationsIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectorOwner");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("connectorName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("connectorVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("isSuccess");
            }
            return "Cannot build DescribeConnectorConfigurationResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DescribeConnectorConfigurationResponse", generator="Immutables")
    static final class Json
    implements DescribeConnectorConfigurationResponse {
        @Nullable
        String connectorOwner;
        @Nullable
        String connectorName;
        @Nullable
        String connectorVersion;
        @Nullable
        List<ConnectorModes> connectorModes = ImmutableList.of();
        @Nullable
        AuthenticationConfig authenticationConfig;
        @Nullable
        List<ConnectorRuntimeSetting> connectorRuntimeSetting = null;
        @Nullable
        List<String> supportedApiVersions = ImmutableList.of();
        @Nullable
        List<ConnectorOperator> operatorsSupported = ImmutableList.of();
        boolean operatorsSupportedIsSet;
        @Nullable
        List<TriggerType> supportedTriggerTypes = ImmutableList.of();
        boolean supportedTriggerTypesIsSet;
        @Nullable
        List<TriggerFrequency> triggerFrequenciesSupported = ImmutableList.of();
        boolean triggerFrequenciesSupportedIsSet;
        @Nullable
        List<WriteOperationType> supportedWriteOperations = ImmutableList.of();
        boolean supportedWriteOperationsIsSet;
        @Nullable
        String logoURL;
        boolean isSuccess;
        boolean isSuccessIsSet;
        @Nullable
        ErrorDetails errorDetails;

        Json() {
        }

        @JsonProperty(value="connectorOwner")
        public void setConnectorOwner(String connectorOwner) {
            this.connectorOwner = connectorOwner;
        }

        @JsonProperty(value="connectorName")
        public void setConnectorName(String connectorName) {
            this.connectorName = connectorName;
        }

        @JsonProperty(value="connectorVersion")
        public void setConnectorVersion(String connectorVersion) {
            this.connectorVersion = connectorVersion;
        }

        @JsonProperty(value="connectorModes")
        public void setConnectorModes(List<ConnectorModes> connectorModes) {
            this.connectorModes = connectorModes;
        }

        @JsonProperty(value="authenticationConfig")
        public void setAuthenticationConfig(@Nullable AuthenticationConfig authenticationConfig) {
            this.authenticationConfig = authenticationConfig;
        }

        @JsonProperty(value="connectorRuntimeSetting")
        public void setConnectorRuntimeSetting(@Nullable List<ConnectorRuntimeSetting> connectorRuntimeSetting) {
            this.connectorRuntimeSetting = connectorRuntimeSetting;
        }

        @JsonProperty(value="supportedApiVersions")
        public void setSupportedApiVersions(List<String> supportedApiVersions) {
            this.supportedApiVersions = supportedApiVersions;
        }

        @JsonProperty(value="operatorsSupported")
        public void setOperatorsSupported(List<ConnectorOperator> operatorsSupported) {
            this.operatorsSupported = operatorsSupported;
            this.operatorsSupportedIsSet = true;
        }

        @JsonProperty(value="supportedTriggerTypes")
        public void setSupportedTriggerTypes(List<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = supportedTriggerTypes;
            this.supportedTriggerTypesIsSet = true;
        }

        @JsonProperty(value="triggerFrequenciesSupported")
        public void setTriggerFrequenciesSupported(List<TriggerFrequency> triggerFrequenciesSupported) {
            this.triggerFrequenciesSupported = triggerFrequenciesSupported;
            this.triggerFrequenciesSupportedIsSet = true;
        }

        @JsonProperty(value="supportedWriteOperations")
        public void setSupportedWriteOperations(List<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = supportedWriteOperations;
            this.supportedWriteOperationsIsSet = true;
        }

        @JsonProperty(value="logoURL")
        public void setLogoURL(@Nullable String logoURL) {
            this.logoURL = logoURL;
        }

        @JsonProperty(value="isSuccess")
        public void setIsSuccess(boolean isSuccess) {
            this.isSuccess = isSuccess;
            this.isSuccessIsSet = true;
        }

        @JsonProperty(value="errorDetails")
        public void setErrorDetails(@Nullable ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
        }

        @Override
        public String connectorOwner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String connectorName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String connectorVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConnectorModes> connectorModes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AuthenticationConfig authenticationConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConnectorRuntimeSetting> connectorRuntimeSetting() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> supportedApiVersions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ConnectorOperator> operatorsSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TriggerType> supportedTriggerTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<TriggerFrequency> triggerFrequenciesSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<WriteOperationType> supportedWriteOperations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String logoURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSuccess() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ErrorDetails errorDetails() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="DescribeConnectorConfigurationResponse", generator="Immutables")
    private final class InitShim {
        private byte operatorsSupportedBuildStage = 0;
        private ImmutableList<ConnectorOperator> operatorsSupported;
        private byte supportedTriggerTypesBuildStage = 0;
        private ImmutableList<TriggerType> supportedTriggerTypes;
        private byte triggerFrequenciesSupportedBuildStage = 0;
        private ImmutableList<TriggerFrequency> triggerFrequenciesSupported;
        private byte supportedWriteOperationsBuildStage = 0;
        private ImmutableList<WriteOperationType> supportedWriteOperations;

        private InitShim() {
        }

        ImmutableList<ConnectorOperator> operatorsSupported() {
            if (this.operatorsSupportedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.operatorsSupportedBuildStage == 0) {
                this.operatorsSupportedBuildStage = (byte)-1;
                this.operatorsSupported = ImmutableList.copyOf(ImmutableDescribeConnectorConfigurationResponse.this.operatorsSupportedInitialize());
                this.operatorsSupportedBuildStage = 1;
            }
            return this.operatorsSupported;
        }

        void operatorsSupported(ImmutableList<ConnectorOperator> operatorsSupported) {
            this.operatorsSupported = operatorsSupported;
            this.operatorsSupportedBuildStage = 1;
        }

        ImmutableList<TriggerType> supportedTriggerTypes() {
            if (this.supportedTriggerTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportedTriggerTypesBuildStage == 0) {
                this.supportedTriggerTypesBuildStage = (byte)-1;
                this.supportedTriggerTypes = ImmutableList.copyOf(ImmutableDescribeConnectorConfigurationResponse.this.supportedTriggerTypesInitialize());
                this.supportedTriggerTypesBuildStage = 1;
            }
            return this.supportedTriggerTypes;
        }

        void supportedTriggerTypes(ImmutableList<TriggerType> supportedTriggerTypes) {
            this.supportedTriggerTypes = supportedTriggerTypes;
            this.supportedTriggerTypesBuildStage = 1;
        }

        ImmutableList<TriggerFrequency> triggerFrequenciesSupported() {
            if (this.triggerFrequenciesSupportedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.triggerFrequenciesSupportedBuildStage == 0) {
                this.triggerFrequenciesSupportedBuildStage = (byte)-1;
                this.triggerFrequenciesSupported = ImmutableList.copyOf(ImmutableDescribeConnectorConfigurationResponse.this.triggerFrequenciesSupportedInitialize());
                this.triggerFrequenciesSupportedBuildStage = 1;
            }
            return this.triggerFrequenciesSupported;
        }

        void triggerFrequenciesSupported(ImmutableList<TriggerFrequency> triggerFrequenciesSupported) {
            this.triggerFrequenciesSupported = triggerFrequenciesSupported;
            this.triggerFrequenciesSupportedBuildStage = 1;
        }

        ImmutableList<WriteOperationType> supportedWriteOperations() {
            if (this.supportedWriteOperationsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.supportedWriteOperationsBuildStage == 0) {
                this.supportedWriteOperationsBuildStage = (byte)-1;
                this.supportedWriteOperations = ImmutableList.copyOf(ImmutableDescribeConnectorConfigurationResponse.this.supportedWriteOperationsInitialize());
                this.supportedWriteOperationsBuildStage = 1;
            }
            return this.supportedWriteOperations;
        }

        void supportedWriteOperations(ImmutableList<WriteOperationType> supportedWriteOperations) {
            this.supportedWriteOperations = supportedWriteOperations;
            this.supportedWriteOperationsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.operatorsSupportedBuildStage == -1) {
                attributes.add("operatorsSupported");
            }
            if (this.supportedTriggerTypesBuildStage == -1) {
                attributes.add("supportedTriggerTypes");
            }
            if (this.triggerFrequenciesSupportedBuildStage == -1) {
                attributes.add("triggerFrequenciesSupported");
            }
            if (this.supportedWriteOperationsBuildStage == -1) {
                attributes.add("supportedWriteOperations");
            }
            return "Cannot build DescribeConnectorConfigurationResponse, attribute initializers form cycle " + attributes;
        }
    }
}

