/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.providers;

import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorProfileConfiguration;
import com.amazonaws.appflow.custom.connector.integ.providers.AuthenticationType;
import com.amazonaws.appflow.custom.connector.integ.providers.ServiceProvider;
import com.amazonaws.appflow.custom.connector.integ.util.ConfigurationUtil;
import com.amazonaws.services.appflow.model.ApiKeyCredentials;
import com.amazonaws.services.appflow.model.BasicAuthCredentials;
import com.amazonaws.services.appflow.model.CustomAuthCredentials;
import com.amazonaws.services.appflow.model.CustomConnectorProfileCredentials;
import com.amazonaws.services.appflow.model.OAuth2Credentials;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import com.fasterxml.jackson.core.JsonProcessingException;

public final class CredentialsProvider {
    private CredentialsProvider() {
    }

    public static CustomConnectorProfileCredentials getCustomConnectorProfileCredentials(CustomConnectorProfileConfiguration profileConfiguration) {
        CustomConnectorProfileCredentials customConnectorProfileCredentials = new CustomConnectorProfileCredentials();
        if (profileConfiguration.authenticationType().equals((Object)AuthenticationType.NO_AUTH) || !profileConfiguration.secretsManagerArn().isPresent()) {
            return customConnectorProfileCredentials;
        }
        AWSSecretsManager secretsManager = ServiceProvider.getSecretsManager();
        GetSecretValueResult secretValueResult = secretsManager.getSecretValue(new GetSecretValueRequest().withSecretId(profileConfiguration.secretsManagerArn().get()));
        try {
            switch (profileConfiguration.authenticationType()) {
                case API_KEY: {
                    return customConnectorProfileCredentials.withAuthenticationType(com.amazonaws.services.appflow.model.AuthenticationType.APIKEY).withApiKey(ConfigurationUtil.OBJECT_MAPPER.readValue(secretValueResult.getSecretString(), ApiKeyCredentials.class));
                }
                case BASIC: {
                    return customConnectorProfileCredentials.withAuthenticationType(com.amazonaws.services.appflow.model.AuthenticationType.BASIC).withBasic(ConfigurationUtil.OBJECT_MAPPER.readValue(secretValueResult.getSecretString(), BasicAuthCredentials.class));
                }
                case OAUTH2: {
                    return customConnectorProfileCredentials.withAuthenticationType(com.amazonaws.services.appflow.model.AuthenticationType.OAUTH2).withOauth2(ConfigurationUtil.OBJECT_MAPPER.readValue(secretValueResult.getSecretString(), OAuth2Credentials.class));
                }
                case CUSTOM: {
                    return customConnectorProfileCredentials.withAuthenticationType(com.amazonaws.services.appflow.model.AuthenticationType.CUSTOM).withCustom(ConfigurationUtil.OBJECT_MAPPER.readValue(secretValueResult.getSecretString(), CustomAuthCredentials.class));
                }
            }
            throw new IllegalStateException("AuthenticationType is not defined");
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Unable to Serialize secrets value. Secret String must be a valid json");
        }
    }
}

