/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.data;

import com.amazonaws.appflow.custom.connector.integ.data.TestBucketConfiguration;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TestBucketConfiguration", generator="Immutables")
@Immutable
public final class ImmutableTestBucketConfiguration
implements TestBucketConfiguration {
    private final String bucketName;
    private final String bucketPrefix;

    private ImmutableTestBucketConfiguration(String bucketName, String bucketPrefix) {
        this.bucketName = bucketName;
        this.bucketPrefix = bucketPrefix;
    }

    @Override
    @JsonProperty(value="bucketName")
    public String bucketName() {
        return this.bucketName;
    }

    @Override
    @JsonProperty(value="bucketPrefix")
    public String bucketPrefix() {
        return this.bucketPrefix;
    }

    public final ImmutableTestBucketConfiguration withBucketName(String value) {
        String newValue = Objects.requireNonNull(value, "bucketName");
        if (this.bucketName.equals(newValue)) {
            return this;
        }
        return new ImmutableTestBucketConfiguration(newValue, this.bucketPrefix);
    }

    public final ImmutableTestBucketConfiguration withBucketPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "bucketPrefix");
        if (this.bucketPrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableTestBucketConfiguration(this.bucketName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTestBucketConfiguration && this.equalTo(0, (ImmutableTestBucketConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableTestBucketConfiguration another) {
        return this.bucketName.equals(another.bucketName) && this.bucketPrefix.equals(another.bucketPrefix);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.bucketName.hashCode();
        h2 += (h2 << 5) + this.bucketPrefix.hashCode();
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("TestBucketConfiguration").omitNullValues().add("bucketName", this.bucketName).add("bucketPrefix", this.bucketPrefix).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTestBucketConfiguration fromJson(Json json) {
        Builder builder = ImmutableTestBucketConfiguration.builder();
        if (json.bucketName != null) {
            builder.bucketName(json.bucketName);
        }
        if (json.bucketPrefix != null) {
            builder.bucketPrefix(json.bucketPrefix);
        }
        return builder.build();
    }

    public static ImmutableTestBucketConfiguration copyOf(TestBucketConfiguration instance) {
        if (instance instanceof ImmutableTestBucketConfiguration) {
            return (ImmutableTestBucketConfiguration)instance;
        }
        return ImmutableTestBucketConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TestBucketConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BUCKET_NAME = 1L;
        private static final long INIT_BIT_BUCKET_PREFIX = 2L;
        private long initBits = 3L;
        @Nullable
        private String bucketName;
        @Nullable
        private String bucketPrefix;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TestBucketConfiguration instance) {
            Objects.requireNonNull(instance, "instance");
            this.bucketName(instance.bucketName());
            this.bucketPrefix(instance.bucketPrefix());
            return this;
        }

        @JsonProperty(value="bucketName")
        @CanIgnoreReturnValue
        public final Builder bucketName(String bucketName) {
            this.bucketName = Objects.requireNonNull(bucketName, "bucketName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="bucketPrefix")
        @CanIgnoreReturnValue
        public final Builder bucketPrefix(String bucketPrefix) {
            this.bucketPrefix = Objects.requireNonNull(bucketPrefix, "bucketPrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableTestBucketConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTestBucketConfiguration(this.bucketName, this.bucketPrefix);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("bucketName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("bucketPrefix");
            }
            return "Cannot build TestBucketConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TestBucketConfiguration", generator="Immutables")
    static final class Json
    implements TestBucketConfiguration {
        @Nullable
        String bucketName;
        @Nullable
        String bucketPrefix;

        Json() {
        }

        @JsonProperty(value="bucketName")
        public void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        @JsonProperty(value="bucketPrefix")
        public void setBucketPrefix(String bucketPrefix) {
            this.bucketPrefix = bucketPrefix;
        }

        @Override
        public String bucketName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String bucketPrefix() {
            throw new UnsupportedOperationException();
        }
    }
}

