/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.data;

import com.amazonaws.appflow.custom.connector.integ.data.CustomConnectorProfileConfiguration;
import com.amazonaws.appflow.custom.connector.integ.providers.AuthenticationType;
import com.amazonaws.services.appflow.model.OAuth2Properties;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CustomConnectorProfileConfiguration", generator="Immutables")
@Immutable
public final class ImmutableCustomConnectorProfileConfiguration
implements CustomConnectorProfileConfiguration {
    @Nullable
    private final String secretsManagerArn;
    private final String name;
    @Nullable
    private final OAuth2Properties oAuth2Properties;
    @Nullable
    private final String connectorName;
    @Nullable
    private final Map<String, String> profileProperties;
    private final AuthenticationType authenticationType;
    @Nullable
    private final String defaultApiVersion;

    private ImmutableCustomConnectorProfileConfiguration(@Nullable String secretsManagerArn, String name, @Nullable OAuth2Properties oAuth2Properties, @Nullable String connectorName, @Nullable Map<String, String> profileProperties, AuthenticationType authenticationType, @Nullable String defaultApiVersion) {
        this.secretsManagerArn = secretsManagerArn;
        this.name = name;
        this.oAuth2Properties = oAuth2Properties;
        this.connectorName = connectorName;
        this.profileProperties = profileProperties;
        this.authenticationType = authenticationType;
        this.defaultApiVersion = defaultApiVersion;
    }

    @Override
    @JsonProperty(value="secretsManagerArn")
    public Optional<String> secretsManagerArn() {
        return Optional.ofNullable(this.secretsManagerArn);
    }

    @Override
    @JsonProperty(value="name")
    public String name() {
        return this.name;
    }

    @Override
    @JsonProperty(value="oAuth2Properties")
    public Optional<OAuth2Properties> oAuth2Properties() {
        return Optional.ofNullable(this.oAuth2Properties);
    }

    @Override
    @JsonProperty(value="connectorName")
    public Optional<String> connectorName() {
        return Optional.ofNullable(this.connectorName);
    }

    @Override
    @JsonProperty(value="profileProperties")
    public Optional<Map<String, String>> profileProperties() {
        return Optional.ofNullable(this.profileProperties);
    }

    @Override
    @JsonProperty(value="authenticationType")
    public AuthenticationType authenticationType() {
        return this.authenticationType;
    }

    @Override
    @JsonProperty(value="defaultApiVersion")
    public Optional<String> defaultApiVersion() {
        return Optional.ofNullable(this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withSecretsManagerArn(String value) {
        String newValue = Objects.requireNonNull(value, "secretsManagerArn");
        if (Objects.equals(this.secretsManagerArn, newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(newValue, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withSecretsManagerArn(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.secretsManagerArn, value)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(value, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, newValue, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withOAuth2Properties(OAuth2Properties value) {
        OAuth2Properties newValue = Objects.requireNonNull(value, "oAuth2Properties");
        if (this.oAuth2Properties == newValue) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, newValue, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withOAuth2Properties(Optional<? extends OAuth2Properties> optional) {
        OAuth2Properties value = optional.orElse(null);
        if (this.oAuth2Properties == value) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, value, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withConnectorName(String value) {
        String newValue = Objects.requireNonNull(value, "connectorName");
        if (Objects.equals(this.connectorName, newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, newValue, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withConnectorName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.connectorName, value)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, value, this.profileProperties, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withProfileProperties(Map<String, String> value) {
        Map<String, String> newValue = Objects.requireNonNull(value, "profileProperties");
        if (this.profileProperties == newValue) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, newValue, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withProfileProperties(Optional<? extends Map<String, String>> optional) {
        Map value = optional.orElse(null);
        if (this.profileProperties == value) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, value, this.authenticationType, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withAuthenticationType(AuthenticationType value) {
        AuthenticationType newValue = Objects.requireNonNull(value, "authenticationType");
        if (this.authenticationType == newValue) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, newValue, this.defaultApiVersion);
    }

    public final ImmutableCustomConnectorProfileConfiguration withDefaultApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "defaultApiVersion");
        if (Objects.equals(this.defaultApiVersion, newValue)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, newValue);
    }

    public final ImmutableCustomConnectorProfileConfiguration withDefaultApiVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.defaultApiVersion, value)) {
            return this;
        }
        return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomConnectorProfileConfiguration && this.equalTo(0, (ImmutableCustomConnectorProfileConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomConnectorProfileConfiguration another) {
        return Objects.equals(this.secretsManagerArn, another.secretsManagerArn) && this.name.equals(another.name) && Objects.equals(this.oAuth2Properties, another.oAuth2Properties) && Objects.equals(this.connectorName, another.connectorName) && Objects.equals(this.profileProperties, another.profileProperties) && this.authenticationType.equals((Object)another.authenticationType) && Objects.equals(this.defaultApiVersion, another.defaultApiVersion);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.secretsManagerArn);
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.oAuth2Properties);
        h2 += (h2 << 5) + Objects.hashCode(this.connectorName);
        h2 += (h2 << 5) + Objects.hashCode(this.profileProperties);
        h2 += (h2 << 5) + this.authenticationType.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.defaultApiVersion);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("CustomConnectorProfileConfiguration").omitNullValues().add("secretsManagerArn", this.secretsManagerArn).add("name", this.name).add("oAuth2Properties", this.oAuth2Properties).add("connectorName", this.connectorName).add("profileProperties", this.profileProperties).add("authenticationType", (Object)this.authenticationType).add("defaultApiVersion", this.defaultApiVersion).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCustomConnectorProfileConfiguration fromJson(Json json) {
        Builder builder = ImmutableCustomConnectorProfileConfiguration.builder();
        if (json.secretsManagerArn != null) {
            builder.secretsManagerArn(json.secretsManagerArn);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.oAuth2Properties != null) {
            builder.oAuth2Properties(json.oAuth2Properties);
        }
        if (json.connectorName != null) {
            builder.connectorName(json.connectorName);
        }
        if (json.profileProperties != null) {
            builder.profileProperties(json.profileProperties);
        }
        if (json.authenticationType != null) {
            builder.authenticationType(json.authenticationType);
        }
        if (json.defaultApiVersion != null) {
            builder.defaultApiVersion(json.defaultApiVersion);
        }
        return builder.build();
    }

    public static ImmutableCustomConnectorProfileConfiguration copyOf(CustomConnectorProfileConfiguration instance) {
        if (instance instanceof ImmutableCustomConnectorProfileConfiguration) {
            return (ImmutableCustomConnectorProfileConfiguration)instance;
        }
        return ImmutableCustomConnectorProfileConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomConnectorProfileConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_AUTHENTICATION_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private String secretsManagerArn;
        @Nullable
        private String name;
        @Nullable
        private OAuth2Properties oAuth2Properties;
        @Nullable
        private String connectorName;
        @Nullable
        private Map<String, String> profileProperties;
        @Nullable
        private AuthenticationType authenticationType;
        @Nullable
        private String defaultApiVersion;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CustomConnectorProfileConfiguration instance) {
            Optional<Map<String, String>> profilePropertiesOptional;
            Optional<String> connectorNameOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> secretsManagerArnOptional = instance.secretsManagerArn();
            if (secretsManagerArnOptional.isPresent()) {
                this.secretsManagerArn(secretsManagerArnOptional);
            }
            this.name(instance.name());
            Optional<OAuth2Properties> oAuth2PropertiesOptional = instance.oAuth2Properties();
            if (oAuth2PropertiesOptional.isPresent()) {
                this.oAuth2Properties(oAuth2PropertiesOptional);
            }
            if ((connectorNameOptional = instance.connectorName()).isPresent()) {
                this.connectorName(connectorNameOptional);
            }
            if ((profilePropertiesOptional = instance.profileProperties()).isPresent()) {
                this.profileProperties(profilePropertiesOptional);
            }
            this.authenticationType(instance.authenticationType());
            Optional<String> defaultApiVersionOptional = instance.defaultApiVersion();
            if (defaultApiVersionOptional.isPresent()) {
                this.defaultApiVersion(defaultApiVersionOptional);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secretsManagerArn(String secretsManagerArn) {
            this.secretsManagerArn = Objects.requireNonNull(secretsManagerArn, "secretsManagerArn");
            return this;
        }

        @JsonProperty(value="secretsManagerArn")
        @CanIgnoreReturnValue
        public final Builder secretsManagerArn(Optional<String> secretsManagerArn) {
            this.secretsManagerArn = secretsManagerArn.orElse(null);
            return this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder oAuth2Properties(OAuth2Properties oAuth2Properties) {
            this.oAuth2Properties = Objects.requireNonNull(oAuth2Properties, "oAuth2Properties");
            return this;
        }

        @JsonProperty(value="oAuth2Properties")
        @CanIgnoreReturnValue
        public final Builder oAuth2Properties(Optional<? extends OAuth2Properties> oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder connectorName(String connectorName) {
            this.connectorName = Objects.requireNonNull(connectorName, "connectorName");
            return this;
        }

        @JsonProperty(value="connectorName")
        @CanIgnoreReturnValue
        public final Builder connectorName(Optional<String> connectorName) {
            this.connectorName = connectorName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder profileProperties(Map<String, String> profileProperties) {
            this.profileProperties = Objects.requireNonNull(profileProperties, "profileProperties");
            return this;
        }

        @JsonProperty(value="profileProperties")
        @CanIgnoreReturnValue
        public final Builder profileProperties(Optional<? extends Map<String, String>> profileProperties) {
            this.profileProperties = profileProperties.orElse(null);
            return this;
        }

        @JsonProperty(value="authenticationType")
        @CanIgnoreReturnValue
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = Objects.requireNonNull(authenticationType, "authenticationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultApiVersion(String defaultApiVersion) {
            this.defaultApiVersion = Objects.requireNonNull(defaultApiVersion, "defaultApiVersion");
            return this;
        }

        @JsonProperty(value="defaultApiVersion")
        @CanIgnoreReturnValue
        public final Builder defaultApiVersion(Optional<String> defaultApiVersion) {
            this.defaultApiVersion = defaultApiVersion.orElse(null);
            return this;
        }

        public ImmutableCustomConnectorProfileConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomConnectorProfileConfiguration(this.secretsManagerArn, this.name, this.oAuth2Properties, this.connectorName, this.profileProperties, this.authenticationType, this.defaultApiVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authenticationType");
            }
            return "Cannot build CustomConnectorProfileConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CustomConnectorProfileConfiguration", generator="Immutables")
    static final class Json
    implements CustomConnectorProfileConfiguration {
        @Nullable
        Optional<String> secretsManagerArn = Optional.empty();
        @Nullable
        String name;
        @Nullable
        Optional<OAuth2Properties> oAuth2Properties = Optional.empty();
        @Nullable
        Optional<String> connectorName = Optional.empty();
        @Nullable
        Optional<Map<String, String>> profileProperties = Optional.empty();
        @Nullable
        AuthenticationType authenticationType;
        @Nullable
        Optional<String> defaultApiVersion = Optional.empty();

        Json() {
        }

        @JsonProperty(value="secretsManagerArn")
        public void setSecretsManagerArn(Optional<String> secretsManagerArn) {
            this.secretsManagerArn = secretsManagerArn;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="oAuth2Properties")
        public void setOAuth2Properties(Optional<OAuth2Properties> oAuth2Properties) {
            this.oAuth2Properties = oAuth2Properties;
        }

        @JsonProperty(value="connectorName")
        public void setConnectorName(Optional<String> connectorName) {
            this.connectorName = connectorName;
        }

        @JsonProperty(value="profileProperties")
        public void setProfileProperties(Optional<Map<String, String>> profileProperties) {
            this.profileProperties = profileProperties;
        }

        @JsonProperty(value="authenticationType")
        public void setAuthenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
        }

        @JsonProperty(value="defaultApiVersion")
        public void setDefaultApiVersion(Optional<String> defaultApiVersion) {
            this.defaultApiVersion = defaultApiVersion;
        }

        @Override
        public Optional<String> secretsManagerArn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OAuth2Properties> oAuth2Properties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> connectorName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Map<String, String>> profileProperties() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AuthenticationType authenticationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> defaultApiVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

