/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.data;

import com.amazonaws.appflow.custom.connector.integ.data.DescribeConnectorEntityTestConfiguration;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="DescribeConnectorEntityTestConfiguration", generator="Immutables")
@Immutable
public final class ImmutableDescribeConnectorEntityTestConfiguration
implements DescribeConnectorEntityTestConfiguration {
    private final String entityName;
    @Nullable
    private final String validationFileName;
    @Nullable
    private final String profileName;
    @Nullable
    private final String testName;
    @Nullable
    private final String apiVersion;

    private ImmutableDescribeConnectorEntityTestConfiguration(String entityName, @Nullable String validationFileName, @Nullable String profileName, @Nullable String testName, @Nullable String apiVersion) {
        this.entityName = entityName;
        this.validationFileName = validationFileName;
        this.profileName = profileName;
        this.testName = testName;
        this.apiVersion = apiVersion;
    }

    @Override
    @JsonProperty(value="entityName")
    public String entityName() {
        return this.entityName;
    }

    @Override
    @JsonProperty(value="validationFileName")
    public Optional<String> validationFileName() {
        return Optional.ofNullable(this.validationFileName);
    }

    @Override
    @JsonProperty(value="profileName")
    public Optional<String> profileName() {
        return Optional.ofNullable(this.profileName);
    }

    @Override
    @JsonProperty(value="testName")
    public Optional<String> testName() {
        return Optional.ofNullable(this.testName);
    }

    @Override
    @JsonProperty(value="apiVersion")
    public Optional<String> apiVersion() {
        return Optional.ofNullable(this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withEntityName(String value) {
        String newValue = Objects.requireNonNull(value, "entityName");
        if (this.entityName.equals(newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(newValue, this.validationFileName, this.profileName, this.testName, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withValidationFileName(String value) {
        String newValue = Objects.requireNonNull(value, "validationFileName");
        if (Objects.equals(this.validationFileName, newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, newValue, this.profileName, this.testName, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withValidationFileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.validationFileName, value)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, value, this.profileName, this.testName, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withProfileName(String value) {
        String newValue = Objects.requireNonNull(value, "profileName");
        if (Objects.equals(this.profileName, newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, newValue, this.testName, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withProfileName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.profileName, value)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, value, this.testName, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withTestName(String value) {
        String newValue = Objects.requireNonNull(value, "testName");
        if (Objects.equals(this.testName, newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, this.profileName, newValue, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withTestName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.testName, value)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, this.profileName, value, this.apiVersion);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (Objects.equals(this.apiVersion, newValue)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, this.profileName, this.testName, newValue);
    }

    public final ImmutableDescribeConnectorEntityTestConfiguration withApiVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.apiVersion, value)) {
            return this;
        }
        return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, this.profileName, this.testName, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescribeConnectorEntityTestConfiguration && this.equalTo(0, (ImmutableDescribeConnectorEntityTestConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableDescribeConnectorEntityTestConfiguration another) {
        return this.entityName.equals(another.entityName) && Objects.equals(this.validationFileName, another.validationFileName) && Objects.equals(this.profileName, another.profileName) && Objects.equals(this.testName, another.testName) && Objects.equals(this.apiVersion, another.apiVersion);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entityName.hashCode();
        h += (h << 5) + Objects.hashCode(this.validationFileName);
        h += (h << 5) + Objects.hashCode(this.profileName);
        h += (h << 5) + Objects.hashCode(this.testName);
        h += (h << 5) + Objects.hashCode(this.apiVersion);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"DescribeConnectorEntityTestConfiguration").omitNullValues().add("entityName", (Object)this.entityName).add("validationFileName", (Object)this.validationFileName).add("profileName", (Object)this.profileName).add("testName", (Object)this.testName).add("apiVersion", (Object)this.apiVersion).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDescribeConnectorEntityTestConfiguration fromJson(Json json) {
        Builder builder = ImmutableDescribeConnectorEntityTestConfiguration.builder();
        if (json.entityName != null) {
            builder.entityName(json.entityName);
        }
        if (json.validationFileName != null) {
            builder.validationFileName(json.validationFileName);
        }
        if (json.profileName != null) {
            builder.profileName(json.profileName);
        }
        if (json.testName != null) {
            builder.testName(json.testName);
        }
        if (json.apiVersion != null) {
            builder.apiVersion(json.apiVersion);
        }
        return builder.build();
    }

    public static ImmutableDescribeConnectorEntityTestConfiguration copyOf(DescribeConnectorEntityTestConfiguration instance) {
        if (instance instanceof ImmutableDescribeConnectorEntityTestConfiguration) {
            return (ImmutableDescribeConnectorEntityTestConfiguration)instance;
        }
        return ImmutableDescribeConnectorEntityTestConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DescribeConnectorEntityTestConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String entityName;
        @Nullable
        private String validationFileName;
        @Nullable
        private String profileName;
        @Nullable
        private String testName;
        @Nullable
        private String apiVersion;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(DescribeConnectorEntityTestConfiguration instance) {
            Optional<String> apiVersionOptional;
            Optional<String> testNameOptional;
            Optional<String> profileNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.entityName(instance.entityName());
            Optional<String> validationFileNameOptional = instance.validationFileName();
            if (validationFileNameOptional.isPresent()) {
                this.validationFileName(validationFileNameOptional);
            }
            if ((profileNameOptional = instance.profileName()).isPresent()) {
                this.profileName(profileNameOptional);
            }
            if ((testNameOptional = instance.testName()).isPresent()) {
                this.testName(testNameOptional);
            }
            if ((apiVersionOptional = instance.apiVersion()).isPresent()) {
                this.apiVersion(apiVersionOptional);
            }
            return this;
        }

        @JsonProperty(value="entityName")
        @CanIgnoreReturnValue
        public final Builder entityName(String entityName) {
            this.entityName = Objects.requireNonNull(entityName, "entityName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validationFileName(String validationFileName) {
            this.validationFileName = Objects.requireNonNull(validationFileName, "validationFileName");
            return this;
        }

        @JsonProperty(value="validationFileName")
        @CanIgnoreReturnValue
        public final Builder validationFileName(Optional<String> validationFileName) {
            this.validationFileName = validationFileName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder profileName(String profileName) {
            this.profileName = Objects.requireNonNull(profileName, "profileName");
            return this;
        }

        @JsonProperty(value="profileName")
        @CanIgnoreReturnValue
        public final Builder profileName(Optional<String> profileName) {
            this.profileName = profileName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder testName(String testName) {
            this.testName = Objects.requireNonNull(testName, "testName");
            return this;
        }

        @JsonProperty(value="testName")
        @CanIgnoreReturnValue
        public final Builder testName(Optional<String> testName) {
            this.testName = testName.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            return this;
        }

        @JsonProperty(value="apiVersion")
        @CanIgnoreReturnValue
        public final Builder apiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion.orElse(null);
            return this;
        }

        public ImmutableDescribeConnectorEntityTestConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDescribeConnectorEntityTestConfiguration(this.entityName, this.validationFileName, this.profileName, this.testName, this.apiVersion);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityName");
            }
            return "Cannot build DescribeConnectorEntityTestConfiguration, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DescribeConnectorEntityTestConfiguration", generator="Immutables")
    static final class Json
    implements DescribeConnectorEntityTestConfiguration {
        @Nullable
        String entityName;
        @Nullable
        Optional<String> validationFileName = Optional.empty();
        @Nullable
        Optional<String> profileName = Optional.empty();
        @Nullable
        Optional<String> testName = Optional.empty();
        @Nullable
        Optional<String> apiVersion = Optional.empty();

        Json() {
        }

        @JsonProperty(value="entityName")
        public void setEntityName(String entityName) {
            this.entityName = entityName;
        }

        @JsonProperty(value="validationFileName")
        public void setValidationFileName(Optional<String> validationFileName) {
            this.validationFileName = validationFileName;
        }

        @JsonProperty(value="profileName")
        public void setProfileName(Optional<String> profileName) {
            this.profileName = profileName;
        }

        @JsonProperty(value="testName")
        public void setTestName(Optional<String> testName) {
            this.testName = testName;
        }

        @JsonProperty(value="apiVersion")
        public void setApiVersion(Optional<String> apiVersion) {
            this.apiVersion = apiVersion;
        }

        @Override
        public String entityName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> validationFileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> profileName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> testName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> apiVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

