/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Maps;
import org.testng.internal.RuntimeBehavior;

public class DependencyMap {
    private final ListMultiMap<String, ITestNGMethod> m_dependencies = Maps.newListMultiMap();
    private final ListMultiMap<String, ITestNGMethod> m_groups = Maps.newListMultiMap();

    public DependencyMap(ITestNGMethod[] methods) {
        for (ITestNGMethod m3 : methods) {
            this.m_dependencies.put(m3.getQualifiedName(), m3);
            for (String g2 : m3.getGroups()) {
                this.m_groups.put(g2, m3);
            }
        }
    }

    public List<ITestNGMethod> getMethodsThatBelongTo(String group, ITestNGMethod fromMethod) {
        Set uniqueKeys = this.m_groups.keySet();
        Pattern pattern = Pattern.compile(group);
        List<ITestNGMethod> result = ((Stream)this.m_groups.keySet().stream().parallel()).filter(k -> pattern.matcher((CharSequence)k).matches()).flatMap(k -> ((List)this.m_groups.get((String)k)).stream()).collect(Collectors.toList());
        for (String k2 : uniqueKeys) {
            if (!Pattern.matches(group, k2)) continue;
            result.addAll((Collection<ITestNGMethod>)this.m_groups.get(k2));
        }
        if (result.isEmpty() && !fromMethod.ignoreMissingDependencies()) {
            throw new TestNGException("DependencyMap::Method \"" + fromMethod + "\" depends on nonexistent group \"" + group + "\"");
        }
        return result;
    }

    public ITestNGMethod getMethodDependingOn(String methodName, ITestNGMethod fromMethod) {
        List l = (List)this.m_dependencies.get(methodName);
        if (l.isEmpty()) {
            l = (List)this.m_dependencies.get(DependencyMap.constructMethodNameUsingTestClass(methodName, fromMethod));
        }
        if (l.isEmpty() && fromMethod.ignoreMissingDependencies()) {
            return fromMethod;
        }
        Optional<ITestNGMethod> found = ((Stream)l.stream().parallel()).filter(m3 -> DependencyMap.isSameInstance(fromMethod, m3) || DependencyMap.belongToDifferentClassHierarchy(fromMethod, m3) || DependencyMap.hasInstance(fromMethod, m3)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        throw new TestNGException("Method \"" + fromMethod + "\" depends on nonexistent method \"" + methodName + "\"");
    }

    private static boolean belongToDifferentClassHierarchy(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        return !baseClassMethod.getRealClass().isAssignableFrom(derivedClassMethod.getRealClass());
    }

    private static boolean hasInstance(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        boolean params;
        Object baseInstance = baseClassMethod.getInstance();
        Object derivedInstance = derivedClassMethod.getInstance();
        boolean result = derivedInstance != null || baseInstance != null;
        boolean bl = params = null != baseClassMethod.getFactoryMethodParamsInfo() && null != derivedClassMethod.getFactoryMethodParamsInfo().getParameters();
        if (result && params && RuntimeBehavior.enforceThreadAffinity()) {
            return DependencyMap.hasSameParameters(baseClassMethod, derivedClassMethod);
        }
        return result;
    }

    private static boolean hasSameParameters(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        return baseClassMethod.getFactoryMethodParamsInfo().getParameters()[0].equals(derivedClassMethod.getFactoryMethodParamsInfo().getParameters()[0]);
    }

    private static boolean isSameInstance(ITestNGMethod baseClassMethod, ITestNGMethod derivedClassMethod) {
        boolean nonNullInstances;
        Object baseInstance = baseClassMethod.getInstance();
        Object derivedInstance = derivedClassMethod.getInstance();
        boolean bl = nonNullInstances = derivedInstance != null && baseInstance != null;
        if (!nonNullInstances) {
            return false;
        }
        if (null != baseClassMethod.getFactoryMethodParamsInfo() && RuntimeBehavior.enforceThreadAffinity()) {
            return baseInstance.getClass().isAssignableFrom(derivedInstance.getClass()) && DependencyMap.hasSameParameters(baseClassMethod, derivedClassMethod);
        }
        return baseInstance.getClass().isAssignableFrom(derivedInstance.getClass());
    }

    private static String constructMethodNameUsingTestClass(String currentMethodName, ITestNGMethod m3) {
        int lastIndex = currentMethodName.lastIndexOf(46);
        if (lastIndex != -1) {
            return m3.getTestClass().getRealClass().getName() + currentMethodName.substring(lastIndex);
        }
        return currentMethodName;
    }
}

