/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.licensemanager.model.transform;

import com.amazonaws.services.licensemanager.model.TokenData;
import com.amazonaws.transform.JsonUnmarshallerContext;
import com.amazonaws.transform.ListUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.fasterxml.jackson.core.JsonToken;

public class TokenDataJsonUnmarshaller
implements Unmarshaller<TokenData, JsonUnmarshallerContext> {
    private static TokenDataJsonUnmarshaller instance;

    @Override
    public TokenData unmarshall(JsonUnmarshallerContext context) throws Exception {
        TokenData tokenData = new TokenData();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("TokenId", targetDepth)) {
                    context.nextToken();
                    tokenData.setTokenId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TokenType", targetDepth)) {
                    context.nextToken();
                    tokenData.setTokenType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("LicenseArn", targetDepth)) {
                    context.nextToken();
                    tokenData.setLicenseArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ExpirationTime", targetDepth)) {
                    context.nextToken();
                    tokenData.setExpirationTime(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TokenProperties", targetDepth)) {
                    context.nextToken();
                    tokenData.setTokenProperties(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("RoleArns", targetDepth)) {
                    context.nextToken();
                    tokenData.setRoleArns(new ListUnmarshaller<String>(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    tokenData.setStatus(context.getUnmarshaller(String.class).unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return tokenData;
    }

    public static TokenDataJsonUnmarshaller getInstance() {
        if (instance == null) {
            instance = new TokenDataJsonUnmarshaller();
        }
        return instance;
    }
}

