/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.util;

import java.lang.reflect.Field;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    public static final Unsafe TheUnsafe;

    private UnsafeUtil() {
    }

    public static void disableIllegalAccessWarning() {
        try {
            Class<?> illegalAccessLoggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = illegalAccessLoggerClass.getDeclaredField("logger");
            TheUnsafe.putObjectVolatile(illegalAccessLoggerClass, TheUnsafe.staticFieldOffset(loggerField), null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static RuntimeException throwException(Throwable t) {
        TheUnsafe.throwException(t);
        throw new Error("should never get here");
    }

    static {
        try {
            Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            TheUnsafe = (Unsafe)theUnsafe.get(null);
        }
        catch (Exception e) {
            throw new Error("failed to load Unsafe", e);
        }
    }
}

