/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.metadata.FieldConstraints;
import com.amazonaws.appflow.custom.connector.model.metadata.RangeConstraint;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="FieldConstraints", generator="Immutables")
@Immutable
public final class ImmutableFieldConstraints
implements FieldConstraints {
    @Nullable
    private final RangeConstraint allowedLengthRange;
    @Nullable
    private final RangeConstraint allowedValueRange;
    @Nullable
    private final ImmutableList<String> allowedValues;
    @Nullable
    private final String allowedValuesRegexPattern;
    @Nullable
    private final String allowedDateFormat;

    private ImmutableFieldConstraints(@Nullable RangeConstraint allowedLengthRange, @Nullable RangeConstraint allowedValueRange, @Nullable ImmutableList<String> allowedValues, @Nullable String allowedValuesRegexPattern, @Nullable String allowedDateFormat) {
        this.allowedLengthRange = allowedLengthRange;
        this.allowedValueRange = allowedValueRange;
        this.allowedValues = allowedValues;
        this.allowedValuesRegexPattern = allowedValuesRegexPattern;
        this.allowedDateFormat = allowedDateFormat;
    }

    @Override
    @JsonProperty(value="allowedLengthRange")
    @Nullable
    public RangeConstraint allowedLengthRange() {
        return this.allowedLengthRange;
    }

    @Override
    @JsonProperty(value="allowedValueRange")
    @Nullable
    public RangeConstraint allowedValueRange() {
        return this.allowedValueRange;
    }

    @JsonProperty(value="allowedValues")
    @Nullable
    public ImmutableList<String> allowedValues() {
        return this.allowedValues;
    }

    @Override
    @JsonProperty(value="allowedValuesRegexPattern")
    @Nullable
    public String allowedValuesRegexPattern() {
        return this.allowedValuesRegexPattern;
    }

    @Override
    @JsonProperty(value="allowedDateFormat")
    @Nullable
    public String allowedDateFormat() {
        return this.allowedDateFormat;
    }

    public final ImmutableFieldConstraints withAllowedLengthRange(@Nullable RangeConstraint value) {
        if (this.allowedLengthRange == value) {
            return this;
        }
        return new ImmutableFieldConstraints(value, this.allowedValueRange, this.allowedValues, this.allowedValuesRegexPattern, this.allowedDateFormat);
    }

    public final ImmutableFieldConstraints withAllowedValueRange(@Nullable RangeConstraint value) {
        if (this.allowedValueRange == value) {
            return this;
        }
        return new ImmutableFieldConstraints(this.allowedLengthRange, value, this.allowedValues, this.allowedValuesRegexPattern, this.allowedDateFormat);
    }

    public final ImmutableFieldConstraints withAllowedValues(String ... elements) {
        if (elements == null) {
            return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, null, this.allowedValuesRegexPattern, this.allowedDateFormat);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, newValue, this.allowedValuesRegexPattern, this.allowedDateFormat);
    }

    public final ImmutableFieldConstraints withAllowedValues(@Nullable Iterable<String> elements) {
        if (this.allowedValues == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, newValue, this.allowedValuesRegexPattern, this.allowedDateFormat);
    }

    public final ImmutableFieldConstraints withAllowedValuesRegexPattern(@Nullable String value) {
        if (Objects.equals(this.allowedValuesRegexPattern, value)) {
            return this;
        }
        return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, this.allowedValues, value, this.allowedDateFormat);
    }

    public final ImmutableFieldConstraints withAllowedDateFormat(@Nullable String value) {
        if (Objects.equals(this.allowedDateFormat, value)) {
            return this;
        }
        return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, this.allowedValues, this.allowedValuesRegexPattern, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldConstraints && this.equalTo(0, (ImmutableFieldConstraints)another);
    }

    private boolean equalTo(int synthetic, ImmutableFieldConstraints another) {
        return Objects.equals(this.allowedLengthRange, another.allowedLengthRange) && Objects.equals(this.allowedValueRange, another.allowedValueRange) && Objects.equals(this.allowedValues, another.allowedValues) && Objects.equals(this.allowedValuesRegexPattern, another.allowedValuesRegexPattern) && Objects.equals(this.allowedDateFormat, another.allowedDateFormat);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.allowedLengthRange);
        h2 += (h2 << 5) + Objects.hashCode(this.allowedValueRange);
        h2 += (h2 << 5) + Objects.hashCode(this.allowedValues);
        h2 += (h2 << 5) + Objects.hashCode(this.allowedValuesRegexPattern);
        h2 += (h2 << 5) + Objects.hashCode(this.allowedDateFormat);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("FieldConstraints").omitNullValues().add("allowedLengthRange", this.allowedLengthRange).add("allowedValueRange", this.allowedValueRange).add("allowedValues", this.allowedValues).add("allowedValuesRegexPattern", this.allowedValuesRegexPattern).add("allowedDateFormat", this.allowedDateFormat).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFieldConstraints fromJson(Json json) {
        Builder builder = ImmutableFieldConstraints.builder();
        if (json.allowedLengthRange != null) {
            builder.allowedLengthRange(json.allowedLengthRange);
        }
        if (json.allowedValueRange != null) {
            builder.allowedValueRange(json.allowedValueRange);
        }
        if (json.allowedValues != null) {
            builder.addAllAllowedValues(json.allowedValues);
        }
        if (json.allowedValuesRegexPattern != null) {
            builder.allowedValuesRegexPattern(json.allowedValuesRegexPattern);
        }
        if (json.allowedDateFormat != null) {
            builder.allowedDateFormat(json.allowedDateFormat);
        }
        return builder.build();
    }

    public static ImmutableFieldConstraints copyOf(FieldConstraints instance) {
        if (instance instanceof ImmutableFieldConstraints) {
            return (ImmutableFieldConstraints)instance;
        }
        return ImmutableFieldConstraints.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FieldConstraints", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private RangeConstraint allowedLengthRange;
        @Nullable
        private RangeConstraint allowedValueRange;
        private ImmutableList.Builder<String> allowedValues = null;
        @Nullable
        private String allowedValuesRegexPattern;
        @Nullable
        private String allowedDateFormat;

        private Builder() {
        }

        public final Builder from(FieldConstraints instance) {
            String allowedDateFormatValue;
            String allowedValuesRegexPatternValue;
            List<String> allowedValuesValue;
            RangeConstraint allowedValueRangeValue;
            Objects.requireNonNull(instance, "instance");
            RangeConstraint allowedLengthRangeValue = instance.allowedLengthRange();
            if (allowedLengthRangeValue != null) {
                this.allowedLengthRange(allowedLengthRangeValue);
            }
            if ((allowedValueRangeValue = instance.allowedValueRange()) != null) {
                this.allowedValueRange(allowedValueRangeValue);
            }
            if ((allowedValuesValue = instance.allowedValues()) != null) {
                this.addAllAllowedValues(allowedValuesValue);
            }
            if ((allowedValuesRegexPatternValue = instance.allowedValuesRegexPattern()) != null) {
                this.allowedValuesRegexPattern(allowedValuesRegexPatternValue);
            }
            if ((allowedDateFormatValue = instance.allowedDateFormat()) != null) {
                this.allowedDateFormat(allowedDateFormatValue);
            }
            return this;
        }

        @JsonProperty(value="allowedLengthRange")
        public final Builder allowedLengthRange(@Nullable RangeConstraint allowedLengthRange) {
            this.allowedLengthRange = allowedLengthRange;
            return this;
        }

        @JsonProperty(value="allowedValueRange")
        public final Builder allowedValueRange(@Nullable RangeConstraint allowedValueRange) {
            this.allowedValueRange = allowedValueRange;
            return this;
        }

        public final Builder addAllowedValues(String element) {
            if (this.allowedValues == null) {
                this.allowedValues = ImmutableList.builder();
            }
            this.allowedValues.add((Object)element);
            return this;
        }

        public final Builder addAllowedValues(String ... elements) {
            if (this.allowedValues == null) {
                this.allowedValues = ImmutableList.builder();
            }
            this.allowedValues.add(elements);
            return this;
        }

        @JsonProperty(value="allowedValues")
        public final Builder allowedValues(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.allowedValues = null;
                return this;
            }
            this.allowedValues = ImmutableList.builder();
            return this.addAllAllowedValues(elements);
        }

        public final Builder addAllAllowedValues(Iterable<String> elements) {
            Objects.requireNonNull(elements, "allowedValues element");
            if (this.allowedValues == null) {
                this.allowedValues = ImmutableList.builder();
            }
            this.allowedValues.addAll((Iterable)elements);
            return this;
        }

        @JsonProperty(value="allowedValuesRegexPattern")
        public final Builder allowedValuesRegexPattern(@Nullable String allowedValuesRegexPattern) {
            this.allowedValuesRegexPattern = allowedValuesRegexPattern;
            return this;
        }

        @JsonProperty(value="allowedDateFormat")
        public final Builder allowedDateFormat(@Nullable String allowedDateFormat) {
            this.allowedDateFormat = allowedDateFormat;
            return this;
        }

        public ImmutableFieldConstraints build() {
            return new ImmutableFieldConstraints(this.allowedLengthRange, this.allowedValueRange, (ImmutableList)(this.allowedValues == null ? null : this.allowedValues.build()), this.allowedValuesRegexPattern, this.allowedDateFormat);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FieldConstraints", generator="Immutables")
    static final class Json
    implements FieldConstraints {
        @Nullable
        RangeConstraint allowedLengthRange;
        @Nullable
        RangeConstraint allowedValueRange;
        @Nullable
        List<String> allowedValues = null;
        @Nullable
        String allowedValuesRegexPattern;
        @Nullable
        String allowedDateFormat;

        Json() {
        }

        @JsonProperty(value="allowedLengthRange")
        public void setAllowedLengthRange(@Nullable RangeConstraint allowedLengthRange) {
            this.allowedLengthRange = allowedLengthRange;
        }

        @JsonProperty(value="allowedValueRange")
        public void setAllowedValueRange(@Nullable RangeConstraint allowedValueRange) {
            this.allowedValueRange = allowedValueRange;
        }

        @JsonProperty(value="allowedValues")
        public void setAllowedValues(@Nullable List<String> allowedValues) {
            this.allowedValues = allowedValues;
        }

        @JsonProperty(value="allowedValuesRegexPattern")
        public void setAllowedValuesRegexPattern(@Nullable String allowedValuesRegexPattern) {
            this.allowedValuesRegexPattern = allowedValuesRegexPattern;
        }

        @JsonProperty(value="allowedDateFormat")
        public void setAllowedDateFormat(@Nullable String allowedDateFormat) {
            this.allowedDateFormat = allowedDateFormat;
        }

        @Override
        public RangeConstraint allowedLengthRange() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RangeConstraint allowedValueRange() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> allowedValues() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String allowedValuesRegexPattern() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String allowedDateFormat() {
            throw new UnsupportedOperationException();
        }
    }
}

