/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.metadata.DescribeEntityRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="DescribeEntityRequest")
@Generated(from="DescribeEntityRequest", generator="Immutables")
@Immutable
public final class ImmutableDescribeEntityRequest
implements DescribeEntityRequest {
    private final String entityIdentifier;
    private final ConnectorContext connectorContext;

    private ImmutableDescribeEntityRequest(String entityIdentifier, ConnectorContext connectorContext) {
        this.entityIdentifier = entityIdentifier;
        this.connectorContext = connectorContext;
    }

    @Override
    @JsonProperty(value="entityIdentifier")
    public String entityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    @JsonProperty(value="connectorContext")
    public ConnectorContext connectorContext() {
        return this.connectorContext;
    }

    public final ImmutableDescribeEntityRequest withEntityIdentifier(String value) {
        String newValue = Objects.requireNonNull(value, "entityIdentifier");
        if (this.entityIdentifier.equals(newValue)) {
            return this;
        }
        return new ImmutableDescribeEntityRequest(newValue, this.connectorContext);
    }

    public final ImmutableDescribeEntityRequest withConnectorContext(ConnectorContext value) {
        if (this.connectorContext == value) {
            return this;
        }
        ConnectorContext newValue = Objects.requireNonNull(value, "connectorContext");
        return new ImmutableDescribeEntityRequest(this.entityIdentifier, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescribeEntityRequest && this.equalTo(0, (ImmutableDescribeEntityRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableDescribeEntityRequest another) {
        return this.entityIdentifier.equals(another.entityIdentifier) && this.connectorContext.equals(another.connectorContext);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.entityIdentifier.hashCode();
        h2 += (h2 << 5) + this.connectorContext.hashCode();
        return h2;
    }

    public String toString() {
        return "DescribeEntityRequest{entityIdentifier=" + this.entityIdentifier + ", connectorContext=" + this.connectorContext + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableDescribeEntityRequest fromJson(Json json) {
        Builder builder = ImmutableDescribeEntityRequest.builder();
        if (json.entityIdentifier != null) {
            builder.entityIdentifier(json.entityIdentifier);
        }
        if (json.connectorContext != null) {
            builder.connectorContext(json.connectorContext);
        }
        return builder.build();
    }

    public static ImmutableDescribeEntityRequest copyOf(DescribeEntityRequest instance) {
        if (instance instanceof ImmutableDescribeEntityRequest) {
            return (ImmutableDescribeEntityRequest)instance;
        }
        return ImmutableDescribeEntityRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DescribeEntityRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY_IDENTIFIER = 1L;
        private static final long INIT_BIT_CONNECTOR_CONTEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String entityIdentifier;
        @Nullable
        private ConnectorContext connectorContext;

        private Builder() {
        }

        public final Builder from(DescribeEntityRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.entityIdentifier(instance.entityIdentifier());
            this.connectorContext(instance.connectorContext());
            return this;
        }

        @JsonProperty(value="entityIdentifier")
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = Objects.requireNonNull(entityIdentifier, "entityIdentifier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="connectorContext")
        public final Builder connectorContext(ConnectorContext connectorContext) {
            this.connectorContext = Objects.requireNonNull(connectorContext, "connectorContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableDescribeEntityRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDescribeEntityRequest(this.entityIdentifier, this.connectorContext);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entityIdentifier");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("connectorContext");
            }
            return "Cannot build DescribeEntityRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DescribeEntityRequest", generator="Immutables")
    static final class Json
    implements DescribeEntityRequest {
        @Nullable
        String entityIdentifier;
        @Nullable
        ConnectorContext connectorContext;

        Json() {
        }

        @JsonProperty(value="entityIdentifier")
        public void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @JsonProperty(value="connectorContext")
        public void setConnectorContext(ConnectorContext connectorContext) {
            this.connectorContext = connectorContext;
        }

        @Override
        public String entityIdentifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorContext connectorContext() {
            throw new UnsupportedOperationException();
        }
    }
}

