/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.ApiKeyCredentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ApiKeyCredentials", generator="Immutables")
@Immutable
public final class ImmutableApiKeyCredentials
implements ApiKeyCredentials {
    private final String apiKey;
    @Nullable
    private final String secretKey;

    private ImmutableApiKeyCredentials(String apiKey, @Nullable String secretKey) {
        this.apiKey = apiKey;
        this.secretKey = secretKey;
    }

    @Override
    @JsonProperty(value="apiKey")
    public String apiKey() {
        return this.apiKey;
    }

    @Override
    @JsonProperty(value="secretKey")
    @Nullable
    public String secretKey() {
        return this.secretKey;
    }

    public final ImmutableApiKeyCredentials withApiKey(String value) {
        String newValue = Objects.requireNonNull(value, "apiKey");
        if (this.apiKey.equals(newValue)) {
            return this;
        }
        return new ImmutableApiKeyCredentials(newValue, this.secretKey);
    }

    public final ImmutableApiKeyCredentials withSecretKey(@Nullable String value) {
        if (Objects.equals(this.secretKey, value)) {
            return this;
        }
        return new ImmutableApiKeyCredentials(this.apiKey, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableApiKeyCredentials && this.equalTo(0, (ImmutableApiKeyCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableApiKeyCredentials another) {
        return this.apiKey.equals(another.apiKey) && Objects.equals(this.secretKey, another.secretKey);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.apiKey.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.secretKey);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("ApiKeyCredentials").omitNullValues().add("apiKey", this.apiKey).add("secretKey", this.secretKey).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableApiKeyCredentials fromJson(Json json) {
        Builder builder = ImmutableApiKeyCredentials.builder();
        if (json.apiKey != null) {
            builder.apiKey(json.apiKey);
        }
        if (json.secretKey != null) {
            builder.secretKey(json.secretKey);
        }
        return builder.build();
    }

    public static ImmutableApiKeyCredentials copyOf(ApiKeyCredentials instance) {
        if (instance instanceof ImmutableApiKeyCredentials) {
            return (ImmutableApiKeyCredentials)instance;
        }
        return ImmutableApiKeyCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ApiKeyCredentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_API_KEY = 1L;
        private long initBits = 1L;
        @Nullable
        private String apiKey;
        @Nullable
        private String secretKey;

        private Builder() {
        }

        public final Builder from(ApiKeyCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiKey(instance.apiKey());
            String secretKeyValue = instance.secretKey();
            if (secretKeyValue != null) {
                this.secretKey(secretKeyValue);
            }
            return this;
        }

        @JsonProperty(value="apiKey")
        public final Builder apiKey(String apiKey) {
            this.apiKey = Objects.requireNonNull(apiKey, "apiKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="secretKey")
        public final Builder secretKey(@Nullable String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public ImmutableApiKeyCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableApiKeyCredentials(this.apiKey, this.secretKey);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiKey");
            }
            return "Cannot build ApiKeyCredentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ApiKeyCredentials", generator="Immutables")
    static final class Json
    implements ApiKeyCredentials {
        @Nullable
        String apiKey;
        @Nullable
        String secretKey;

        Json() {
        }

        @JsonProperty(value="apiKey")
        public void setApiKey(String apiKey) {
            this.apiKey = apiKey;
        }

        @JsonProperty(value="secretKey")
        public void setSecretKey(@Nullable String secretKey) {
            this.secretKey = secretKey;
        }

        @Override
        public String apiKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String secretKey() {
            throw new UnsupportedOperationException();
        }
    }
}

