/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2CustomParameter;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2Defaults;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2GrantType;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OAuth2Defaults", generator="Immutables")
@Immutable
public final class ImmutableOAuth2Defaults
implements OAuth2Defaults {
    @Nullable
    private final ImmutableList<String> oAuthScopes;
    private final ImmutableList<String> tokenURL;
    @Nullable
    private final ImmutableList<String> authURL;
    private final ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported;
    @Nullable
    private final ImmutableList<OAuth2CustomParameter> oauth2CustomProperties;

    private ImmutableOAuth2Defaults(@Nullable ImmutableList<String> oAuthScopes, ImmutableList<String> tokenURL, @Nullable ImmutableList<String> authURL, ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported, @Nullable ImmutableList<OAuth2CustomParameter> oauth2CustomProperties) {
        this.oAuthScopes = oAuthScopes;
        this.tokenURL = tokenURL;
        this.authURL = authURL;
        this.oAuth2GrantTypesSupported = oAuth2GrantTypesSupported;
        this.oauth2CustomProperties = oauth2CustomProperties;
    }

    @JsonProperty(value="oAuthScopes")
    @Nullable
    public ImmutableList<String> oAuthScopes() {
        return this.oAuthScopes;
    }

    @JsonProperty(value="tokenURL")
    public ImmutableList<String> tokenURL() {
        return this.tokenURL;
    }

    @JsonProperty(value="authURL")
    @Nullable
    public ImmutableList<String> authURL() {
        return this.authURL;
    }

    @JsonProperty(value="oAuth2GrantTypesSupported")
    public ImmutableList<OAuth2GrantType> oAuth2GrantTypesSupported() {
        return this.oAuth2GrantTypesSupported;
    }

    @JsonProperty(value="oauth2CustomProperties")
    @Nullable
    public ImmutableList<OAuth2CustomParameter> oauth2CustomProperties() {
        return this.oauth2CustomProperties;
    }

    public final ImmutableOAuth2Defaults withOAuthScopes(String ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(null, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(newValue, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withOAuthScopes(@Nullable Iterable<String> elements) {
        if (this.oAuthScopes == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(newValue, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withTokenURL(String ... elements) {
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, newValue, this.authURL, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withTokenURL(Iterable<String> elements) {
        if (this.tokenURL == elements) {
            return this;
        }
        ImmutableList<String> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, newValue, this.authURL, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withAuthURL(String ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, null, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, newValue, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withAuthURL(@Nullable Iterable<String> elements) {
        if (this.authURL == elements) {
            return this;
        }
        ImmutableList<String> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, newValue, this.oAuth2GrantTypesSupported, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withOAuth2GrantTypesSupported(OAuth2GrantType ... elements) {
        ImmutableList<OAuth2GrantType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, newValue, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withOAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
        if (this.oAuth2GrantTypesSupported == elements) {
            return this;
        }
        ImmutableList<OAuth2GrantType> newValue = ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, newValue, this.oauth2CustomProperties);
    }

    public final ImmutableOAuth2Defaults withOauth2CustomProperties(OAuth2CustomParameter ... elements) {
        if (elements == null) {
            return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, null);
        }
        ImmutableList<OAuth2CustomParameter> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, newValue);
    }

    public final ImmutableOAuth2Defaults withOauth2CustomProperties(@Nullable Iterable<? extends OAuth2CustomParameter> elements) {
        if (this.oauth2CustomProperties == elements) {
            return this;
        }
        ImmutableList<OAuth2CustomParameter> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableOAuth2Defaults(this.oAuthScopes, this.tokenURL, this.authURL, this.oAuth2GrantTypesSupported, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOAuth2Defaults && this.equalTo(0, (ImmutableOAuth2Defaults)another);
    }

    private boolean equalTo(int synthetic, ImmutableOAuth2Defaults another) {
        return Objects.equals(this.oAuthScopes, another.oAuthScopes) && this.tokenURL.equals(another.tokenURL) && Objects.equals(this.authURL, another.authURL) && this.oAuth2GrantTypesSupported.equals(another.oAuth2GrantTypesSupported) && Objects.equals(this.oauth2CustomProperties, another.oauth2CustomProperties);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.oAuthScopes);
        h2 += (h2 << 5) + this.tokenURL.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.authURL);
        h2 += (h2 << 5) + this.oAuth2GrantTypesSupported.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.oauth2CustomProperties);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("OAuth2Defaults").omitNullValues().add("oAuthScopes", this.oAuthScopes).add("tokenURL", this.tokenURL).add("authURL", this.authURL).add("oAuth2GrantTypesSupported", this.oAuth2GrantTypesSupported).add("oauth2CustomProperties", this.oauth2CustomProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableOAuth2Defaults fromJson(Json json) {
        Builder builder = ImmutableOAuth2Defaults.builder();
        if (json.oAuthScopes != null) {
            builder.addAllOAuthScopes(json.oAuthScopes);
        }
        if (json.tokenURL != null) {
            builder.addAllTokenURL(json.tokenURL);
        }
        if (json.authURL != null) {
            builder.addAllAuthURL(json.authURL);
        }
        if (json.oAuth2GrantTypesSupported != null) {
            builder.addAllOAuth2GrantTypesSupported(json.oAuth2GrantTypesSupported);
        }
        if (json.oauth2CustomProperties != null) {
            builder.addAllOauth2CustomProperties(json.oauth2CustomProperties);
        }
        return builder.build();
    }

    public static ImmutableOAuth2Defaults copyOf(OAuth2Defaults instance) {
        if (instance instanceof ImmutableOAuth2Defaults) {
            return (ImmutableOAuth2Defaults)instance;
        }
        return ImmutableOAuth2Defaults.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuth2Defaults", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private ImmutableList.Builder<String> oAuthScopes = null;
        private ImmutableList.Builder<String> tokenURL = ImmutableList.builder();
        private ImmutableList.Builder<String> authURL = null;
        private ImmutableList.Builder<OAuth2GrantType> oAuth2GrantTypesSupported = ImmutableList.builder();
        private ImmutableList.Builder<OAuth2CustomParameter> oauth2CustomProperties = null;

        private Builder() {
        }

        public final Builder from(OAuth2Defaults instance) {
            Objects.requireNonNull(instance, "instance");
            List<String> oAuthScopesValue = instance.oAuthScopes();
            if (oAuthScopesValue != null) {
                this.addAllOAuthScopes(oAuthScopesValue);
            }
            this.addAllTokenURL(instance.tokenURL());
            List<String> authURLValue = instance.authURL();
            if (authURLValue != null) {
                this.addAllAuthURL(authURLValue);
            }
            this.addAllOAuth2GrantTypesSupported(instance.oAuth2GrantTypesSupported());
            List<OAuth2CustomParameter> oauth2CustomPropertiesValue = instance.oauth2CustomProperties();
            if (oauth2CustomPropertiesValue != null) {
                this.addAllOauth2CustomProperties(oauth2CustomPropertiesValue);
            }
            return this;
        }

        public final Builder addOAuthScopes(String element) {
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.add((Object)element);
            return this;
        }

        public final Builder addOAuthScopes(String ... elements) {
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.add(elements);
            return this;
        }

        @JsonProperty(value="oAuthScopes")
        public final Builder oAuthScopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.oAuthScopes = null;
                return this;
            }
            this.oAuthScopes = ImmutableList.builder();
            return this.addAllOAuthScopes(elements);
        }

        public final Builder addAllOAuthScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "oAuthScopes element");
            if (this.oAuthScopes == null) {
                this.oAuthScopes = ImmutableList.builder();
            }
            this.oAuthScopes.addAll((Iterable)elements);
            return this;
        }

        public final Builder addTokenURL(String element) {
            this.tokenURL.add((Object)element);
            return this;
        }

        public final Builder addTokenURL(String ... elements) {
            this.tokenURL.add(elements);
            return this;
        }

        @JsonProperty(value="tokenURL")
        public final Builder tokenURL(Iterable<String> elements) {
            this.tokenURL = ImmutableList.builder();
            return this.addAllTokenURL(elements);
        }

        public final Builder addAllTokenURL(Iterable<String> elements) {
            this.tokenURL.addAll((Iterable)elements);
            return this;
        }

        public final Builder addAuthURL(String element) {
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.add((Object)element);
            return this;
        }

        public final Builder addAuthURL(String ... elements) {
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.add(elements);
            return this;
        }

        @JsonProperty(value="authURL")
        public final Builder authURL(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.authURL = null;
                return this;
            }
            this.authURL = ImmutableList.builder();
            return this.addAllAuthURL(elements);
        }

        public final Builder addAllAuthURL(Iterable<String> elements) {
            Objects.requireNonNull(elements, "authURL element");
            if (this.authURL == null) {
                this.authURL = ImmutableList.builder();
            }
            this.authURL.addAll((Iterable)elements);
            return this;
        }

        public final Builder addOAuth2GrantTypesSupported(OAuth2GrantType element) {
            this.oAuth2GrantTypesSupported.add((Object)element);
            return this;
        }

        public final Builder addOAuth2GrantTypesSupported(OAuth2GrantType ... elements) {
            this.oAuth2GrantTypesSupported.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="oAuth2GrantTypesSupported")
        public final Builder oAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
            this.oAuth2GrantTypesSupported = ImmutableList.builder();
            return this.addAllOAuth2GrantTypesSupported(elements);
        }

        public final Builder addAllOAuth2GrantTypesSupported(Iterable<? extends OAuth2GrantType> elements) {
            this.oAuth2GrantTypesSupported.addAll(elements);
            return this;
        }

        public final Builder addOauth2CustomProperties(OAuth2CustomParameter element) {
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.add((Object)element);
            return this;
        }

        public final Builder addOauth2CustomProperties(OAuth2CustomParameter ... elements) {
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.add(elements);
            return this;
        }

        @JsonProperty(value="oauth2CustomProperties")
        public final Builder oauth2CustomProperties(@Nullable Iterable<? extends OAuth2CustomParameter> elements) {
            if (elements == null) {
                this.oauth2CustomProperties = null;
                return this;
            }
            this.oauth2CustomProperties = ImmutableList.builder();
            return this.addAllOauth2CustomProperties(elements);
        }

        public final Builder addAllOauth2CustomProperties(Iterable<? extends OAuth2CustomParameter> elements) {
            Objects.requireNonNull(elements, "oauth2CustomProperties element");
            if (this.oauth2CustomProperties == null) {
                this.oauth2CustomProperties = ImmutableList.builder();
            }
            this.oauth2CustomProperties.addAll(elements);
            return this;
        }

        public ImmutableOAuth2Defaults build() {
            return new ImmutableOAuth2Defaults((ImmutableList)(this.oAuthScopes == null ? null : this.oAuthScopes.build()), (ImmutableList)this.tokenURL.build(), (ImmutableList)(this.authURL == null ? null : this.authURL.build()), (ImmutableList)this.oAuth2GrantTypesSupported.build(), (ImmutableList)(this.oauth2CustomProperties == null ? null : this.oauth2CustomProperties.build()));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OAuth2Defaults", generator="Immutables")
    static final class Json
    implements OAuth2Defaults {
        @Nullable
        List<String> oAuthScopes = null;
        @Nullable
        List<String> tokenURL = ImmutableList.of();
        @Nullable
        List<String> authURL = null;
        @Nullable
        List<OAuth2GrantType> oAuth2GrantTypesSupported = ImmutableList.of();
        @Nullable
        List<OAuth2CustomParameter> oauth2CustomProperties = null;

        Json() {
        }

        @JsonProperty(value="oAuthScopes")
        public void setOAuthScopes(@Nullable List<String> oAuthScopes) {
            this.oAuthScopes = oAuthScopes;
        }

        @JsonProperty(value="tokenURL")
        public void setTokenURL(List<String> tokenURL) {
            this.tokenURL = tokenURL;
        }

        @JsonProperty(value="authURL")
        public void setAuthURL(@Nullable List<String> authURL) {
            this.authURL = authURL;
        }

        @JsonProperty(value="oAuth2GrantTypesSupported")
        public void setOAuth2GrantTypesSupported(List<OAuth2GrantType> oAuth2GrantTypesSupported) {
            this.oAuth2GrantTypesSupported = oAuth2GrantTypesSupported;
        }

        @JsonProperty(value="oauth2CustomProperties")
        public void setOauth2CustomProperties(@Nullable List<OAuth2CustomParameter> oauth2CustomProperties) {
            this.oauth2CustomProperties = oauth2CustomProperties;
        }

        @Override
        public List<String> oAuthScopes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> tokenURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> authURL() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OAuth2GrantType> oAuth2GrantTypesSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OAuth2CustomParameter> oauth2CustomProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

