/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthenticationConfig;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.CustomAuthConfig;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.OAuth2Defaults;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AuthenticationConfig", generator="Immutables")
@Immutable
public final class ImmutableAuthenticationConfig
implements AuthenticationConfig {
    @Nullable
    private final Boolean isBasicAuthSupported;
    @Nullable
    private final Boolean isApiKeyAuthSupported;
    @Nullable
    private final Boolean isOAuth2Supported;
    @Nullable
    private final Boolean isCustomAuthSupported;
    @Nullable
    private final OAuth2Defaults oAuth2Defaults;
    @Nullable
    private final ImmutableList<CustomAuthConfig> customAuthConfig;

    private ImmutableAuthenticationConfig(@Nullable Boolean isBasicAuthSupported, @Nullable Boolean isApiKeyAuthSupported, @Nullable Boolean isOAuth2Supported, @Nullable Boolean isCustomAuthSupported, @Nullable OAuth2Defaults oAuth2Defaults, @Nullable ImmutableList<CustomAuthConfig> customAuthConfig) {
        this.isBasicAuthSupported = isBasicAuthSupported;
        this.isApiKeyAuthSupported = isApiKeyAuthSupported;
        this.isOAuth2Supported = isOAuth2Supported;
        this.isCustomAuthSupported = isCustomAuthSupported;
        this.oAuth2Defaults = oAuth2Defaults;
        this.customAuthConfig = customAuthConfig;
    }

    @Override
    @JsonProperty(value="isBasicAuthSupported")
    @Nullable
    public Boolean isBasicAuthSupported() {
        return this.isBasicAuthSupported;
    }

    @Override
    @JsonProperty(value="isApiKeyAuthSupported")
    @Nullable
    public Boolean isApiKeyAuthSupported() {
        return this.isApiKeyAuthSupported;
    }

    @Override
    @JsonProperty(value="isOAuth2Supported")
    @Nullable
    public Boolean isOAuth2Supported() {
        return this.isOAuth2Supported;
    }

    @Override
    @JsonProperty(value="isCustomAuthSupported")
    @Nullable
    public Boolean isCustomAuthSupported() {
        return this.isCustomAuthSupported;
    }

    @Override
    @JsonProperty(value="oAuth2Defaults")
    @Nullable
    public OAuth2Defaults oAuth2Defaults() {
        return this.oAuth2Defaults;
    }

    @JsonProperty(value="customAuthConfig")
    @Nullable
    public ImmutableList<CustomAuthConfig> customAuthConfig() {
        return this.customAuthConfig;
    }

    public final ImmutableAuthenticationConfig withIsBasicAuthSupported(@Nullable Boolean value) {
        if (Objects.equals(this.isBasicAuthSupported, value)) {
            return this;
        }
        return new ImmutableAuthenticationConfig(value, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, this.customAuthConfig);
    }

    public final ImmutableAuthenticationConfig withIsApiKeyAuthSupported(@Nullable Boolean value) {
        if (Objects.equals(this.isApiKeyAuthSupported, value)) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, value, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, this.customAuthConfig);
    }

    public final ImmutableAuthenticationConfig withIsOAuth2Supported(@Nullable Boolean value) {
        if (Objects.equals(this.isOAuth2Supported, value)) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, value, this.isCustomAuthSupported, this.oAuth2Defaults, this.customAuthConfig);
    }

    public final ImmutableAuthenticationConfig withIsCustomAuthSupported(@Nullable Boolean value) {
        if (Objects.equals(this.isCustomAuthSupported, value)) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, value, this.oAuth2Defaults, this.customAuthConfig);
    }

    public final ImmutableAuthenticationConfig withOAuth2Defaults(@Nullable OAuth2Defaults value) {
        if (this.oAuth2Defaults == value) {
            return this;
        }
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, value, this.customAuthConfig);
    }

    public final ImmutableAuthenticationConfig withCustomAuthConfig(CustomAuthConfig ... elements) {
        if (elements == null) {
            return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, null);
        }
        ImmutableList<CustomAuthConfig> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, newValue);
    }

    public final ImmutableAuthenticationConfig withCustomAuthConfig(@Nullable Iterable<? extends CustomAuthConfig> elements) {
        if (this.customAuthConfig == elements) {
            return this;
        }
        ImmutableList<CustomAuthConfig> newValue = elements == null ? null : ImmutableList.copyOf(elements);
        return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAuthenticationConfig && this.equalTo(0, (ImmutableAuthenticationConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableAuthenticationConfig another) {
        return Objects.equals(this.isBasicAuthSupported, another.isBasicAuthSupported) && Objects.equals(this.isApiKeyAuthSupported, another.isApiKeyAuthSupported) && Objects.equals(this.isOAuth2Supported, another.isOAuth2Supported) && Objects.equals(this.isCustomAuthSupported, another.isCustomAuthSupported) && Objects.equals(this.oAuth2Defaults, another.oAuth2Defaults) && Objects.equals(this.customAuthConfig, another.customAuthConfig);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.isBasicAuthSupported);
        h2 += (h2 << 5) + Objects.hashCode(this.isApiKeyAuthSupported);
        h2 += (h2 << 5) + Objects.hashCode(this.isOAuth2Supported);
        h2 += (h2 << 5) + Objects.hashCode(this.isCustomAuthSupported);
        h2 += (h2 << 5) + Objects.hashCode(this.oAuth2Defaults);
        h2 += (h2 << 5) + Objects.hashCode(this.customAuthConfig);
        return h2;
    }

    public String toString() {
        return MoreObjects.toStringHelper("AuthenticationConfig").omitNullValues().add("isBasicAuthSupported", this.isBasicAuthSupported).add("isApiKeyAuthSupported", this.isApiKeyAuthSupported).add("isOAuth2Supported", this.isOAuth2Supported).add("isCustomAuthSupported", this.isCustomAuthSupported).add("oAuth2Defaults", this.oAuth2Defaults).add("customAuthConfig", this.customAuthConfig).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAuthenticationConfig fromJson(Json json) {
        Builder builder = ImmutableAuthenticationConfig.builder();
        if (json.isBasicAuthSupported != null) {
            builder.isBasicAuthSupported(json.isBasicAuthSupported);
        }
        if (json.isApiKeyAuthSupported != null) {
            builder.isApiKeyAuthSupported(json.isApiKeyAuthSupported);
        }
        if (json.isOAuth2Supported != null) {
            builder.isOAuth2Supported(json.isOAuth2Supported);
        }
        if (json.isCustomAuthSupported != null) {
            builder.isCustomAuthSupported(json.isCustomAuthSupported);
        }
        if (json.oAuth2Defaults != null) {
            builder.oAuth2Defaults(json.oAuth2Defaults);
        }
        if (json.customAuthConfig != null) {
            builder.addAllCustomAuthConfig(json.customAuthConfig);
        }
        return builder.build();
    }

    public static ImmutableAuthenticationConfig copyOf(AuthenticationConfig instance) {
        if (instance instanceof ImmutableAuthenticationConfig) {
            return (ImmutableAuthenticationConfig)instance;
        }
        return ImmutableAuthenticationConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AuthenticationConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean isBasicAuthSupported;
        @Nullable
        private Boolean isApiKeyAuthSupported;
        @Nullable
        private Boolean isOAuth2Supported;
        @Nullable
        private Boolean isCustomAuthSupported;
        @Nullable
        private OAuth2Defaults oAuth2Defaults;
        private ImmutableList.Builder<CustomAuthConfig> customAuthConfig = null;

        private Builder() {
        }

        public final Builder from(AuthenticationConfig instance) {
            List<CustomAuthConfig> customAuthConfigValue;
            OAuth2Defaults oAuth2DefaultsValue;
            Boolean isCustomAuthSupportedValue;
            Boolean isOAuth2SupportedValue;
            Boolean isApiKeyAuthSupportedValue;
            Objects.requireNonNull(instance, "instance");
            Boolean isBasicAuthSupportedValue = instance.isBasicAuthSupported();
            if (isBasicAuthSupportedValue != null) {
                this.isBasicAuthSupported(isBasicAuthSupportedValue);
            }
            if ((isApiKeyAuthSupportedValue = instance.isApiKeyAuthSupported()) != null) {
                this.isApiKeyAuthSupported(isApiKeyAuthSupportedValue);
            }
            if ((isOAuth2SupportedValue = instance.isOAuth2Supported()) != null) {
                this.isOAuth2Supported(isOAuth2SupportedValue);
            }
            if ((isCustomAuthSupportedValue = instance.isCustomAuthSupported()) != null) {
                this.isCustomAuthSupported(isCustomAuthSupportedValue);
            }
            if ((oAuth2DefaultsValue = instance.oAuth2Defaults()) != null) {
                this.oAuth2Defaults(oAuth2DefaultsValue);
            }
            if ((customAuthConfigValue = instance.customAuthConfig()) != null) {
                this.addAllCustomAuthConfig(customAuthConfigValue);
            }
            return this;
        }

        @JsonProperty(value="isBasicAuthSupported")
        public final Builder isBasicAuthSupported(@Nullable Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
            return this;
        }

        @JsonProperty(value="isApiKeyAuthSupported")
        public final Builder isApiKeyAuthSupported(@Nullable Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
            return this;
        }

        @JsonProperty(value="isOAuth2Supported")
        public final Builder isOAuth2Supported(@Nullable Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
            return this;
        }

        @JsonProperty(value="isCustomAuthSupported")
        public final Builder isCustomAuthSupported(@Nullable Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
            return this;
        }

        @JsonProperty(value="oAuth2Defaults")
        public final Builder oAuth2Defaults(@Nullable OAuth2Defaults oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults;
            return this;
        }

        public final Builder addCustomAuthConfig(CustomAuthConfig element) {
            if (this.customAuthConfig == null) {
                this.customAuthConfig = ImmutableList.builder();
            }
            this.customAuthConfig.add((Object)element);
            return this;
        }

        public final Builder addCustomAuthConfig(CustomAuthConfig ... elements) {
            if (this.customAuthConfig == null) {
                this.customAuthConfig = ImmutableList.builder();
            }
            this.customAuthConfig.add(elements);
            return this;
        }

        @JsonProperty(value="customAuthConfig")
        public final Builder customAuthConfig(@Nullable Iterable<? extends CustomAuthConfig> elements) {
            if (elements == null) {
                this.customAuthConfig = null;
                return this;
            }
            this.customAuthConfig = ImmutableList.builder();
            return this.addAllCustomAuthConfig(elements);
        }

        public final Builder addAllCustomAuthConfig(Iterable<? extends CustomAuthConfig> elements) {
            Objects.requireNonNull(elements, "customAuthConfig element");
            if (this.customAuthConfig == null) {
                this.customAuthConfig = ImmutableList.builder();
            }
            this.customAuthConfig.addAll(elements);
            return this;
        }

        public ImmutableAuthenticationConfig build() {
            return new ImmutableAuthenticationConfig(this.isBasicAuthSupported, this.isApiKeyAuthSupported, this.isOAuth2Supported, this.isCustomAuthSupported, this.oAuth2Defaults, (ImmutableList)(this.customAuthConfig == null ? null : this.customAuthConfig.build()));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AuthenticationConfig", generator="Immutables")
    static final class Json
    implements AuthenticationConfig {
        @Nullable
        Boolean isBasicAuthSupported;
        @Nullable
        Boolean isApiKeyAuthSupported;
        @Nullable
        Boolean isOAuth2Supported;
        @Nullable
        Boolean isCustomAuthSupported;
        @Nullable
        OAuth2Defaults oAuth2Defaults;
        @Nullable
        List<CustomAuthConfig> customAuthConfig = null;

        Json() {
        }

        @JsonProperty(value="isBasicAuthSupported")
        public void setIsBasicAuthSupported(@Nullable Boolean isBasicAuthSupported) {
            this.isBasicAuthSupported = isBasicAuthSupported;
        }

        @JsonProperty(value="isApiKeyAuthSupported")
        public void setIsApiKeyAuthSupported(@Nullable Boolean isApiKeyAuthSupported) {
            this.isApiKeyAuthSupported = isApiKeyAuthSupported;
        }

        @JsonProperty(value="isOAuth2Supported")
        public void setIsOAuth2Supported(@Nullable Boolean isOAuth2Supported) {
            this.isOAuth2Supported = isOAuth2Supported;
        }

        @JsonProperty(value="isCustomAuthSupported")
        public void setIsCustomAuthSupported(@Nullable Boolean isCustomAuthSupported) {
            this.isCustomAuthSupported = isCustomAuthSupported;
        }

        @JsonProperty(value="oAuth2Defaults")
        public void setOAuth2Defaults(@Nullable OAuth2Defaults oAuth2Defaults) {
            this.oAuth2Defaults = oAuth2Defaults;
        }

        @JsonProperty(value="customAuthConfig")
        public void setCustomAuthConfig(@Nullable List<CustomAuthConfig> customAuthConfig) {
            this.customAuthConfig = customAuthConfig;
        }

        @Override
        public Boolean isBasicAuthSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isApiKeyAuthSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isOAuth2Supported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean isCustomAuthSupported() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OAuth2Defaults oAuth2Defaults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<CustomAuthConfig> customAuthConfig() {
            throw new UnsupportedOperationException();
        }
    }
}

