/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.tests;

import com.amazonaws.appflow.custom.connector.integ.providers.ServiceProvider;
import com.amazonaws.appflow.custom.connector.integ.util.ConfigurationUtil;
import com.amazonaws.services.appflow.AmazonAppflow;
import com.amazonaws.services.appflow.model.ConnectorDetail;
import com.amazonaws.services.appflow.model.ConnectorProfile;
import com.amazonaws.services.appflow.model.DeleteConnectorProfileRequest;
import com.amazonaws.services.appflow.model.DeleteFlowRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesRequest;
import com.amazonaws.services.appflow.model.DescribeConnectorProfilesResult;
import com.amazonaws.services.appflow.model.FlowDefinition;
import com.amazonaws.services.appflow.model.ListConnectorsRequest;
import com.amazonaws.services.appflow.model.ListConnectorsResult;
import com.amazonaws.services.appflow.model.ListFlowsRequest;
import com.amazonaws.services.appflow.model.ListFlowsResult;
import com.amazonaws.services.appflow.model.UnregisterConnectorRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.ITestContext;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;

public class CleanupTest {
    private AmazonAppflow amazonAppflow;
    private String resourcePrefix;
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanupTest.class);

    @BeforeSuite
    public void setUp(ITestContext iTestContext) throws IOException {
        this.amazonAppflow = ServiceProvider.getAppflow();
        this.resourcePrefix = ConfigurationUtil.getTestConfiguration(iTestContext).resourcePrefix().orElse("");
    }

    @AfterSuite
    public void CleanUpConnectorProfiles() {
        DescribeConnectorProfilesResult describeConnectorProfilesResult;
        HashMap<String, ConnectorProfile> profiles = new HashMap<String, ConnectorProfile>();
        String nextToken = null;
        do {
            DescribeConnectorProfilesRequest request = new DescribeConnectorProfilesRequest();
            request.setNextToken(nextToken);
            describeConnectorProfilesResult = this.amazonAppflow.describeConnectorProfiles(request);
            profiles.putAll(describeConnectorProfilesResult.getConnectorProfileDetails().stream().filter(cp -> StringUtils.startsWithIgnoreCase((CharSequence)cp.getConnectorProfileName(), (CharSequence)(this.resourcePrefix + "Integ_Profile_"))).collect(Collectors.toMap(ConnectorProfile::getConnectorProfileName, cp -> cp)));
        } while ((nextToken = describeConnectorProfilesResult.getNextToken()) != null);
        for (String name : profiles.keySet()) {
            LOGGER.info("Deleting Profile " + name);
            this.amazonAppflow.deleteConnectorProfile(new DeleteConnectorProfileRequest().withConnectorProfileName(name).withForceDelete(Boolean.valueOf(true)));
        }
    }

    @AfterSuite
    public void CleanUpConnectors() {
        ListConnectorsResult result;
        HashMap<String, ConnectorDetail> connectorDetails = new HashMap<String, ConnectorDetail>();
        String nextToken = null;
        do {
            ListConnectorsRequest request = new ListConnectorsRequest();
            request.setNextToken(nextToken);
            result = this.amazonAppflow.listConnectors(request);
            connectorDetails.putAll(result.getConnectors().stream().filter(cp -> StringUtils.startsWithIgnoreCase((CharSequence)cp.getConnectorLabel(), (CharSequence)(this.resourcePrefix + "Integ_Connector_"))).collect(Collectors.toMap(ConnectorDetail::getConnectorLabel, cp -> cp)));
        } while ((nextToken = result.getNextToken()) != null);
        for (String name : connectorDetails.keySet()) {
            LOGGER.info("Unregistering Connector " + name);
            this.amazonAppflow.unregisterConnector(new UnregisterConnectorRequest().withConnectorLabel(name).withForceDelete(Boolean.valueOf(true)));
        }
    }

    @AfterSuite
    public void CleanUpFlows() {
        ListFlowsResult result;
        HashMap<String, FlowDefinition> connectorDetails = new HashMap<String, FlowDefinition>();
        String nextToken = null;
        do {
            ListFlowsRequest request = new ListFlowsRequest();
            request.setNextToken(nextToken);
            result = this.amazonAppflow.listFlows(request);
            connectorDetails.putAll(result.getFlows().stream().filter(cp -> StringUtils.startsWithIgnoreCase((CharSequence)cp.getFlowName(), (CharSequence)(this.resourcePrefix + "Integ_Flow_"))).collect(Collectors.toMap(FlowDefinition::getFlowName, cp -> cp)));
        } while ((nextToken = result.getNextToken()) != null);
        for (String name : connectorDetails.keySet()) {
            LOGGER.info("Deleting Flow " + name);
            this.amazonAppflow.deleteFlow(new DeleteFlowRequest().withFlowName(name).withForceDelete(Boolean.valueOf(true)));
        }
    }
}

