/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util.dag;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.dag.CycleDetector;
import org.codehaus.plexus.util.dag.TopologicalSorter;
import org.codehaus.plexus.util.dag.Vertex;

public class DAG
implements Cloneable,
Serializable {
    private Map vertexMap = new HashMap();
    private List vertexList = new ArrayList();

    public void addEdge(String string, String string2) throws CycleDetectedException {
        Vertex vertex = this.addVertex(string);
        Vertex vertex2 = this.addVertex(string2);
        this.addEdge(vertex, vertex2);
    }

    public void addEdge(Vertex vertex, Vertex vertex2) throws CycleDetectedException {
        vertex.addEdgeTo(vertex2);
        vertex2.addEdgeFrom(vertex);
        List list = CycleDetector.introducesCycle(vertex2);
        if (list != null) {
            this.removeEdge(vertex, vertex2);
            String string = "Edge between '" + vertex + "' and '" + vertex2 + "' introduces to cycle in the graph";
            throw new CycleDetectedException(string, list);
        }
    }

    public Vertex addVertex(String string) {
        Vertex vertex = null;
        if (this.vertexMap.containsKey(string)) {
            vertex = (Vertex)this.vertexMap.get(string);
        } else {
            vertex = new Vertex(string);
            this.vertexMap.put(string, vertex);
            this.vertexList.add(vertex);
        }
        return vertex;
    }

    public Object clone() throws CloneNotSupportedException {
        Object object = super.clone();
        return object;
    }

    public List getChildLabels(String string) {
        Vertex vertex = this.getVertex(string);
        return vertex.getChildLabels();
    }

    public Set getLabels() {
        Set set = this.vertexMap.keySet();
        return set;
    }

    public List getParentLabels(String string) {
        Vertex vertex = this.getVertex(string);
        return vertex.getChildLabels();
    }

    public List getSuccessorLabels(String string) {
        ArrayList<String> arrayList;
        Vertex vertex = this.getVertex(string);
        if (vertex.isLeaf()) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(string);
        } else {
            arrayList = TopologicalSorter.sort(vertex);
        }
        return arrayList;
    }

    public Vertex getVertex(String string) {
        Vertex vertex = (Vertex)this.vertexMap.get(string);
        return vertex;
    }

    public List getVerticies() {
        return this.vertexList;
    }

    public boolean hasEdge(String string, String string2) {
        Vertex vertex = this.getVertex(string);
        Vertex vertex2 = this.getVertex(string2);
        boolean bl = vertex.getChildren().contains(vertex2);
        return bl;
    }

    public boolean isConnected(String string) {
        Vertex vertex = this.getVertex(string);
        boolean bl = vertex.isConnected();
        return bl;
    }

    public void removeEdge(String string, String string2) {
        Vertex vertex = this.addVertex(string);
        Vertex vertex2 = this.addVertex(string2);
        this.removeEdge(vertex, vertex2);
    }

    public void removeEdge(Vertex vertex, Vertex vertex2) {
        vertex.removeEdgeTo(vertex2);
        vertex2.removeEdgeFrom(vertex);
    }
}

