/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.FastMap;

public final class CachedMap
implements Map {
    private final FastMap _backingFastMap;
    private final Map _backingMap;
    private final FastMap _keysMap;
    private final int _mask;
    private final Object[] _keys;
    private final Object[] _values;

    public CachedMap() {
        this(256, new FastMap());
    }

    public CachedMap(int n) {
        this(n, new FastMap(n));
    }

    public CachedMap(int n, Map map) {
        int n2 = 1;
        while (n2 < n) {
            n2 <<= 1;
        }
        this._keys = new Object[n2];
        this._values = new Object[n2];
        this._mask = n2 - 1;
        if (map instanceof FastMap) {
            this._backingFastMap = (FastMap)map;
            this._backingMap = this._backingFastMap;
            this._keysMap = null;
        } else {
            this._backingFastMap = null;
            this._backingMap = map;
            this._keysMap = new FastMap(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this._keysMap.put(k, k);
            }
        }
    }

    public void clear() {
        this._backingMap.clear();
        this.flush();
    }

    public boolean containsKey(Object object) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            return true;
        }
        return this._backingMap.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this._backingMap.containsValue(object);
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this._backingMap.entrySet());
    }

    public boolean equals(Object object) {
        return this._backingMap.equals(object);
    }

    public void flush() {
        int n = 0;
        while (n < this._keys.length) {
            this._keys[n] = null;
            this._values[n] = null;
            ++n;
        }
        if (this._keysMap != null) {
            Iterator iterator = this._backingMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this._keysMap.put(k, k);
            }
        }
    }

    public Object get(Object object) {
        int n = object.hashCode() & this._mask;
        return object.equals(this._keys[n]) ? this._values[n] : this.getCacheMissed(object, n);
    }

    public Map getBackingMap() {
        return this._backingFastMap != null ? this._backingFastMap : this._backingMap;
    }

    private Object getCacheMissed(Object object, int n) {
        if (this._backingFastMap != null) {
            Map.Entry entry = this._backingFastMap.getEntry(object);
            if (entry != null) {
                this._keys[n] = entry.getKey();
                Object v = entry.getValue();
                this._values[n] = v;
                return v;
            }
            return null;
        }
        Object object2 = this._keysMap.get(object);
        if (object2 != null) {
            this._keys[n] = object2;
            Object v = this._backingMap.get(object);
            this._values[n] = v;
            return v;
        }
        return null;
    }

    public int getCacheSize() {
        return this._keys.length;
    }

    public int hashCode() {
        return this._backingMap.hashCode();
    }

    public boolean isEmpty() {
        return this._backingMap.isEmpty();
    }

    public Set keySet() {
        return Collections.unmodifiableSet(this._backingMap.keySet());
    }

    public Object put(Object object, Object object2) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            this._values[n] = object2;
        } else if (this._keysMap != null) {
            this._keysMap.put(object, object);
        }
        return this._backingMap.put(object, object2);
    }

    public void putAll(Map map) {
        this._backingMap.putAll(map);
        this.flush();
    }

    public Object remove(Object object) {
        int n = object.hashCode() & this._mask;
        if (object.equals(this._keys[n])) {
            this._keys[n] = null;
        }
        if (this._keysMap != null) {
            this._keysMap.remove(object);
        }
        return this._backingMap.remove(object);
    }

    public int size() {
        return this._backingMap.size();
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this._backingMap.values());
    }
}

