/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.scheduler;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.codehaus.plexus.classloader.PlexusClassLoader;
import org.codehaus.plexus.configuration.XmlPullConfigurationBuilder;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.scheduler.DefaultJobListener;
import org.codehaus.plexus.scheduler.Scheduler;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobListener;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdScheduler;
import org.quartz.impl.StdSchedulerFactory;

public class DefaultScheduler
extends AbstractLogEnabled
implements Scheduler,
Contextualizable,
Configurable,
Initializable,
Startable,
ThreadSafe,
Serviceable {
    private Properties schedulerProperties;
    private StdScheduler scheduler;
    private File jobDirectory;
    private ServiceManager serviceManager;
    private Configuration inlineJobConfigurations;
    private File workDirectory;
    private Context context;
    static /* synthetic */ Class class$org$codehaus$plexus$scheduler$DefaultScheduler;

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public void setJobDirectory(File jobDirectory) {
        this.jobDirectory = jobDirectory;
    }

    public File getJobDirectory() {
        return this.jobDirectory;
    }

    public void setInlineJobConfigurations(Configuration configurations) {
        this.inlineJobConfigurations = configurations;
    }

    public Configuration getInlineJobConfigurations() {
        return this.inlineJobConfigurations;
    }

    Properties getSchedulerProperties() {
        return this.schedulerProperties;
    }

    StdScheduler getScheduler() {
        return this.scheduler;
    }

    ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    public void scheduleJob(JobDetail jobDetail, Trigger trigger) throws SchedulerException {
        this.getLogger().info("scheduling job: " + jobDetail + " " + trigger);
        this.getScheduler().scheduleJob(jobDetail, trigger);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
        try {
            this.workDirectory = (File)context.get((Object)"work.directory");
        }
        catch (ContextException e) {}
    }

    public void service(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.getLogger().info("configure");
        this.configureComponent(configuration);
        this.configureScheduler(configuration.getChild("scheduler", true));
    }

    public void initialize() throws Exception {
        this.initializeScheduler();
        this.initializeJobsFiles();
        this.initializeInlineJobs();
    }

    public void start() throws Exception {
        this.getLogger().info("starting scheduler");
        this.getScheduler().start();
    }

    public void stop() throws Exception {
        this.getLogger().info("stopping scheduler");
        this.getScheduler().shutdown();
    }

    void configureComponent(Configuration configuration) throws ConfigurationException {
        this.setInlineJobConfigurations(configuration.getChild("jobs"));
        String jobDir = configuration.getChild("job-directory").getValue("");
        if (jobDir == null || jobDir.equals("")) {
            this.getLogger().info("job directory specified");
            return;
        }
        if (this.workDirectory == null) {
            this.getLogger().warn("no plexus deployment directory - static job jars will not be loaded");
            return;
        }
        File jobDirectory = new File(this.workDirectory, jobDir);
        if (!jobDirectory.exists()) {
            jobDirectory.mkdirs();
        }
        this.setJobDirectory(jobDirectory);
    }

    void configureScheduler(Configuration configuration) throws ConfigurationException {
        this.schedulerProperties = new Properties();
        Configuration[] propConfigs = configuration.getChildren("property");
        String name = null;
        String value = null;
        int i = 0;
        while (i < propConfigs.length) {
            name = propConfigs[i].getAttribute("name");
            value = propConfigs[i].getAttribute("value");
            this.schedulerProperties.setProperty(name, value);
            ++i;
        }
    }

    void initializeScheduler() throws Exception {
        StdSchedulerFactory factory = new StdSchedulerFactory(this.getSchedulerProperties());
        this.scheduler = (StdScheduler)factory.getScheduler();
        DefaultJobListener jobListener = new DefaultJobListener();
        this.scheduler.addGlobalJobListener((JobListener)jobListener);
    }

    void initializeJobsFiles() throws Exception {
        File jobDir = this.getJobDirectory();
        if (jobDir == null) {
            this.getLogger().info("no job directory configured");
            return;
        }
        File[] jobFiles = jobDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }
        });
        int i = 0;
        while (i < jobFiles.length) {
            this.initializeJobFile(jobFiles[i]);
            ++i;
        }
    }

    public void addJobFile(File jobFile) throws Exception {
        this.getLogger().info("adding job file: " + jobFile.getPath());
        this.initializeJobFile(jobFile);
    }

    void initializeJobFile(File jobFile) throws Exception {
        JarFile jarFile = new JarFile(jobFile);
        Enumeration<JarEntry> entryEnum = jarFile.entries();
        ZipEntry eachEntry = null;
        while (entryEnum.hasMoreElements()) {
            eachEntry = entryEnum.nextElement();
            if (!eachEntry.getName().equals("jobs.xml")) continue;
            this.initializeJobFile(jobFile, jarFile.getInputStream(eachEntry));
            break;
        }
    }

    void initializeJobFile(File jobFile, InputStream jobsConfigStream) throws Exception {
        XmlPullConfigurationBuilder builder = new XmlPullConfigurationBuilder();
        this.getLogger().info("reading jobs.xml");
        Configuration jobsConfig = builder.parse((Reader)new InputStreamReader(jobsConfigStream));
        jobsConfigStream.close();
        ClassLoader parent = (class$org$codehaus$plexus$scheduler$DefaultScheduler == null ? (class$org$codehaus$plexus$scheduler$DefaultScheduler = DefaultScheduler.class$("org.codehaus.plexus.scheduler.DefaultScheduler")) : class$org$codehaus$plexus$scheduler$DefaultScheduler).getClassLoader();
        PlexusClassLoader loader = new PlexusClassLoader(parent);
        loader.addURL(jobFile.toURL());
        this.initializeJobs((ClassLoader)loader, jobsConfig, jobFile.toString());
    }

    void initializeInlineJobs() {
        if (this.getInlineJobConfigurations() == null) {
            return;
        }
        this.getLogger().info("reading inline job specifications");
        ClassLoader loader = (class$org$codehaus$plexus$scheduler$DefaultScheduler == null ? (class$org$codehaus$plexus$scheduler$DefaultScheduler = DefaultScheduler.class$("org.codehaus.plexus.scheduler.DefaultScheduler")) : class$org$codehaus$plexus$scheduler$DefaultScheduler).getClassLoader();
        this.initializeJobs(loader, this.getInlineJobConfigurations(), "inline source");
    }

    void initializeJobs(ClassLoader loader, Configuration jobsConfig, String source) {
        Configuration[] jobConfigs = jobsConfig.getChildren("job");
        int i = 0;
        while (i < jobConfigs.length) {
            try {
                this.initializeJob(loader, jobConfigs[i]);
            }
            catch (Exception e) {
                this.getLogger().error("error initializing job from " + source, (Throwable)e);
            }
            ++i;
        }
    }

    void initializeJob(ClassLoader loader, Configuration jobConfig) throws Exception {
        String name = jobConfig.getChild("name").getValue();
        String group = jobConfig.getChild("group").getValue();
        String className = jobConfig.getChild("class").getValue();
        String cronSpec = jobConfig.getChild("cron-spec").getValue();
        Configuration jobExecutionConfiguration = jobConfig.getChild("configuration");
        this.getLogger().info("new job: " + group + "/" + name + " " + className + " " + cronSpec);
        Class<?> jobClass = loader.loadClass(className);
        JobDetail jobDetail = new JobDetail(name, group, jobClass);
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        jobDataMap.put((Object)"JOB_LOGGER", (Object)this.getLogger());
        jobDataMap.put((Object)"JOB_CONTEXT", (Object)this.getContext());
        jobDataMap.put((Object)"JOB_SERVICE_MANAGER", (Object)this.getServiceManager());
        jobDataMap.put((Object)"JOB_EXECUTION_CONFIGURATION", (Object)jobExecutionConfiguration);
        jobDataMap.setAllowsTransientData(true);
        CronTrigger trigger = new CronTrigger(name, group, name, group, cronSpec);
        this.scheduleJob(jobDetail, (Trigger)trigger);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

