/*
 *  Copyright (c) xlightweb.org, 2008 - 2010. All rights reserved.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * Please refer to the LGPL license at: http://www.gnu.org/copyleft/lesser.txt
 * The latest copy of this software may be found on http://www.xlightweb.org/
 */
package org.xlightweb;


import java.util.Map;

import org.xsocket.connection.ConnectionUtils;



/**
 * 
 * @author grro@xlightweb.org
 */
final class ExtentedHttpUtils {

    
    @SuppressWarnings("unchecked")
    private static final Map<Class, WebSocketHandlerInfo> webSocketHandlerInfoCache = ConnectionUtils.newMapCache(25);
    private static final WebSocketHandlerInfo EMPTY_WEB_SOCKET_HANDLER_INFO = new WebSocketHandlerInfo(null);

    @SuppressWarnings("unchecked")
    private static final Map<Class, IEventHandlerInfo> webEventHandlerInfoCache = ConnectionUtils.newMapCache(25);
    private static final IEventHandlerInfo EMPTY_WEB_EVENT_HANDLER_INFO = new IEventHandlerInfo(null);

    
    @SuppressWarnings("unchecked")
    static WebSocketHandlerInfo getWebSocketHandlerInfo(IWebSocketHandler webSocketHandler) {
        if (webSocketHandler == null) {
            return EMPTY_WEB_SOCKET_HANDLER_INFO;
        }

        WebSocketHandlerInfo webSocketHandlerInfo = webSocketHandlerInfoCache.get(webSocketHandler.getClass());

        if (webSocketHandlerInfo == null) {
            webSocketHandlerInfo = new WebSocketHandlerInfo((Class<IWebSocketHandler>) webSocketHandler.getClass());
            webSocketHandlerInfoCache.put(webSocketHandler.getClass(), webSocketHandlerInfo);
        }

        return webSocketHandlerInfo;
    }
    
    
    @SuppressWarnings("unchecked")
    static IEventHandlerInfo getWebEventHandlerInfo(IEventHandler webEventHandler) {
        if (webEventHandler == null) {
            return EMPTY_WEB_EVENT_HANDLER_INFO;
        }

        IEventHandlerInfo webEventHandlerInfo = webEventHandlerInfoCache.get(webEventHandler.getClass());

        if (webEventHandlerInfo == null) {
            webEventHandlerInfo = new IEventHandlerInfo((Class<IEventHandler>) webEventHandler.getClass());
            webEventHandlerInfoCache.put(webEventHandler.getClass(), webEventHandlerInfo);
        }

        return webEventHandlerInfo;
    }    
}
