package org.ton.block

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import org.ton.cell.*
import org.ton.tlb.*
import org.ton.tlb.providers.TlbConstructorProvider

@Serializable
@SerialName("prev_blks_info")
public data class PrevBlksInfo(
    val prev1: CellRef<ExtBlkRef>, // prev1 : ^ExtBlkRef
    val prev2: CellRef<ExtBlkRef> // prev2 : ^ExtBlkRef
) : BlkPrevInfo {
    override fun print(printer: TlbPrettyPrinter): TlbPrettyPrinter = printer.type("prev_blks_info") {
        field("prev1", prev1)
        field("prev2", prev2)
    }

    override fun toString(): String = print().toString()

    public companion object : TlbConstructorProvider<PrevBlksInfo> by PrevBlksInfoTlbConstructor
}

private object PrevBlksInfoTlbConstructor : TlbConstructor<PrevBlksInfo>(
    schema = "prev_blks_info\$_ prev1:^ExtBlkRef prev2:^ExtBlkRef = BlkPrevInfo 1;"
) {
    private val cellRef = CellRef.tlbCodec(ExtBlkRef)

    override fun storeTlb(
        cellBuilder: CellBuilder,
        value: PrevBlksInfo
    ) = cellBuilder {
        storeTlb(cellRef, value.prev1)
        storeTlb(cellRef, value.prev2)
    }

    override fun loadTlb(
        cellSlice: CellSlice
    ): PrevBlksInfo = cellSlice {
        val prev1 = loadTlb(cellRef)
        val prev2 = loadTlb(cellRef)
        PrevBlksInfo(prev1, prev2)
    }
}
