/*
 * Decompiled with CFR 0.152.
 */
package org.junit;

import java.util.Objects;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert$;
import org.junit.ComparisonFailure;
import org.junit.function.ThrowingRunnable;
import org.junit.internal.ExactComparisonCriteria;
import org.junit.internal.InexactComparisonCriteria;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;

public final class Assert$ {
    public static Assert$ MODULE$;

    static {
        new Assert$();
    }

    public void assertTrue(String message, boolean condition) {
        if (!condition) {
            this.fail(message);
            return;
        }
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(null, condition);
    }

    public void assertFalse(String message, boolean condition) {
        this.assertTrue(message, !condition);
    }

    public void assertFalse(boolean condition) {
        this.assertFalse(null, condition);
    }

    public void fail(String message) {
        if (message == null) {
            throw new AssertionError();
        }
        throw new AssertionError((Object)message);
    }

    public void fail() {
        this.fail(null);
    }

    public void assertEquals(String message, Object expected, Object actual) {
        if (!this.equalsRegardingNull(expected, actual)) {
            Tuple2 tuple2 = new Tuple2(expected, actual);
            if (tuple2 != null) {
                Object expectedString = tuple2._1();
                Object actualString = tuple2._2();
                if (expectedString instanceof String) {
                    String string = (String)expectedString;
                    if (actualString instanceof String) {
                        String string2 = (String)actualString;
                        String cleanMsg = message == null ? "" : message;
                        throw new ComparisonFailure(cleanMsg, string, string2);
                    }
                }
            }
            this.failNotEquals(message, expected, actual);
            return;
        }
    }

    private boolean equalsRegardingNull(Object expected, Object actual) {
        if (expected == null) {
            return actual == null;
        }
        return this.org$junit$Assert$$isEquals(expected, actual);
    }

    public boolean org$junit$Assert$$isEquals(Object expected, Object actual) {
        return Objects.equals(expected, actual);
    }

    public void assertEquals(Object expected, Object actual) {
        this.assertEquals(null, expected, actual);
    }

    public void assertNotEquals(String message, Object unexpected, Object actual) {
        if (this.equalsRegardingNull(unexpected, actual)) {
            this.failEquals(message, actual);
            return;
        }
    }

    public void assertNotEquals(Object unexpected, Object actual) {
        this.assertNotEquals(null, unexpected, actual);
    }

    private void failEquals(String message, Object actual) {
        String checkedMessage = message != null ? message : "Values should be different";
        this.fail(new StringBuilder(10).append(checkedMessage).append(". Actual: ").append(actual).toString());
    }

    public void assertNotEquals(String message, long unexpected, long actual) {
        if (unexpected == actual) {
            this.failEquals(message, BoxesRunTime.boxToLong((long)actual));
            return;
        }
    }

    public void assertNotEquals(long unexpected, long actual) {
        this.assertNotEquals((String)null, unexpected, actual);
    }

    public void assertNotEquals(String message, double unexpected, double actual, double delta) {
        if (!this.doubleIsDifferent(unexpected, actual, delta)) {
            this.failEquals(message, BoxesRunTime.boxToDouble((double)actual));
            return;
        }
    }

    public void assertNotEquals(double unexpected, double actual, double delta) {
        this.assertNotEquals(null, unexpected, actual, delta);
    }

    public void assertNotEquals(float unexpected, float actual, float delta) {
        this.assertNotEquals((String)null, unexpected, actual, delta);
    }

    public void assertEquals(double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(String message, double expected, double actual) {
        this.fail("Use assertEquals(expected, actual, delta) to compare floating-point numbers");
    }

    public void assertEquals(long expected, long actual) {
        this.assertEquals((String)null, expected, actual);
    }

    public void assertEquals(String message, long expected, long actual) {
        this.assertEquals(message, BoxesRunTime.boxToLong((long)expected), BoxesRunTime.boxToLong((long)actual));
    }

    public void assertArrayEquals(String message, Object[] expecteds, Object[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(Object[] expecteds, Object[] actuals) {
        this.assertArrayEquals(null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, boolean[] expecteds, boolean[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(boolean[] expecteds, boolean[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, byte[] expecteds, byte[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(byte[] expecteds, byte[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, char[] expecteds, char[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(char[] expecteds, char[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, short[] expecteds, short[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(short[] expecteds, short[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, int[] expecteds, int[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(int[] expecteds, int[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, long[] expecteds, long[] actuals) {
        this.internalArrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(long[] expecteds, long[] actuals) {
        this.assertArrayEquals((String)null, expecteds, actuals);
    }

    public void assertArrayEquals(String message, double[] expecteds, double[] actuals, double delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(double[] expecteds, double[] actuals, double delta) {
        this.assertArrayEquals(null, expecteds, actuals, delta);
    }

    public void assertArrayEquals(String message, float[] expecteds, float[] actuals, float delta) {
        new InexactComparisonCriteria(delta).arrayEquals(message, expecteds, actuals);
    }

    public void assertArrayEquals(float[] expecteds, float[] actuals, float delta) {
        this.assertArrayEquals((String)null, expecteds, actuals, delta);
    }

    private void internalArrayEquals(String message, Object expecteds, Object actuals) {
        new ExactComparisonCriteria().arrayEquals(message, expecteds, actuals);
    }

    public void assertEquals(String message, double expected, double actual, double delta) {
        if (this.doubleIsDifferent(expected, actual, delta)) {
            this.failNotEquals(message, BoxesRunTime.boxToDouble((double)expected), BoxesRunTime.boxToDouble((double)actual));
            return;
        }
    }

    public void assertEquals(String message, float expected, float actual, float delta) {
        if (this.floatIsDifferent(expected, actual, delta)) {
            this.failNotEquals(message, BoxesRunTime.boxToFloat((float)expected), BoxesRunTime.boxToFloat((float)actual));
            return;
        }
    }

    public void assertNotEquals(String message, float unexpected, float actual, float delta) {
        if (!this.floatIsDifferent(unexpected, actual, delta)) {
            this.failEquals(message, BoxesRunTime.boxToFloat((float)actual));
            return;
        }
    }

    private boolean doubleIsDifferent(double d1, double d2, double delta) {
        return Double.compare(d1, d2) != 0 && Math.abs(d1 - d2) > delta;
    }

    private boolean floatIsDifferent(float f1, float f2, float delta) {
        return Float.compare(f1, f2) != 0 && Math.abs(f1 - f2) > delta;
    }

    public void assertEquals(double expected, double actual, double delta) {
        this.assertEquals(null, expected, actual, delta);
    }

    public void assertEquals(float expected, float actual, float delta) {
        this.assertEquals((String)null, expected, actual, delta);
    }

    public void assertNotNull(String message, Object obj) {
        this.assertTrue(message, obj != null);
    }

    public void assertNotNull(Object obj) {
        this.assertNotNull(null, obj);
    }

    public void assertNull(String message, Object obj) {
        if (obj != null) {
            this.failNotNull(message, obj);
            return;
        }
    }

    public void assertNull(Object obj) {
        this.assertNull(null, obj);
    }

    private void failNotNull(String message, Object actual) {
        String formatted = message != null ? new StringBuilder(1).append(message).append(" ").toString() : "";
        this.fail(new StringBuilder(26).append(formatted).append("expected null, but was:<").append(actual).append("}>").toString());
    }

    public void assertSame(String message, Object expected, Object actual) {
        if (expected != actual) {
            this.failNotSame(message, expected, actual);
            return;
        }
    }

    public void assertSame(Object expected, Object actual) {
        this.assertSame(null, expected, actual);
    }

    public void assertNotSame(String message, Object unexpected, Object actual) {
        if (unexpected == actual) {
            this.failSame(message);
            return;
        }
    }

    public void assertNotSame(Object unexpected, Object actual) {
        this.assertNotSame(null, unexpected, actual);
    }

    private void failSame(String message) {
        if (message == null) {
            this.fail("expected not same");
            return;
        }
        this.fail(new StringBuilder(18).append(message).append(" expected not same").toString());
    }

    private void failNotSame(String message, Object expected, Object actual) {
        if (message == null) {
            this.fail(new StringBuilder(27).append("expected same:<").append(expected).append("> was not:<").append(actual).append(">").toString());
            return;
        }
        this.fail(new StringBuilder(28).append(message).append(" expected same:<").append(expected).append("> was not:<").append(actual).append(">").toString());
    }

    private void failNotEquals(String message, Object expected, Object actual) {
        this.fail(this.format(message, expected, actual));
    }

    /*
     * Unable to fully structure code
     */
    public String format(String message, Object expected, Object actual) {
        if (message == null) ** GOTO lbl-1000
        v0 = message;
        var5_4 = "";
        if (v0 == null ? var5_4 != null : v0.equals(var5_4) == false) {
            v1 = new StringBuilder(1).append(message).append(" ").toString();
        } else lbl-1000:
        // 2 sources

        {
            v1 = "";
        }
        formatted = v1;
        expectedString = String.valueOf(expected);
        actualString = String.valueOf(actual);
        v2 = expectedString;
        var8_8 = actualString;
        if (!(v2 != null ? v2.equals(var8_8) == false : var8_8 != null)) {
            expectedFormatted = this.formatClassAndValue(expected, expectedString);
            actualFormatted = this.formatClassAndValue(actual, actualString);
            return new StringBuilder(20).append(formatted).append("expected: ").append(expectedFormatted).append(" but was: ").append(actualFormatted).toString();
        }
        return new StringBuilder(22).append(formatted).append("expected:<").append(expectedString).append("> but was:<").append(actualString).append(">").toString();
    }

    private String formatClass(Class<?> value) {
        return value.getName();
    }

    private String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return new StringBuilder(2).append(className).append("<").append(valueString).append(">").toString();
    }

    public <T> void assertThat(T actual, Matcher<T> matcher) {
        this.assertThat("", actual, matcher);
    }

    public <T> void assertThat(String reason, T actual, Matcher<T> matcher) {
        MatcherAssert$.MODULE$.assertThat(reason, actual, matcher);
    }

    public <T extends Throwable> T assertThrows(Class<T> expectedThrowable, ThrowingRunnable runnable) {
        return this.assertThrows(null, expectedThrowable, runnable);
    }

    public <T extends Throwable> T assertThrows(String message, Class<T> expectedThrowable, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && expectedThrowable.isInstance(throwable2 = throwable3)) {
                return (T)throwable2;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                String expected = this.formatClass(expectedThrowable);
                String actual = this.formatClass(throwable4.getClass());
                String mismatchMessage = new StringBuilder(0).append(Assert$.buildPrefix$1(message)).append(this.format("unexpected exception type thrown;", expected, actual)).toString();
                AssertionError assertionError = new AssertionError((Object)mismatchMessage);
                ((Throwable)((Object)assertionError)).initCause(throwable4);
                throw assertionError;
            }
            throw throwable;
        }
        String notThrownMessage = new StringBuilder(46).append(Assert$.buildPrefix$1(message)).append("expected ").append(this.formatClass(expectedThrowable)).append(" to be thrown,").append(" but nothing was thrown").toString();
        throw new AssertionError((Object)notThrownMessage);
    }

    private static final String buildPrefix$1(String message$1) {
        if (message$1 != null) {
            return new StringBuilder(2).append(message$1).append(": ").toString();
        }
        return "";
    }

    private Assert$() {
        MODULE$ = this;
    }
}

